<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'user-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<style>
    .modal-xl {
        width: 96% !important;
        max-width: 96% !important;
    }
</style>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material row">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <label for="first_name">First Name <span style="color:red;">*</span></label>
                <?php echo $form->textField($model, 'first_name', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="last_name">Last Name <span style="color:red;">*</span></label>
                <?php echo $form->textField($model, 'last_name', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="phno">Phone Number <span style="color:red;">*</span></label>
                <?php echo $form->textField($model, 'phno', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="email">Email <span style="color:red;">*</span></label>
                <?php echo $form->textField($model, 'email', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="designation">Designation</label>
                <?php echo $form->dropdownList($model, 'designation', MasDesignation::getDesignations(), array('data-label' => '','class'=>'form-control tooltipster', 'prompt' => '--Select--')); ?>
            </li>
            <li class="col-sm-3">
                <label for="user_group_id">User Group <span style="color:red;">*</span></label>
                <?php echo $form->dropdownList($model, 'user_group_id', MasUserGroup::getUserGroup(), array(
                    'onchange' => 'if(this.value=="2"){ 
                        $("#manager_iris_main").show();
                        $("#manager_iris_sub").show();
                    }else {
                        $("#manager_iris_main").hide();
                        $("#manager_iris_sub").hide();
                    }',
                    'data-label' => '',
                    'class'=>'form-control tooltipster',
                    'prompt' => '--Select--'
                )); ?>
            </li>
            <li class="col-sm-3">
                <label for="username">User Name <span style="color:red;">*</span></label>
                <?php echo $form->textField($model, 'username', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="password">Password <span style="color:red;">*</span></label>
                <?php
                $model->password = '';
                echo $form->passwordField($model, 'password', array('data-label' => '','class'=>'form-control tooltipster', 'onclick' => 'getpassword(this.val);', 'onfocus' => 'getpassword(this.val);', 'onblur' => 'setpassword(this.val);'));
                ?>
                <?php echo CHtml::hiddenField('hid_password', $model->password); ?>
            </li>
            <div class="clearfix"></div>
            <li class="col-sm-3">
                <label for="iris_main">IRIS MAIN EXPENSE A/C CONSULTANT</label>
                <?php echo $form->textField($model, 'iris_main', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="iris_sub">IRIS SUB EXPENSE A/C CONSULTANT</label>
                <?php echo $form->textField($model, 'iris_sub', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="deferment_main">IRIS MAIN A/C DIFFEREMENT</label>
                <?php echo $form->textField($model, 'deferment_main', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="deferment_sub">IRIS SUB A/C DIFFEREMENT</label>
                <?php echo $form->textField($model, 'deferment_sub', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="commission_main">IRIS MAIN A/C CONSULTANT MDA</label>
                <?php echo $form->textField($model, 'commission_main', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="commission_sub">IRIS SUB A/C CONSULTANT MDA</label>
                <?php echo $form->textField($model, 'commission_sub', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <?php
            $style = 'display:none;';
            if ($model->user_group_id == 2) {
                $style = 'display:block;';
            }
            ?>
            <li class="col-sm-3" id="manager_iris_main" style="<?php echo $style; ?>">
                <label for="manager_iris_main">IRIS MAIN A/C MANAGER MDA</label>
                <?php echo $form->textField($model, 'manager_iris_main', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3" id="manager_iris_sub" style="<?php echo $style; ?>">
                <label for="manager_iris_sub">IRIS SUB A/C MANAGER MDA</label>
                <?php echo $form->textField($model, 'manager_iris_sub', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <label for="commission_scheme_id">Commission Scheme <span style="color:red;">*</span></label>
                <?php echo $form->dropdownList($model, 'commission_scheme_id', MasterCommissionSchemes::getScheme(), array('data-label' => '','class'=>'form-control tooltipster', 'empty' => '-Select-')); ?>
            </li>
            <li class="col-sm-3">
                <label for="manager_id">Manager</label>
                <?php echo $form->dropdownList($model, 'manager_id', User::getManagers(), array('data-search' => true, 'data-label' => '','class'=>'form-control tooltipster select2', 'empty' => '-Select-')); ?>
            </li>
            <li class="col-sm-3">
                <label for="assistant_manager_id">Assistant Manager</label>
                <?php echo $form->dropdownList($model, 'assistant_manager_id', User::getUsers(), array('data-search' => true, 'data-label' => '','class'=>'form-control tooltipster select2', 'empty' => '-Select-')); ?>
            </li>
            <?php
            if ($model->id == '') {
                ?>
                <li class="col-sm-3">
                    <label for="manager_self">Assign as Manager</label>
                    <?php echo $form->checkBox($model, 'manager_self', array('data-label' => '','class'=>'')); ?>
                </li>
                <li class="col-sm-3">
                    <label for="asstmanager_self">Assign as Assistant Manager</label>
                    <?php echo $form->checkBox($model, 'asstmanager_self', array('data-label' => '','class'=>'')); ?>
                </li>
            <?php } ?>
            <li class="col-sm-3">
                <label for="consultant_edit">Consultant Edit</label>
                <?php echo $form->dropdownList($model, 'consultant_edit', array('Y' => 'Y', 'N' => 'N'), array('data-label' => '','class'=>'form-control tooltipster', 'empty' => '-Select-')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->labelEx($model, 'profile_photo');
                $allowedExtensions = array("jpg", "jpeg");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                        'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/profilephotos')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => 3 * 1024 * 1024,
                        'onStart' => "js:function(){}",
                        'onComplete' => "js:function(id, fileName, responseJSON){
                                                  $('#User_profile_photo').val(responseJSON.filename);
                                                  $('#div_employee_profile_photo').html('<img width=\'100\' height=\'100\' src=\"" . Yii::app()->baseUrl . "/uploads/profilephotos/'+responseJSON.filename+'\" />')
                                           }",
                    )
                ));
                ?>
                <div class="each_image1">
                    <?php if ($model->id && $model->profile_photo != ''): ?>
                        <div id="div_employee_profile_photo" class="each_image">
                            <img id="img_employee_profile_photo"
                                src="<?php echo Yii::app()->baseUrl; ?>/uploads/profilephotos/<?php echo $model->profile_photo; ?>"
                                width='100' height='100' />
                        </div>
                    <?php endif; ?>
                    <?php echo $form->hiddenField($model, 'profile_photo'); ?>
                </div>

            </li>
        </ul>
    </div>

</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="btn-userclose" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('user/SaveUsers');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){  
                if(data.scenario=="add"){  
                    t8.error("Please connect this user with different user accounts");
                }
                 t8.success("User Saved Successfully!");
                 $("#btn-userclose").click();
                 reloadTable("#tbl_user_details");
            } else { 
                $("#user-form .user-save-btn").prop("disabled", false);
                $("#user-form .user-save-btn").addClass("btn-theme").removeClass("btn_loding");
                $.each(data, function(key, val) {
                    $("#user-form #"+key+"_em_").text(val).show(); 
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $("#user-form .user-save-btn").prop("disabled", true);
            $("#user-form .user-save-btn").addClass("btn_loding").removeClass("btn-theme");
            $(".toast8-error").hide();
        }',
    ), array('id' => 'mybtn' . rand(), 'class' => 'user-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getpassword", "function getpassword(value)
    {
        var user_password = $('#hid_password').val();
        $('#User_password').val('');
    }", CClientScript::POS_HEAD);
$cs->registerScript("setpassword", "function setpassword()
    {
        var user_password = $('#hid_password').val();
        var new_password = $('#User_password').val();
        if(new_password=='')
        {
            $('#User_password').val(user_password);
        }
    }", CClientScript::POS_HEAD);





