<?php
$users_array[] = Yii::app()->user->id;
$explode_connected_users = explode(',', Yii::app()->user->connected_users);
if (count($explode_connected_users) > 0) {
    foreach ($explode_connected_users AS $user) {
        $users_array[] = $user;
    }
}
$connected_users = implode(",", array_filter($users_array));
?>
<div id="div_master_report_customerlist row">
    <ul class="clearfix form-ul material" id="customerlist-form-hide">
        <div class="row">
        <li class="col-sm-3">
            <label>Customer</label>
            <?php echo CHtml::textField('ex_comm_customer_name', '', array('class' => 'form-control tooltipster', 'title' => 'Please choose a customer', 'placeholder' => 'Choose customer', 'data-label' => 'Customer ', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"commissionledger");')); ?>
            <?php echo CHtml::hiddenField('ex_comm_customer_id'); ?>
        </li>
         <li class="col-sm-3">
             <label>Provider</label>
            <div class="material">
                <?php
                echo CHtml::dropDownList('ex_comm_provider', '', Provider::getAll(), array('class' => 'form-control tooltipster select2', 'data-label' => 'Provider', 'data-search' => 'true', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-2">
            <label>User</label>
            <div class="material">    
                <?php
                echo CHtml::dropDownList('ex_comm_executive', '',User::getConnectedUsers($connected_users), array('class' => 'form-control tooltipster select2', 'data-label' => 'User', 'data-search' => 'true', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-2">
            <label>From</label>
            <div class="material">
                <?php echo CHtml::textField('ex_comm_from_date', '', array('class' => 'form-control tooltipster datepicker ', 'title' => 'Please', 'placeholder' => '', 'data-label' => 'From')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <label>To</label>
            <div class="material">
                <?php echo CHtml::textField('ex_comm_to_date', '', array('class' => 'form-control tooltipster datepicker ', 'title' => 'Please', 'placeholder' => '', 'data-label' => 'To')); ?>
            </div>
        </li>      
        </div>
    </ul>
</div>
<div class='btn-wrap text-right row'>
    <input type="button" value="" onclick="loadMasterReport(1); return false;" class='btn btn-theme comm_view report_view' title="View">
    <input type="button" value="" onclick="loadMasterReport(2); return false;" class='btn btn-theme comm_pdf report_pdf' title="View as PDF">
    <input type="button" value="" onclick="loadMasterReport(3); return false;" class='btn btn-theme comm_excel report_excel' title="Download Excel">
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    $('#ex_comm_from_date, #ex_comm_to_date').datepicker({dateFormat:'dd/mm/yy'})
});", CClientScript::POS_HEAD);
$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id,frm){
    $('#ex_comm_customer_id').val('');
    var url = '" . Yii::app()->createUrl('reports/GetCustomerDetails') . "'+'&frm='+frm;
    $('#'+field_id).autocomplete({
    minLength   : 1,
    source      : function (request, response) { autoCompleteSource(request, response,url) },
    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
    select          : function( event, ui ) {
        event.preventDefault();
        trigger_target_id  	=   $(event.target).attr('id');
        var customer_id=ui.item.value;
        $('#ex_comm_customer_id').val(customer_id);
        }
    })
}", CClientScript::POS_HEAD);
?>

<script>
    
    $(document).ready(function(){
    $("#ex_comm_provider").select2();
    $("#ex_comm_executive").select2();
    });
        
    </script>