<div id="div_master_report_customerlist row">
    <ul class="clearfix form-ul material" id="customerlist-form-hide">
        <div class="row">
        <li class="col-sm-4">
            <label>Customer</label>
            <?php echo CHtml::textField('commission_customer_name', '', array('class' => 'form-control tooltipster', 'title' => 'Please choose a customer', 'placeholder' => 'Choose customer', 'data-label' => 'Customer ', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"commissionledger");')); ?>
            <?php echo CHtml::hiddenField('commission_customer_id'); ?>
        </li>
        <li class="col-sm-2">
            <label>From</label>
            <div class="material">
                <?php echo CHtml::textField('commission_ledger_from_date', '', array('class' => 'form-control tooltipster datepicker ', 'title' => 'Please', 'placeholder' => '', 'data-label' => 'From')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <label>To</label>
            <div class="material">
                <?php echo CHtml::textField('commission_ledger_to_date', '', array('class' => 'form-control tooltipster datepicker ', 'title' => 'Please', 'placeholder' => '', 'data-label' => 'To')); ?>
            </div>
        </li>
        
        <li class="col-sm-2">
            <label>User</label>
            <div class="material">
                <?php
                echo CHtml::dropDownList('commission_ledger_user', '', User::getAllUsers(), array('class' => 'form-control tooltipster select2', 'data-label' => 'User', 'data-search' => 'true', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-2">
            <label>Provider</label>
            <div class="material">
                <?php
                echo CHtml::dropDownList('commission_ledger_provider', '', Provider::getAll(), array('class' => 'form-control tooltipster select2', 'data-label' => 'Provider', 'data-search' => 'true', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-2">
            <label>Type</label>
            <div class="material">
                <?php
                echo CHtml::dropDownList('commission_ledger_type', '', array('IN'=>'IN','OUT'=>'OUT'), array('class' => 'form-control tooltipster select2', 'data-label' => 'Type', 'data-search' => 'true', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-2">
            <label>Account Type</label>
            <div class="material">
                <?php
                echo CHtml::dropDownList('commission_account_type', '', array('GEN'=>'GENERAL','VAT'=>'VAT','DEF'=>'DEFERMENT','QUA'=>'QUARTER','ANN'=>'ANNUAL'), array('class' => 'form-control tooltipster select2', 'data-label' => 'Account Type', 'data-search' => 'true', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        </div>
    </ul>
</div>
<div class='btn-wrap text-right row'>
    <input type="button" value="" onclick="loadMasterReport(1);
            return false;" class='btn btn-theme activity_view report_view' title="View">
    <input type="button" value="" onclick="loadMasterReport(2);
            return false;" class='btn btn-theme activity_pdf report_pdf' title="View as PDF">
    <input type="button" value="" onclick="loadMasterReport(3);
            return false;" class='btn btn-theme activity_excel report_excel' title="Download Excel">
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    $('#commission_ledger_from_date, #commission_ledger_to_date').datepicker({dateFormat:'dd/mm/yy'})
});", CClientScript::POS_HEAD);
$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id,frm){
    $('#commission_customer_id').val('');
    var url = '" . Yii::app()->createUrl('reports/GetCustomerDetails') . "'+'&frm='+frm;
    $('#'+field_id).autocomplete({
    minLength   : 1,
    source      : function (request, response) { autoCompleteSource(request, response,url) },
    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
    select          : function( event, ui ) {
        event.preventDefault();
        trigger_target_id  	=   $(event.target).attr('id');
        var customer_id=ui.item.value;
        $('#commission_customer_id').val(customer_id);
        }
    })
}", CClientScript::POS_HEAD);
?>

<script>
    
    $(document).ready(function(){
    $("#commission_ledger_user").select2();
    $("#commission_ledger_provider").select2();
    $("#commission_ledger_type").select2();
    $("#commission_account_type").select2();
   
    });
        
    </script>