<?php
$users_array[] = Yii::app()->user->id;
$explode_connected_users = explode(',', Yii::app()->user->connected_users);
if (count($explode_connected_users) > 0) {
    foreach ($explode_connected_users AS $user) {
        $users_array[] = $user;
    }
}
$connected_users = implode(",", array_filter($users_array));
?>
<div id="div_master_report_customerlist row">
    <ul class="clearfix form-ul material" id="customerlist-form-hide">
        <div class="row">
        <li class="col-sm-4">
            <label>Customer</label>
            <?php echo CHtml::textField('activity_customer_name', '', array('class' => 'form-control tooltipster', 'title' => 'Please choose a customer', 'placeholder' => 'Please choose a customer', 'data-label' => 'Customer ', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"activitylist");')); ?>
            <?php echo CHtml::hiddenField('activity_customer_id'); ?>
        </li>
        <li class="col-sm-4">
            <label>Type</label>
            <div class="material">    
                <?php echo CHtml::dropDownList('activity_type', '', array(
                        '1' => 'Calls',
                        '2' => 'Appointment', 
                        '3' => 'Joint Field Visit', 
                        '4' => 'Fact Find', 
                        '5' => 'Presentation',
                        '6'=>'Application',
                        '7'=>'Review Meeting',
                    ), array('class' => 'form-control tooltipster select2', 'data-label' => 'Type', 'data-search' => 'true', 'empty' => 'Select')); ?>
            </div>
        </li>
        <li class="col-sm-4">
            <label>User</label>
            <div class="material">    
                <?php
                echo CHtml::dropDownList('activity_user', '',User::getConnectedUsers($connected_users), array('class' => 'form-control tooltipster select2', 'data-label' => 'User', 'data-search' => 'true', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        </div>
        <div class="row">
        <li class="col-sm-3">
            <label>Planned Date From</label>
            <div class="material">    
            <?php echo CHtml::textField('activity_plan_from_date','', array('class' => 'form-control datepicker', 'data-label' => 'Planned Date From ')); ?>
            <?php
// echo CHtml::tag('input', array(
//     'type' => 'date', 
//     'name' => 'activity_plan_from_date', 
//     'class' => 'form-control', 
//     'data-label' => 'Planned Date From '
// ));
// Create a date input field with 'CHtml::tag()' method
/*echo CHtml::tag('input', array(
    'type' => 'date',  // This ensures the input is of type date
    'name' => 'activity_plan_from_date',
    'value' => '',  // Optional, you can set a default value here
    'class' => 'form-control',  // Add Bootstrap's form control class
    'data-label' => 'Planned Date From'
));*/
?>
        </div>                            
        </li>
        <li class="col-sm-3">                            
            <label>Planned Date To</label>
            <div class="material">    
                <?php echo CHtml::textField('activity_plan_to_date','', array('class' => 'form-control datepicker', 'data-label' => 'Planned Date To ')); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <label>Actual Date From</label>
            <div class="material">    
                <?php echo CHtml::textField('activity_actual_from_date','', array('class' => 'form-control datepicker', 'data-label' => 'Actual Date From ')); ?>
            </div>                            
        </li>
        <li class="col-sm-3">
            <label>Actual Date To</label>                            
            <div class="material">    
                <?php echo CHtml::textField('activity_actual_to_date','', array('class' => 'form-control datepicker', 'data-label' => 'Actual Date Actual Date ToTo ')); ?>
            </div>
        </li>
        </div>
    </ul>
</div>
<div class='btn-wrap text-right row'>
    <input type="button" value="" onclick="loadMasterReport(1);return false;" class='form-control activity_report btn btn-theme report_view' title="View Activity List">
    <input type="button" value="" onclick="loadMasterReport(2);return false;" class='activity_report_pdf btn btn-theme report_pdf' title="View as PDF">
    <input type="button" value="" onclick="loadMasterReport(3);return false;" class='activity_report_excel btn btn-theme report_excel' title="Download Excel">
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    $('#activity_plan_from_date, #activity_plan_to_date, #activity_actual_from_date, #activity_actual_to_date').datepicker({dateFormat:'dd/mm/yy'})
});", CClientScript::POS_HEAD);
$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id,frm){
    $('#activity_customer_id').val('');
    var url = '" . Yii::app()->createUrl('reports/GetCustomerDetails') . "'+'&frm='+frm;
    $('#'+field_id).autocomplete({
    minLength   : 1,
    source      : function (request, response) { autoCompleteSource(request, response,url) },
    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
    select          : function( event, ui ) {
        event.preventDefault();
        trigger_target_id  	=   $(event.target).attr('id');
        var customer_id=ui.item.value; 
        $('#activity_customer_id').val(customer_id);
        }
    })
}", CClientScript::POS_HEAD);


// $cs->registerScript('datepicker-init', "
//     $(function() {
//         $('.datepicker').datepicker({
//             dateFormat: 'dd/mm/yy', // Adjust format as needed
//             changeMonth: true,
//             changeYear: true
//         });
//     });
// ", CClientScript::POS_READY);
?>

<script>
    
    $(document).ready(function(){
      $("#activity_type").select2();
      $("#activity_user").select2();
   
    });
        
    </script>