<!DOCTYPE html>
<html>
<head>
    <title>Pending Policy List Report</title>
</head>
<body>

<!-- HEADER -->
<div class="heading">
    <div class="logo col-6"><img src="images/pdf_logo.jpg"></div>
    <div class="companay_name col-6 text-right"></div>
</div>
<div class="clearfix"></div>

<!-- TITLE -->
<div class="title">
    <div class="col-6"><div style="height: 10px;"></div></div>
    <div class="col-6 text-right">
        <h1>Pending Policy List Report</h1>
        <div class="details-box"></div>
    </div>
</div>

<!-- REPORT CONTENT -->
<?php
$payment_term = array(
    "1" => "Monthly",
    "2" => "Bi-Monthly",
    "3" => "Quarterly",
    "4" => "Half-Yearly",
    "5" => "Yearly",
);
?>
<div class="panel" style="margin-top: -29px;">
    <div class="panel-heading panel-theme clearfix report-head">
        <div class="pull-right">
            <div class="filter_details">
                <div class="filter-item"></div>
            </div>
        </div>
    </div>

    <div class="panel-body">
        <div class="table-responsive">
            <table class="table table-fixed table-bordered table-primary">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Customer ID</th>
                        <th>Customer</th>
                        <th>Provider</th>
                        <th>Plan Name</th>
                        <th>Amount</th>
                        <th>Payment Term</th>
                        <th>Annualized Premium</th>
                    </tr>
                </thead>
                <tbody style="padding: 4px 5px;font-size: 13px;">
                    <?php
                    $condition = '(cust_executive_id ="' . Yii::app()->user->id . '" OR customer.cust_executive_id IN (' . Yii::app()->user->connected_users . '))';
                    if ($custlist_customer_id != "") {
                        $condition .= " AND t.customer_id = '".$custlist_customer_id."'";
                    }
                    if ($payment != "") {
                        $condition .= " AND t.payment_term = '".$payment."'";
                    }
                    if ($provider != "") {
                        $condition .= " AND t.provider_id = '". $provider."'";
                    }
                    if ($plan_id != "") {
                        $condition .= " AND t.plan_id = '". $plan_id."'";
                    }
                    if ($policy_number != "") {
                        $condition .= " AND t.policy_no = '". $policy_number."'";
                    }
                    $condition .= " AND t.start_date = '0000-00-00'";

                    $mod_pay = CustomerPlanDetails::model()->with('customer')->findAll(array('condition' => $condition, 'order' => 'customer.id asc'));

                    foreach ($mod_pay as $i => $value) {
                    ?>
                        <tr>
                            <td><?php echo ($i + 1); ?></td>
                            <td><?php echo $value->customer->id; ?></td>
                            <td><?php echo $value->customer->cust_first_name . " " . $value->customer->cust_middle_name . " " . $value->customer->cust_last_name; ?></td>
                            <td><?php echo $value->providerdetails->provider_name; ?></td>
                            <td><?php echo $value->masplandetails->plan_name; ?></td>
                            <td class="text-right"><?php echo $value->amount; ?></td>
                            <td><?php echo $payment_term[$value->payment_term]; ?></td>
                            <td class="text-right"><?php echo $value->annualized_premium; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- FOOTER -->
<htmlpagefooter name="myfooter">
    <div style="text-align:center;width:100%;font-size:10px">
        <?= Yii::app()->user->footer_autogenerated; ?>
        <?php
        date_default_timezone_set("Asia/Dubai");
        echo date('d/m/Y') . " " . date("h:i:sa");
        ?>
    </div>
    <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
        <div style="text-align:center;width:100%">
            <b><?= Yii::app()->user->footer_line_1 ?></b><br>
            <?= Yii::app()->user->footer_line_2 ?>
        </div>
        <div style="text-align:center;width:100%">Page {PAGENO} of {nb}</div>
    </div>
</htmlpagefooter>
<sethtmlpagefooter name="myfooter" page="all" value="on" />

</body>
</html>
