<?php
$color = array();
$model_color = MasColourScheme::model()->findAll(' 1 =1 ');
foreach ($model_color as $value) {
    $color[$value->id] = $value->colour;
}
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("loadDetails", '
        $(document).ready(function() {
        var table_id ="#tbl_lead_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
           "bAutoWidth": true,
            pageLength      : 50,       
            "columnDefs": [
                {
                   "targets": [6],
                   "visible": false,
                },
             ],
            "rowCallback": function ( row, data ){
                        if (data[6]!="" ){
                            $("td", row).css("background-color", "' . $color[6] . '"); 
                            $("td", row).css("color", "#000");                            
                        }

                    },
            ajax: {
                url: "' . Yii::app()->createUrl('lead/getlist') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
            });
        $(".dataTables_scrollFoot").hide();
        
    });', CClientScript::POS_HEAD);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-line-chart"></i> Leads
        <div class="pull-right">
            <button class="btn btn-sm btn-theme_1"  onclick="loadPopupModal('lead/create', 'Add New Lead', 'lg')"><i class="fa fa-plus"></i> ADD</button>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_lead_details">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Source</th>
                        <th>Referred By</th>
                        <th>Follow-up</th>
                        <th>Conversion Date</th>
                        <th align="center">Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Source</th>
                        <th>Referred By</th>
                        <th>Follow-up</th>    
                        <th>Conversion Date</th>
                        <th align="center">Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
