<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadvalue", "$(document).ready(function() {
        filterDataTable(0);
});", CClientScript::POS_HEAD);
$cs->registerScript("loaddetails", 'function filterDataTable(type){
    var customer_id=$("#activity_customer_id_1").val();
    var executive_id=$("#activity_executive_id").val();
        var table_id ="#tbl_executive_activity_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,           
           // bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('executive/GetActivityList') . '",
                type: "POST",
                "data" : {
                    "type" : type,
                    "customer_id" : customer_id,
                    "executive_id" : executive_id 
                },
                cache : false,
            },          
            serverSide:     true,
            fixedColumns:   true,
            processing: true,           
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            
        });
        $(".dataTables_scrollFoot").hide();
    }', CClientScript::POS_HEAD);
$cs->registerScript("getactivitydetails",  "function getactivitydetails(){  
    $('#tbl_executive_activity_details').DataTable().destroy();
        var type = $('#activity_type_1').val();
        filterDataTable(type);
   
};", CClientScript::POS_HEAD);
?>
<style>
    .dataTables_scrollBody {
        height: 150px !important;
    }
</style>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-list"></i> Activity
        <div class="pull-right">     
             <?php
            echo CHtml::dropdownlist('activity_type_1','',array(
                        '1' => 'Calls',
                        '2' => 'Appointment', 
                        '3' => 'Joint Field Visit', 
                        '4' => 'Fact Find', 
                        '5' => 'Presentation',
                        '6'=>'Application',
                        '7'=>'Review Meeting',
                ),  array('class'=>'activity-dropdown-1','title' => 'Please Select Activity Type','onchange'=>'getactivitydetails();','empty'=>'All Activity')); 
            ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_executive_activity_details" style="width: 100%;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Type</th>
                        <th>Call Date/Plan Date</th>
                        <th>Actual Date</th>
                        <th>Notes</th>  
                        <th>Created By</th>
                        <th>Created On</th>
                    </tr>
                </thead>
                <tfoot>
                <th>No</th>
                <th>Type</th>
                <th>Call Date/Plan Date/</th>
                <th>Actual Date</th>
                <th>Notes</th>
                <th>Created By</th>
                <th>Created On</th>
                </tfoot>
            </table>
        </div>
    </div>
</section>
<input type="hidden" name="activity_customer_id_1" id="activity_customer_id_1" value="<?php echo $customer_id; ?>">
<input type="hidden" name="activity_executive_id" id="activity_executive_id" value="<?php echo $executive; ?>">
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>    
</div>