<?php
$uasers_array[] = Yii::app()->user->id;
$explode_connected_users = explode(',', Yii::app()->user->connected_users);
if (count($explode_connected_users) > 0) {
    foreach ($explode_connected_users AS $user) {
        $uasers_array[] = $user;
    }
}
$connected_users = implode(",", array_filter($uasers_array));

$currentmonth = (int) date('m');
$currentyear = (int) date('Y');
$start_year = $currentyear - 3;
$end_year = $currentyear + 3;
$array_year = array();
for ($year = $start_year; $year <= $end_year; $year++) {
    $array_year[$year]['id'] = $year;
    $array_year[$year]['year'] = $year;
}
$array_month = array(1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April', 5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August', 9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December');



$cs = Yii::app()->getClientScript();


$cs->registerScript("load", '$(document).ready(function() {
    getActivityGraph("ALL");
    getActivityGraphByUser("USER");
    loadPolicyCount("policy_count");
    loadPolicyAmount("policy_value");
   
});', CClientScript::POS_HEAD);
$cs->registerScript("loadPolicyCount", "function loadPolicyCount(page) {
    var year  = $('#policy_count_year').val();
    var month  = $('#policy_count_month').val();
    var user  = $('#policy_count_user').val();
    jQuery.ajax({
        'type':'post',
        'data':'page='+page+'&year='+year+'&month='+month+'&user='+user,
        'url': '" . Yii::app()->createUrl('dashboard/GetGraph') . "',
        'cache': false,
        'success': function(data) {
            $('#piechart_total_policy').html(data);
        },'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        }

    });

    } ", CClientScript::POS_HEAD);
$cs->registerScript("loadPolicyAmount", "function loadPolicyAmount(page) {
    var   year  = $('#policy_value_year').val();
    var   month  = $('#policy_value_month').val();
    var  user  = $('#policy_value_user').val();
    jQuery.ajax({
        'type':'post',
        'data':'page='+page+'&year='+year+'&month='+month+'&user='+user,
        'url': '" . Yii::app()->createUrl('dashboard/GetGraph') . "',
        'cache': false,
        'success': function(data) {
            $('#piechart_total_policy_value').html(data);
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        }

    });

} ", CClientScript::POS_HEAD);
$cs->registerScript("getActivityGraph", "
    function getActivityGraph(type){ 
        var month = $('#activity_month').val();
        var year  = $('#activity_year').val();
        var user  = $('#activity_customer').val();
        var activities = $('#activities').val();
        var type  = type;
        jQuery.ajax({
            'data' : {'month':month,'year':year,'type':type,'user':user,'activities':activities},
            'type':'post',
            'url': '" . Yii::app()->createUrl('dashboard/getActivityGraph') . "',
            'cache': false,
            'success': function(data) {                
                $('#chartdiv_activity_overall').html(data);
                
            }
        });
        getActivityGraphByUser('USER');
    }", CClientScript::POS_HEAD);
$cs->registerScript("getActivityGraphByUser", "
    function getActivityGraphByUser(type){ 
        var month = $('#activity_month').val();
        var year  = $('#activity_year').val();
        var user  = $('#activity_customer').val();
        var activities = $('#activities').val();
        var type  = type;
        jQuery.ajax({
            'data' : {'month':month,'year':year,'type':type,'user':user,'activities':activities},
            'type':'post',
            'url': '" . Yii::app()->createUrl('dashboard/getActivityGraph') . "',
            'cache': false,
            'success': function(data) {
                
                $('#chartdiv_activity_by_user').html(data);
            }
        });
    }", CClientScript::POS_HEAD);
?>
<script src="https://www.amcharts.com/lib/4/core.js"></script>
<script src="https://www.amcharts.com/lib/4/charts.js"></script>
<script src="https://www.amcharts.com/lib/4/themes/animated.js"></script>


<script src="https://www.amcharts.com/lib/3/amcharts.js"></script>
<script src="https://www.amcharts.com/lib/3/funnel.js"></script>
<link rel="stylesheet" href="https://www.amcharts.com/lib/3/plugins/export/export.css" type="text/css" media="all" />
    <?php
    $from_date=date('Y-01-01');
    $end_date= date('Y-12-31');
    //Start-Current Quarter
    $current_quarter = ceil(date('n') / 3);
    $first_date = date('Y-m-d', strtotime(date('Y') . '-' . (($current_quarter * 3) - 2) . '-1'));
    $last_date = date('Y-m-t', strtotime(date('Y') . '-' . (($current_quarter * 3)) . '-1'));
    //End-Current Quarter
    //Start-Current Month
    $current_month = date('m');
    //End-Current Month
    //Start-Current Year
    $current_year = date('Y');
    //End-Current Year
    //Lead
    $model_lead= new LeadCustomer();
    $count_lead_year = $model_lead->count(array('condition'=>'created_by="'.Yii::app()->user->id.'" AND YEAR(created_date_time)="'.$current_year.'"'));
    $count_lead_month = $model_lead->count(array('condition'=>'created_by="'.Yii::app()->user->id.'" AND MONTH(created_date_time)= "'.$current_month.'"'));
    $count_lead_quarter = $model_lead->count(array('condition'=>'created_by="'.Yii::app()->user->id.'" AND created_date_time>= "'.$first_date.'" and created_date_time<= "'.$last_date.'"'));
    
    /*$count_lead_year = $model_lead->count(array('condition'=>'YEAR(created_date_time)="'.$current_year.'"'));
    $count_lead_month = $model_lead->count(array('condition'=>'MONTH(created_date_time)= "'.$current_month.'"'));
    $count_lead_quarter = $model_lead->count(array('condition'=>'created_date_time>= "'.$first_date.'" and created_date_time<= "'.$last_date.'"'));*/
    
    //Activity
    $model_activity= new Activity();
    $count_activity_year=$model_activity->with('customerdetails')->count(array('condition'=>'t.fact_find_status="2" AND t.type_of_activity="4" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND YEAR(call_back_or_actual_date)= "'.$current_year.'"'));
    $count_activity_month=$model_activity->with('customerdetails')->count(array('condition'=>'t.fact_find_status="2" AND t.type_of_activity="4" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND MONTH(call_back_or_actual_date)= "'.$current_month.'"'));
    $count_activity_quarter=$model_activity->with('customerdetails')->count(array('condition'=>'t.fact_find_status="2" AND t.type_of_activity="4" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND call_back_or_actual_date>= "'.$first_date.'" and call_back_or_actual_date<= "'.$last_date.'"'));
    //Customer
    $model_prospect= new Customer();
    $count_prospect_year=$model_prospect->count(array('condition'=>'t.isActive="Y" AND (t.cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND  t.cust_policy_taken = "Y" AND YEAR(created_date_time)= "'.$current_year.'"'));
    $count_prospect_month=$model_prospect->count(array('condition'=>'t.isActive="Y" AND (t.cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND  t.cust_policy_taken = "Y" AND MONTH(created_date_time)= "'.$current_month.'"'));
    $count_prospect_quarter=$model_prospect->count(array('condition'=>'t.isActive="Y" AND (t.cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND  t.cust_policy_taken = "Y" AND created_date_time>= "'.$first_date.'" and created_date_time<= "'.$last_date.'"'));

    //Policy and Policy Values
    $model_plan=new CustomerPlanDetails();
    $count_policies_year = $model_plan->with('customer')->count(array('condition'=>'policy_status="O" AND (customer.cust_executive_id="'.Yii::app()->user->id.'" OR customer.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND YEAR(start_date)= "'.$current_year.'"') );
    $count_policies_month = $model_plan->with('customer')->count(array('condition'=>'policy_status="O" AND (customer.cust_executive_id="'.Yii::app()->user->id.'" OR customer.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND YEAR(start_date)= "'.$current_year.'" AND MONTH(start_date)= "'.$current_month.'"') );
    $count_policies_quarter = $model_plan->with('customer')->count(array('condition'=>'policy_status="O" AND (customer.cust_executive_id="'.Yii::app()->user->id.'" OR customer.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND start_date>= "'.$first_date.'" and start_date<= "'.$last_date.'"') );

    $value_policy_year = $model_plan->with('customer')->find(array('select'=>'SUM(annualized_premium) AS annualized_premium','condition'=>'policy_status="O" AND (customer.cust_executive_id="'.Yii::app()->user->id.'" OR customer.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND YEAR(start_date)= "'.$current_year.'"') )->annualized_premium;
    $value_policy_month = $model_plan->with('customer')->find(array('select'=>'SUM(annualized_premium) AS annualized_premium','condition'=>'policy_status="O" AND (customer.cust_executive_id="'.Yii::app()->user->id.'" OR customer.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND YEAR(start_date)= "'.$current_year.'" AND MONTH(start_date)= "'.$current_month.'"') )->annualized_premium;
    $value_policy_quarter = $model_plan->with('customer')->find(array('select'=>'SUM(annualized_premium) AS annualized_premium','condition'=>'policy_status="O" AND (customer.cust_executive_id="'.Yii::app()->user->id.'" OR customer.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND start_date>= "'.$first_date.'" and start_date<= "'.$last_date.'"') )->annualized_premium;
    //Commission
    $model_commission= new CommissionLedger();
    $value_commission_year=$model_commission->with('commission_customer')->find(array('select'=>'SUM(in_amount) AS in_amount','condition'=>'(user_id="'.Yii::app()->user->id.'" OR user_id IN ('.Yii::app()->user->connected_users.')) AND YEAR(transaction_date)= "'.$current_year.'"'))->in_amount;
    $value_commission_month=$model_commission->with('commission_customer')->find(array('select'=>'SUM(in_amount) AS in_amount','condition'=>'(user_id="'.Yii::app()->user->id.'" OR user_id IN ('.Yii::app()->user->connected_users.')) AND YEAR(transaction_date)= "'.$current_year.'" AND MONTH(transaction_date)= "'.$current_month.'"'))->in_amount;
    $value_commission_quarter=$model_commission->with('commission_customer')->find(array('select'=>'SUM(in_amount) AS in_amount','condition'=>'(user_id="'.Yii::app()->user->id.'" OR user_id IN ('.Yii::app()->user->connected_users.')) AND transaction_date>= "'.$first_date.'" and transaction_date<= "'.$last_date.'"'))->in_amount;
    //Submission
    $model_submission= new Activity();
    $count_submission_month=$model_submission->with('customerdetails')->count(array('condition'=>'t.type_of_activity="9" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND YEAR(call_back_or_actual_date)= "'.$current_year.'"'));
    $count_submission_quarter=$model_submission->with('customerdetails')->count(array('condition'=>'t.type_of_activity="9" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND MONTH(call_back_or_actual_date)= "'.$current_month.'"'));
    $count_submission_year=$model_submission->with('customerdetails')->count(array('condition'=>'t.type_of_activity="9" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND call_back_or_actual_date>= "'.$first_date.'" and call_back_or_actual_date<= "'.$last_date.'"'));
    
    ?>
    <?php echo CHtml::hiddenField('graph_from_date','01/01/'.date("Y"));?>
    <?php echo CHtml::hiddenField('graph_to_date','31/12/'.date("Y"));?>
<style>
.table-responsive {
    overflow: auto;
    height: 223px;
}
table {
    font-size: 10.5px !important;
}
</style>   
<section class="panel">
<section class="box-group clearfix" id="accordion">
    <div class="row status" id="total_count_details">
<!--    <a href="javascript:void(0)">
        <div class="col-lg-2 col-sm-6">
            <section class="panel">
                <div class="symbol bg-terques">
                    <i class="fa fa-tags"></i>
					<p>Leads</p>
                </div>
				<div class="value">
					<div class="leads_total">
						<h3 class=""><?php echo $count_lead_month;?></h3>
						<p>This Month</p>
					</div>
					<div class="leads_total">
						<h3 class=""><?php echo $count_lead_quarter;?></h3>
						<p>This Quarter</p>
					</div>
					<div class="leads_total">
						<h3 class=""><?php echo $count_lead_year;?></h3>
						<p>This Year</p>
					</div>
				</div>
            </section>
        </div>
    </a>-->
    <a href="javascript:void(0)">
        <div class="col-lg-2 col-sm-6">
            <section class="panel">
                <div class="symbol bg-violet">
                    <i class="fa fa-info-circle"></i>
					<p>Fact Find</p>
                </div>
				<div class="value">
					<div class="leads_total">
						<h3 class=""><?php echo $count_activity_month ;?></h3>
						<p>This Month</p>
					</div>
					<div class="leads_total">
						<h3 class=""><?php echo $count_activity_quarter;?></h3>
						<p>This Quarter</p>
					</div>
					<div class="leads_total">
						<h3 class=""><?php echo $count_activity_year;?></h3>
						<p>This Year</p>
					</div>
				</div>
            </section>
        </div>
    </a>
    <a href="javascript:void(0)">
        <div class="col-lg-2 col-sm-6">
            <section class="panel">
                <div class="symbol bg-red">
                    <i class="fa fa-user"></i>
					<p>Customers</p>
                </div>
				<div class="value">
					<div class="leads_total">
						<h3 class=""><?php echo $count_prospect_month ;?></h3>
						<p>This Month</p>
					</div>
					<div class="leads_total">
						<h3 class=""><?php echo $count_prospect_quarter;?></h3>
						<p>This Quarter</p>
					</div>
					<div class="leads_total">
						<h3 class=""><?php echo $count_prospect_year;?></h3>
						<p>This Year</p>
					</div>
				</div>
            </section>
        </div>
    </a>
    <a href="javascript:void(0)">
        <div class="col-lg-2 col-sm-6">
            <section class="panel">
                <div class="symbol bg-terques">
                    <i class="fa fa-tags"></i>
					<p>Submission</p>
                </div>
				<div class="value">
					<div class="leads_total">
						<h3 class=""><?php echo $count_submission_month;?></h3>
						<p>This Month</p>
					</div>
					<div class="leads_total">
						<h3 class=""><?php echo $count_submission_quarter;?></h3>
						<p>This Quarter</p>
					</div>
					<div class="leads_total">
						<h3 class=""><?php echo $count_submission_year;?></h3>
						<p>This Year</p>
					</div>
				</div>
            </section>
        </div>
    </a>
    <a href="javascript:void(0)">
        <div class="col-lg-2 col-sm-6">
            <section class="panel">
                <div class="symbol bg-yellow">
                    <i class="fa fa-shopping-cart"></i>
					<p>Policies</p>
                </div>
			<div class="value">
                <div class="leads_total">
                    <h3 class=""><?php echo $count_policies_month;?></h3>
                    <p>This Month</p>
                </div>
				 <div class="leads_total">
                    <h3 class=""><?php echo $count_policies_quarter;?></h3>
                    <p>This Quarter</p>
                </div>
				 <div class="leads_total">
                    <h3 class=""><?php echo $count_policies_year;?></h3>
                    <p>This Year</p>
                </div>
		    </div>
            </section>
        </div>
    </a>
    <a href="javascript:void(0)">
        <div class="col-lg-2 col-sm-6">
            <section class="panel">
                <div class="symbol bg-grey">
                    <i class="fa fa-bar-chart-o"></i>
					<p>Value</p>
                </div>
			<div class="value">
                <div class="leads_total">
                    <h3 class=""><?php echo number_format($value_policy_month, 0);?></h3>
                    <p>This Month</p>
                </div>
				<div class="leads_total">
                    <h3 class=""><?php echo number_format($value_policy_quarter, 0);?></h3>
                    <p>This Quarter</p>
                </div>
				<div class="leads_total">
                    <h3 class=""><?php echo number_format($value_policy_year, 0);?></h3>
                    <p>This Year</p>
                </div>
			</div>
            </section>
        </div>
    </a>
    <a href="javascript:void(0)">
        <div class="col-lg-2 col-sm-6">
            <section class="panel">
                <div class="symbol bg-blued">
                    <i class="fa fa-money"></i>
                    <p>Commission</p>
                </div>
            <div class="value">
                <div class="leads_total">
                    <h3 class=""><?php echo number_format($value_commission_month, 0);?></h3>
                    <p>This Month</p>
                </div>
                <div class="leads_total">
                    <h3 class=""><?php echo number_format($value_commission_quarter, 0);?></h3>
                    <p>This Quarter</p>
                </div>
                <div class="leads_total">
                    <h3 class=""><?php echo number_format($value_commission_year, 0);?></h3>
                    <p>This Year</p>
                </div>
            </div>
            </section>
        </div>
    </a>
</div>
</section>
  <div class="row">
    <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Follow-Up</header> 
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>Mobile Number</th>
                            <th>Executive</th>
                            <th>Follow-Up</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $current_date = date('Y-m-d');
                        $current_date_7 = date('Y-m-d', strtotime('+7 days', strtotime(date('Y-m-d'))));
                        //$condition='((cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND ((DATE(call_back_or_actual_date)>="'.$current_date.'" AND DATE(call_back_or_actual_date)<="'.$current_date_7.'" AND type_of_activity="1") OR (DATE(call_or_plan_date_time)>="'.$current_date.'" AND DATE(call_or_plan_date_time)<="'.$current_date_7.'" AND type_of_activity!=1)))';
                        
                        $sql="CREATE OR REPLACE VIEW view_activity_details AS 
                        select C.cust_first_name AS cust_first_name,C.cust_middle_name AS cust_middle_name,C.cust_last_name AS cust_last_name,
                        C.cust_mobile1 AS cust_mobile1,C.cust_executive_id AS cust_executive_id,A.id AS id,A.customer_id AS customer_id,A.call_or_plan_date_time AS follow_up,'1' AS type from (crm_activity A join crm_customer C on(A.customer_id=C.id)) where A.fact_find_status=2 AND A.type_of_activity!=1 AND (cust_executive_id='".Yii::app()->user->id."' OR cust_executive_id IN (".Yii::app()->user->connected_users.")) AND DATE(call_or_plan_date_time)>='".$current_date."' AND DATE(call_or_plan_date_time)<='".$current_date_7."'
                        union 
                        select B.cust_first_name AS cust_first_name,B.cust_middle_name AS cust_middle_name,B.cust_last_name AS cust_last_name,
                        B.cust_mobile1 AS cust_mobile1,B.cust_executive_id AS cust_executive_id,D.id AS id,D.customer_id AS customer_id,D.call_back_or_actual_date AS follow_up,'1' AS type from (crm_activity D join crm_customer B on(D.customer_id=B.id)) where D.fact_find_status=2 AND D.type_of_activity=1 AND (cust_executive_id='".Yii::app()->user->id."' OR cust_executive_id IN (".Yii::app()->user->connected_users.")) AND DATE(call_back_or_actual_date)>='".$current_date."' AND DATE(call_back_or_actual_date)<='".$current_date_7."'
                        union
                        select E.customer_first_name AS cust_first_name,E.customer_middle_name AS cust_middle_name,E.customer_last_name AS cust_last_name,
                        E.customer_mobile_number AS cust_mobile1,E.created_by AS cust_executive_id,F.id AS id,F.lead_customer_id AS customer_id,F.call_or_plan_date_time AS follow_up,'2' AS type from (crm_activity F join crm_lead_customer E on(F.lead_customer_id=E.id)) where F.type_of_activity!=1 AND F.created_by='".Yii::app()->user->id."' AND DATE(call_or_plan_date_time)>='".$current_date."' AND DATE(call_or_plan_date_time)<='".$current_date_7."'
                        union
                        select G.customer_first_name AS cust_first_name,G.customer_middle_name AS cust_middle_name,G.customer_last_name AS cust_last_name,
                        G.customer_mobile_number AS cust_mobile1,G.created_by AS cust_executive_id,H.id AS id,H.lead_customer_id AS customer_id,H.call_back_or_actual_date AS follow_up,'2' AS type from (crm_activity H join crm_lead_customer G on(H.lead_customer_id=G.id)) where H.type_of_activity=1 AND H.created_by='".Yii::app()->user->id."' AND DATE(call_back_or_actual_date)>='".$current_date."' AND DATE(call_back_or_actual_date)<='".$current_date_7."'
                        order by follow_up asc"; 
//                        union
//                        select E.customer_first_name AS cust_first_name,E.customer_middle_name AS cust_middle_name,E.customer_last_name AS cust_last_name,
//                        E.customer_mobile_number AS cust_mobile1,E.created_by AS cust_executive_id,E.id AS id,E.id AS customer_id,E.call_back_date_time AS follow_up,'2' AS type from crm_lead_customer E  where created_by='".Yii::app()->user->id."' AND DATE(call_back_date_time)>='".$current_date."' AND DATE(call_back_date_time)<='".$current_date_7."' 
//                        order by  follow_up asc";                
                        Yii::app()->db->createCommand($sql)->execute();       
                        $model_activity_details=Yii::app()->db->createCommand('select * from view_activity_details where (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) order by follow_up asc')->queryAll();
                        //$model_activity = Activity::model()->with('customerdetails')->findAll(array('condition' =>$condition,'order'=>'call_back_or_actual_date,call_or_plan_date_time desc'));
                        foreach ($model_activity_details as $i => $value) {
                            $call_back_or_actual_dat='';
                                if($value['follow_up']!='' && $value['follow_up']!='0000-00-00 00:00:00'){
                                    $call_back_or_actual_date=date("d/m/Y H:i",strtotime($value['follow_up']));
                                }
                            $executive_name =User::model()->findByPk($value['cust_executive_id'])->fullname;
                            ?>
                        <tr>
                            <td><?php echo ($i+1); ?></td>
                            <td><?php echo $value['cust_first_name'].' '.$value['cust_middle_name'].' '.$value['cust_last_name']; ?></td>
                            <td><?php echo $value['cust_mobile1']; ?></td>
                            <td><?php echo $executive_name; ?></td>
                            <td><?php echo $call_back_or_actual_date; ?></td>
                            <td>
                                <?php
                                if($value['type']==1){
                                ?>
                                <button class="btn btn-primary btn-xs" title ="Activity" onclick="loadPopupModal('activity/create&customer_id=<?php echo $value['customer_id'] ?>','<?php echo $value['customer_id']; ?>-<?php echo $value['cust_first_name'].' '.$value['cust_middle_name'].' '.$value['cust_last_name']; ?>- Activities ','xl')"><i class="fa fa-certificate"></i>
                                </button>
                                <?php
                                }else if($value['type']==2){
                                    ?>
                                    <button class="btn btn-primary btn-xs" title ="Activity" onclick="loadPopupModal('leadactivity/create&customer_id=<?php echo $value['customer_id'] ?>','<?php echo $value['customer_id']; ?>-<?php echo $value['cust_first_name'].' '.$value['cust_middle_name'].' '.$value['cust_last_name']; ?>- Activities ','lg')"><i class="fa fa-certificate"></i>
                                    </button>
                                <?php
                                }
                                ?>
                            </td>
                        </tr>
                        <?php
                        }
                        ?>
                    </tbody>
                
            </table>
            </div>
        </section>
    </div>
    <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Customers-Last Contacted(15 days)</header>
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>Mobile Number</th>
                            <th>Executive</th>
                            <th>Contacted On</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    $current_date_90 = date('Y-m-d', strtotime('-15 days', strtotime(date('Y-m-d'))));
                    $sql="CREATE OR REPLACE VIEW view_contacted_details AS 
                    select B.cust_first_name AS cust_first_name,B.cust_middle_name AS cust_middle_name,B.cust_last_name AS cust_last_name,
                    B.cust_mobile1 AS cust_mobile1,B.cust_executive_id AS cust_executive_id,D.id AS id,D.customer_id AS customer_id,D.call_back_or_actual_date AS follow_up,'1' AS type from (crm_activity D join crm_customer B on(D.customer_id=B.id)) where (cust_executive_id='".Yii::app()->user->id."' OR cust_executive_id IN (".Yii::app()->user->connected_users.")) AND DATE(call_back_or_actual_date)>='".$current_date_90."' AND DATE(call_back_or_actual_date)<'".$current_date."'
                    union 
                    select E.customer_first_name AS cust_first_name,E.customer_middle_name AS cust_middle_name,E.customer_last_name AS cust_last_name,
                    E.customer_mobile_number AS cust_mobile1,E.created_by AS cust_executive_id,E.id AS id,E.id AS customer_id,F.call_back_or_actual_date AS follow_up,'2' AS type from (crm_activity F join crm_lead_customer E on(F.lead_customer_id=E.id)) where F.created_by='".Yii::app()->user->id."' AND DATE(call_back_date_time)>='".$current_date_90."' AND  DATE(call_back_or_actual_date)>='".$current_date_90."' AND DATE(call_back_or_actual_date)<'".$current_date."'
                    order by  follow_up asc"; 
//                    select E.customer_first_name AS cust_first_name,E.customer_middle_name AS cust_middle_name,E.customer_last_name AS cust_last_name,
//                    E.customer_mobile_number AS cust_mobile1,E.created_by AS cust_executive_id,E.id AS id,E.id AS customer_id,E.call_back_date_time AS follow_up,'2' AS type from crm_lead_customer E  where created_by='".Yii::app()->user->id."' AND DATE(call_back_date_time)>='".$current_date_90."' AND DATE(call_back_date_time)<'".$current_date."' 
//                    order by  follow_up asc";                
                    Yii::app()->db->createCommand($sql)->execute();       
                    $model_contacted_details=Yii::app()->db->createCommand('select cust_first_name,cust_middle_name,cust_last_name,cust_mobile1,cust_executive_id,id,customer_id,max(follow_up) as follow_up,type from view_contacted_details where (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) group by customer_id order by follow_up desc')->queryAll();                        
                        foreach ($model_contacted_details as $i => $value) {
                            $call_back_or_actual_dat='';
                                if($value['follow_up']!='' && $value['follow_up']!='0000-00-00 00:00:00'){
                                    $call_back_or_actual_date=date("d/m/Y H:i",strtotime($value['follow_up']));
                                }
                            $executive_name =User::model()->findByPk($value['cust_executive_id'])->fullname;
                            ?>
                        <tr>
                            <td><?php echo ($i+1); ?></td>
                            <td><?php echo $value['cust_first_name'].' '.$value['cust_middle_name'].' '.$value['cust_last_name']; ?></td>
                            <td><?php echo $value['cust_mobile1']; ?></td>
                            <td><?php echo $executive_name; ?></td>
                            <td><?php echo $call_back_or_actual_date; ?></td>
                            <td>
                                <?php
                                if($value['type']==1){
                                ?>
                                <button class="btn btn-primary btn-xs" title ="Activity" onclick="loadPopupModal('activity/create&customer_id=<?php echo $value['customer_id'] ?>','<?php echo $value['customer_id']; ?>-<?php echo $value['cust_first_name'].' '.$value['cust_middle_name'].' '.$value['cust_last_name']; ?>- Activities ','xl')"><i class="fa fa-certificate"></i>
                                </button>
                                <?php
                                }else if($value['type']==2){
                                    ?>
                                    <button class="btn btn-primary btn-xs" title ="Activity" onclick="loadPopupModal('leadactivity/create&customer_id=<?php echo $value['customer_id'] ?>','<?php echo $value['customer_id']; ?>-<?php echo $value['cust_first_name'].' '.$value['cust_middle_name'].' '.$value['cust_last_name']; ?>- Activities ','lg')"><i class="fa fa-certificate"></i>
                                    </button>
                                <?php
                                }
                                ?>
                            </td>
                        </tr>
                        <?php
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </section>
    </div>
  </div>
<div class="row">
       <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Bounced Cheque
            <a href="javascript:void(0);" class="btn btn-theme" onclick="bouncedcheque();">LOAD</a>
            </header>
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Customer</th>
                            <th>Policy No</th>
                            <th>Cheque No</th>
                            <th>Payment Date</th>
                            <th>Installment</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody id="tb_bouncedcheque">         
                    </tbody>
                </table>
            </div>
        </section>
    </div>
       <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Exhausted Cheque
                <a href="javascript:void(0);" class="btn btn-theme" onclick="exhaustedcheque();">LOAD</a>
            </header>
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Customer</th>
                            <th>Policy No</th>
                            <th>Payment Date</th>
                            <th>Installment</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody id="tb_exhaustedcheque">
                        
                    </tbody>
                </table>
            </div>
        </section>
    </div>
</div>
     <div class="row">
    <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Payment Due List - 30 days
            <a href="javascript:void(0);" class="btn btn-theme" onclick="paymentduelist();">LOAD</a>
            </header> 
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>Policy No</th>
                            <th>Payment Due Date</th>
                            <th>Inst No</th>
                            <th>Amount</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="tb_paymentduelist">
                       
                    </tbody>
                
            </table>
            </div>
        </section>
    </div>
        <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Credit Card Expiry
                <a href="javascript:void(0);" class="btn btn-theme" onclick="creditcardexpiry();">LOAD</a>
            </header>
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Customer</th>
                            <th>Mobile No</th>
                            <th>Card No</th>
                            <th>Expiry Date</th>
                        </tr>
                    </thead>
                    <tbody id="tb_creditcardexpiry">                       
                    </tbody>
                </table>
            </div>
        </section>
    </div>
  </div>
   <div class="row">
    <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Customers-Annualised Premium
                 <a href="javascript:void(0);" class="btn btn-theme" onclick="customerannualisedpremium();">LOAD</a>
            </header> 
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>Policy No</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody id="tbody_cust_annual_premium">                       
                    </tbody>
                
            </table>
            </div>
        </section>
    </div>
   <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Customers-Total Policy
            <a href="javascript:void(0);" class="btn btn-theme" onclick="customertotalpolicy();">LOAD</a>
            </header>
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Customer</th>
                            <th>Mobile No</th>
                            <th>Total Policies</th>
                        </tr>
                    </thead>
                    <tbody id="tbody_cust_total_policy">                      
                    </tbody>
                </table>
            </div>
        </section>
    </div>
  </div>  
 <div class="row">
    <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Birthday
            <a href="javascript:void(0);" class="btn btn-theme" onclick="loadbirthday();">LOAD</a>
            </header> 
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>Mobile Number</th>
                            <th>Date of Birth</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="tb_birthday">                      
                    </tbody>
                
            </table>
            </div>
        </section>
    </div>
    <div class="col-sm-6">
        <section class="panel ads">
            <header class="panel-heading dhj">Anniversary
            <a href="javascript:void(0);" class="btn btn-theme" onclick="loadanniversary();">LOAD</a>
            </header>
            <div class="table-responsive">
                <table class="table table-fixed table-bordered table-primary fixed_table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Customer</th>
                            <th>Mobile No</th>
                            <th>Policy Start Date</th>
                        </tr>
                    </thead>
                    <tbody id="tb_anniversary">                        
                    </tbody>
                </table>
            </div>
        </section>
    </div>
  </div>
<div class="row">
    <div class="col-sm-6">
        <section class="panel">
            <header class="panel-heading">Total Policies
            <div class="col-sm-3 pull-right">
                <?php echo CHtml::dropDownList('policy_count_month', $currentmonth, $array_month, array('class' => 'form-control', 'onchange' => 'loadPolicyCount("policy_count");', 'empty' => 'All')); ?>
            </div>
            <div class="col-sm-3 pull-right">
                <?php echo CHtml::dropDownList('policy_count_year', $currentyear, CHtml::listData($array_year, 'id', 'year'), array('class' => 'form-control', 'onchange' => 'loadPolicyCount("policy_count");')); ?>
            </div>
            <div class="col-sm-3 pull-right">
                <?php echo CHtml::dropDownList('policy_count_user', '', User::getConnectedUsers($connected_users), array('class' => 'form-control', 'onchange' => 'loadPolicyCount("policy_count");', 'empty' => 'All')); ?>
            </div>
            </header>
            <div class="panel-body">
                <div id="piechart_total_policy"></div>
            </div>
        </section>
    </div>
    <div class="col-sm-6">
        <section class="panel">
            <header class="panel-heading">Policy Value
            <div class="col-sm-3 pull-right">
                <?php echo CHtml::dropDownList('policy_value_month', $currentmonth, $array_month, array('class' => 'form-control', 'onchange' => 'loadPolicyAmount("policy_value");', 'empty' => 'All')); ?>
            </div>
            <div class="col-sm-3 pull-right">
                <?php echo CHtml::dropDownList('policy_value_year', $currentyear, CHtml::listData($array_year, 'id', 'year'), array('class' => 'form-control', 'onchange' => 'loadPolicyAmount("policy_value");')); ?>
            </div>
            <div class="col-sm-3 pull-right">
                <?php echo CHtml::dropDownList('policy_value_user', '', User::getConnectedUsers($connected_users), array('class' => 'form-control', 'onchange' => 'loadPolicyAmount("policy_value");', 'empty' => 'All')); ?>
            </div>
            </header>
            <div class="panel-body">
                <div id="piechart_total_policy_value"></div>
            </div>
        </section>
    </div>
</div>
<div class="row">
    <div class="col-sm-6">
        <section class="panel">
            <header class="panel-heading">

                <div class="row">
                    <div class="col-sm-3">
                        Activity
                    </div>
                    <div class="col-sm-3">
                        <?php echo CHtml::dropDownList('activity_month', $currentmonth, $array_month, array('class' => 'form-control', 'onchange' => 'getActivityGraph("ALL");', 'empty' => 'All')); ?>
                    </div>
                    <div class="col-sm-3">
                        <?php echo CHtml::dropDownList('activity_year', $currentyear, CHtml::listData($array_year, 'id', 'year'), array('class' => 'form-control', 'onchange' => 'getActivityGraph("ALL");', 'empty' => 'All')); ?>
                    </div>
                    <div class="col-sm-3">                
                        <?php
                        $activities_array = array('1' => 'Calls', '2' => 'Appointments', '3' => 'Joint Field Visit', '4' => 'Fact Find', '5' => 'Presentation', '6' => 'Application');
                        echo CHtml::dropDownList('activities', '', $activities_array, array('class' => 'form-control', 'onchange' => 'getActivityGraph("ALL");', 'empty' => 'All'));
                        ?>
                    </div>
                </div>
            </header>
            <div class="panel-body">
                <div id="chartdiv_activity_overall" class="grap_div"></div>
            </div>
        </section>
    </div>
    <div class="col-sm-6">
        <section class="panel">
            <header class="panel-heading">
                <div class="row">
                    <div class="col-sm-4">
                        Activity by User 
                    </div>
                    <div class="col-sm-3">
                        <?php echo CHtml::dropDownList('activity_customer', '', User::getConnectedUsers($connected_users), array('class' => 'form-control', 'onchange' => 'getActivityGraphByUser("USER");', 'empty' => 'All')); ?>
                        <?php //echo CHtml::dropDownList('activity_customer','',User::getUsers(), array('class' => 'form-control','onchange'=>'getActivityGraphByUser("USER");','empty'=>'All')); ?>
                    </div>
                </div>
            </header>
            <div class="panel-body">
                <div id="chartdiv_activity_by_user" class="grap_div"></div>
            </div>
        </section>
    </div>
</div>
</section>
<style>
    .grap_div {
        width		: 100%;
        height		: 500px;
        font-size	: 11px;
    }

</style>
<?php
$cs->registerScript("customerannualisedpremium", "function customerannualisedpremium() {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'url': '" . Yii::app()->createUrl('dashboard/customerannualisedpremium') . "',
        'cache': false,
        'success': function(data) {
            $('#tbody_cust_annual_premium').html(data.premiumdetails);             
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);
$cs->registerScript("customertotalpolicy", "function customertotalpolicy() {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'url': '" . Yii::app()->createUrl('dashboard/customertotalpolicy') . "',
        'cache': false,
        'success': function(data) {
            $('#tbody_cust_total_policy').html(data.policydetails);             
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);
$cs->registerScript("loadbirthday", "function loadbirthday() {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'url': '" . Yii::app()->createUrl('dashboard/loadbirthday') . "',
        'cache': false,
        'success': function(data) {
            $('#tb_birthday').html(data.birthdaydetails);             
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);
$cs->registerScript("loadanniversary", "function loadanniversary() {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'url': '" . Yii::app()->createUrl('dashboard/loadanniversary') . "',
        'cache': false,
        'success': function(data) {
            $('#tb_anniversary').html(data.anniversary);             
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
    });
};", CClientScript::POS_HEAD);
$cs->registerScript("creditcardexpiry", "function creditcardexpiry() {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'url': '" . Yii::app()->createUrl('dashboard/creditcardexpiry') . "',
        'cache': false,
        'success': function(data) {
            $('#tb_creditcardexpiry').html(data.creditcardexpiry);             
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);
$cs->registerScript("paymentduelist", "function paymentduelist() {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'url': '" . Yii::app()->createUrl('dashboard/paymentduelist') . "',
        'cache': false,
        'success': function(data) {
            $('#tb_paymentduelist').html(data.paymentduelist);             
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);
$cs->registerScript("exhaustedcheque", "function exhaustedcheque() {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'url': '" . Yii::app()->createUrl('dashboard/exhaustedcheque') . "',
        'cache': false,
        'success': function(data) {
            $('#tb_exhaustedcheque').html(data.exhaustedcheque);             
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);
$cs->registerScript("bouncedcheque", "function bouncedcheque() {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'url': '" . Yii::app()->createUrl('dashboard/bouncedcheque') . "',
        'cache': false,
        'success': function(data) {
            $('#tb_bouncedcheque').html(data.bouncedcheque);             
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);

$cs->registerScript("sendBirthdayMailToCustomer", "function sendBirthdayMailToCustomer(cust_id) {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'data':{'cust_id':cust_id},
        'url': '" . Yii::app()->createUrl('dashboard/sendBirthdayMailToCustomer') . "',
        'cache': false,
        'success': function(data) {
            if(data.status=='success'){
                t8.success('Mail send successfully!');
            }
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);
$cs->registerScript("SendChequeMailToCustomer", "function SendChequeMailToCustomer(cust_id,payment_id) {  
    jQuery.ajax({ 
        'dataType':'json', 
        'type':'post',
        'data':{'cust_id':cust_id},
        'url': '" . Yii::app()->createUrl('dashboard/SendChequeMailToCustomer') . "',
        'cache': false,
        'success': function(data) {
            if(data.status=='success'){
                t8.success('Mail send successfully!');
            }
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        },
});
};", CClientScript::POS_HEAD);
?>
