<?php
if ($modelPlanDetails->payment_term > 0) {
    $modelPlanDetails->payment_term = MasPlanPaymentTerms::getPaymentTermIdWithTime($modelPlanDetails->payment_term);
}
?>
<ul class="clearfix form-ul material" style="border: 1px solid #e5e5e5;">
    <li class="col-sm-3">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'provider_id', array('value'=>$modelPlanDetails->providerdetails->provider_name,'readonly'=>true,'class' => 'tooltipster', 'title' => 'Provider','data-label' => 'Provider <span><img src="/insurance/images/provider.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'plan_id', array('value'=>$modelPlanDetails->masplandetails->plan_name,'readonly'=>true,'class' => 'tooltipster', 'title' => 'Plan','data-label' => 'Plan <span><img src="/insurance/images/plan-name.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeDropdownList($modelPlanDetails, 'class_ids', MasClass::getActiveClass(), array('class' => 'tooltipster', 'title' => 'Class', 'empty' => '--Select--', 'data-label' => 'Class <span style="color:red;"> <img src="/insurance/images/class.png" style="padding-left: 10px;"></span>','multiple'=>TRUE)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeDropdownList($modelPlanDetails, 'subclass_ids', MasSubClass::getActiveSubClass(), array('class' => 'tooltipster', 'title' => 'SubClass', 'empty' => '--Select--', 'data-label' => 'SubClass <span style="color:red;"> <img src="/insurance/images/sub-class.png" style="padding-left: 10px;"></span>','multiple'=>TRUE)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'amount', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Amount', 'data-label' => 'Amount (<b>$</b>) <span style="color:red;">* <img src="/insurance/images/amount.png" style="padding-left: 10px;"></span>', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateAnnualizedPremium();', 'onblur' => 'formatAmount(this.value);', 'style' => 'text-align:right')); ?>
    </li>
    <div class="clearfix"></div>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'policy_no', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Policy No', 'data-label' => 'Policy No <span style="color:red;">* <img src="/insurance/images/plan-name.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'start_date', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Start Date', 'data-label' => 'Start Date <span style="color:red;">* <img src="/insurance/images/start-date.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'issue_date', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Issue Date', 'data-label' => 'Issue Date <span style="color:red;">* <img src="/insurance/images/start-date.png" style="padding-left: 10px;"></span>')); ?>
    </li>    
    <li class="col-sm-2">
        <?php echo CHtml::activeDropdownList($modelPlanDetails, 'payment_term', MasPlanPaymentTerms::getPlanPaymentTermsWithTimes(), array('disabled'=>true,'class' => 'tooltipster', 'title' => 'Payment Terms', 'data-label' => 'Mode of Payment <span style="color:red;">* <img src="/insurance/images/payment-term.png" style="padding-left: 10px;"></span>', 'empty' => '--Select--', 'onchange' => 'calculateAnnualizedPremium();')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeDropdownList($modelPlanDetails, 'policy_basis_type', MasPolicyBasis::getPolicybasis(), array('disabled'=>true,'class' => 'tooltipster', 'title' => 'Policy Basis', 'data-label' => 'Policy Basis <span style="color:red;">* <img src="/insurance/images/payment-term.png" style="padding-left: 10px;"></span>', 'empty' => '--Select--')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'tennure', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Policy Term', 'onkeypress' => 'return isNumberKey(event)', 'data-label' => 'Policy Term <span style="color:red;">* <img src="/insurance/images/tennure.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <div class="clearfix"></div>
    <li class="col-sm-3">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'annualized_premium', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Annualized Premium', 'data-label' => 'Annualized Premium <span style="color:red;">* <img src="/insurance/images/premium.png" style="padding-left: 10px;"></span>', 'readonly' => true, 'style' => 'text-align:right')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'premium_payment_term', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Premium Payment Term', 'onkeypress' => 'return isNumberKey(event)', 'data-label' => 'Premium Payment Term <span style="color:red;">* <img src="/insurance/images/tennure.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <?php if (isset(Yii::app()->user->havePermissionOn['icp_change']) ) { ?>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'icp_months', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'ICP Month', 'onkeypress' => 'return isNumberKey(event)', 'data-label' => 'ICP Month <span><img src="/insurance/images/tennure.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <?php }else{ 
         echo CHtml::activeHiddenField($modelPlanDetails, 'icp_months'); 
    }
?>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'expected_gr', array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Expected GR', 'onkeypress' => 'return isNumberKey(event)', 'data-label' => 'Expected GR <span><img src="/insurance/images/premium.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeDropdownList($modelPlanDetails, 'policy_status', array('P'=>'Pending','O'=>'InForce','L'=>'Lapsed','U'=>'Paid Up','S'=>'Surrender','C'=>'Benefit Claim','M'=>'Maturity'), array('disabled'=>true,'class' => 'tooltipster', 'title' => 'Status', 'data-label' => 'Status <span style="color:red;">* <img src="/insurance/images/status.png" style="padding-left: 10px;"></span>','empty'=>'-Select-','onchange'=>'policystatuschange()')); ?>
    </li>
    <div id="div_status_reason" <?php if($modelPlanDetails->policy_status=='O'){?>style="display: none;"<?php } ?>>
    <li class="col-sm-4">
        <?php echo CHtml::activeTextArea($modelPlanDetails, 'reason',array('readonly'=>true,'class' => 'tooltipster', 'title' => 'Reason', 'data-label' => 'Reason <span style="color:red;">*<img src="/insurance/images/premium.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    </div>
</ul>
