<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadDocuments", 'function loadDocuments(){
                var customer_id=$("#ActivityDocument_customer_id").val();
                var table_id ="#tbl_customer_document_details";
                var table = $(table_id).DataTable({
                     scrollY         : "380px",
                    "bAutoWidth": true,
                    pageLength      : 50,
                    ajax: {
                        url: "' . Yii::app()->createUrl('customer/GetDocumentList') . '",
                        type: "POST",
                        "data" : {
                            "customer_id" : customer_id
                        },
                        cache : false,
                    },
                    serverSide:     true,
                    fixedColumns:   true,
        			processing: true,
                    fixedHeader: {
                        headerOffset: $("header.main").outerHeight()
                    }
                } );
                $(".dataTables_scrollFoot").hide();
            }', CClientScript::POS_HEAD);
?>
<ul class="clearfix form-ul material row">
    <li class="col-sm-4">
        <?php echo $form->hiddenfield($modelDocument, 'id'); ?>
        <?php echo $form->hiddenfield($modelDocument, 'customer_id', array('value' => $model->id)); ?>
        <label>Document Type <span style="color:red;">*</span></label>
        <?php echo $form->dropDownList($modelDocument, 'document_type', MasDocument::getCustomerDocument(), array('class' => 'form-control tooltipster', 'title' => 'Document Type', 'data-label' => 'Document Type <span style="color:red;">*</span>', 'empty' => 'Select')); ?>
    </li>
    <li class="col-sm-3">
        <label>Document Name</label>
        <?php echo $form->textField($modelDocument, 'document_name', array('class' => 'form-control', 'title' => 'Document Name', 'data-label' => 'Document Name')); ?>
    </li>
    <li class="col-sm-3">
        <label>Document <span style="color:red;">*(Avoid commas in Filename)</span></label>
        <?php
        if ($frm != 'view') {
            $allowedExtensions = array("csv", "zip", "png", "txt", "pdf", "doc", "docx", "jpg", "jpeg", "gif");
            $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                'id' => 'document_upload',
                'config' => array(
                    'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/documents/')),
                    'multiple' => true,
                    'allowedExtensions' => $allowedExtensions,
                    'sizeLimit' => 8 * 1024 * 1024,
                    'onStart' => "js:function(){}",
                    'onComplete' => "js:function(id, fileName, responseJSON){
                  //  $('#ActivityDocument_document_file').val(responseJSON.filename);
                    var val_doc =$('#ActivityDocument_document_file').val();
                    if(val_doc!=''){
                        $('#ActivityDocument_document_file').val(val_doc+','+responseJSON.filename);
                    }else{
                    $('#ActivityDocument_document_file').val(responseJSON.filename);
                    }
                }",
                )
            ));
        }
        ?>
        <?php echo $form->hiddenfield($modelDocument, 'document_file'); ?>
    </li>
    <li class="col-sm-2">
        <?php if ($frm != 'view') { ?>
            <button style="margin-top:24px;" type="button" class="customer-document-save-btn btn btn-theme" onclick="saveDocument();">Save</button>
        <?php } ?>
    </li>
</ul>
<br/>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-user"></i> Documents
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_customer_document_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Document Type</th>
                        <th>Document Name</th>
                        <th>Uploaded By</th>
                        <th>Uploaded Date & Time</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Document Type</th>
                        <th>Document Name</th>
                        <th>Uploaded By</th>
                        <th>Uploaded Date & Time</th>
                        <th>Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
<?php
$cs = Yii::app()->getClientScript();
if ($frm != 'view') {
//Start Document Save
    $cs->registerScript('saveDocument', 'function saveDocument(){
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#customer-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('customer/saveCustomerDocument') . '",
        "success":function(data){
            if(data.status=="success"){
                $("#ActivityDocument_id").val("");
                $("#ActivityDocument_document_name").val("");
                $("#ActivityDocument_document_file").val("");
//                $("#ActivityDocument_document_type").multiselect("select","");
                t8.success("Documents Uploaded Successfully!");
                reloadTable("#tbl_customer_document_details");
            } else {
               $.each(data, function(key, val) {
                       t8.error(""+val+"");
               });
            }
        },
        "beforeSend":function(){
            $("#loader").show();
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
}
//End Document Save
//Script to load details on tab while editing-starts
$cs->registerScript("editdocumentdetails", "function editdocumentdetails(id) {
        jQuery.ajax({
            'dataType':'json',
            'data' : {
                'id':id
            },
            'type':'post',
            'url': '" . Yii::app()->createUrl('activity/editdocumentdetails') . "',
            'cache': false,
            'success': function(data) {
                if(data.status='success'){
                    $('#ActivityDocument_id').val(data.id);
                    $('#ActivityDocument_customer_id').val(data.customer_id);
                    $('#ActivityDocument_document_name').val(data.document_name);
                    $('#ActivityDocument_document_name').addClass('filled');
                    $('#ActivityDocument_document_file').val(data.document_file);
                }
            },
            'beforeSend':function(){
            $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
    });
};", CClientScript::POS_HEAD);
//Script to load details on tab while editing-ends
$cs->registerScript("deletedocument", "function deletedocument(id){
    var r = confirm('Confirm Document Deletion?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=activity/deletedocument',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_customer_document_details');
                    t8.success('Document Deleted SuccessFully!');
                }else {
                    t8.error('Error in Deletion');
                }
               },
               'beforeSend':function(){
                $('#loader').show();
                },
                'complete':function(){
                    $('#loader').hide();
                }
            });
        }
};", CClientScript::POS_HEAD);
?>