<?php
$color = array();
$model = MasColourScheme::model()->findAll(' 1 =1 ');
foreach ($model as $value) {
    $color[$value->id] = $value->colour;
}
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadfactfind", '$(document).ready(function() {
        filterDataTable();
    });', CClientScript::POS_HEAD);
$cs->registerScript("loadfactfinddetails", 'function filterDataTable(){
        var table_id ="#tbl_fact_find_details";
        var executive_id=$("#executive_id").val();
        var table = $(table_id).DataTable({
            scrollY         : "380px",
//            scrollX         : "true",
           // scrollCollapse  : true,
           "bAutoWidth": true,
            pageLength      : 50,
            processing: true,
            //bSort: false,
            order: [[ 6, "asc" ]],
            columnDefs: [{"targets": [5],"visible": false, },{"targets": [6],"visible": false, }
            ],
            ajax: {
                url: "' . Yii::app()->createUrl('activity/getfactfindlist') . '",
                type: "POST",
                data: {
                    "executive_id" : executive_id
                },
                cache : false,
            },
            serverSide:     true,
            "rowCallback": function ( row, data ){ 
                if(data[5]== "1" ){
                    $("td", row).css("background-color", "'.$color[8].'");//team John
                }
                else if(data[5]== "2" ){
                    $("td", row).css("background-color", "'.$color[9].'");//team Raxon
                }else{
                    $("td", row).css("background-color", "'.$color[10].'");//others
                }
            },	
            //fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },

        });
        $(".dataTables_scrollFoot").hide();
    }', CClientScript::POS_HEAD);
$cs->registerScript("getfactfindlist",  "function getfactfindlist(){
    $('#tbl_fact_find_details').DataTable().destroy();
    filterDataTable();

};", CClientScript::POS_HEAD);
$cs->registerScript("deleteFactFind", "function deleteFactFind(id){
     jConfirm('Are You Sure to Delete', 'Confirmation Dialog', function(r) {
        if (r == true) {
            jQuery.ajax({
                'dataType':'json',
                'data' : {
                    'id':id
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('activity/deletefactfind') . "',
                'cache': false,
                'success': function(data) {
                    if(data.status=='success'){
                        t8.success('Factfind Deleted Successfully');
                        reloadTable('#tbl_fact_find_details');
                    }else{
                        t8.error('Error in sending request..');
                    }
                },
                'beforeSend': function(data) {
                    $('#loader').show();
                },
                'complete': function(data) {
                    $('#loader').hide();
                },
            });
        }
    });
};", CClientScript::POS_HEAD);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-file-text-o"></i> Fact Find
        <div class="pull-right">
            <?php echo CHtml::dropDownList("executive_id",'',User::getAllUsers(), array( 'empty' => 'All Executives', 'title' => 'Executive','class'=>'activity-dropdown-1','onchange'=>'getfactfindlist();')); ?>  
        </div>  
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_fact_find_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Executive Name</th>
                        <th>Date</th>
                        <th align="center">Actions</th>
                        <th></th>
                        <th></th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Executive Name</th>
                        <th>Date</th>
                        <th align="center">Actions</th>
                         <th></th>
                         <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
