<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadDocuments", 'function loadDocuments(){
                var customer_id=$("#ActivityDocument_customer_id").val();
                var table_id ="#tbl_activitydocument_details";
                var table = $(table_id).DataTable({
                     scrollY         : "380px",
                    "bAutoWidth": true,
                    pageLength      : 50,
                    ajax: {
                        url: "' . Yii::app()->createUrl('activity/GetDocumentList') . '",
                        type: "POST",
                        "data" : {
                            "customer_id" : customer_id              
                        },
                        cache : false,
                    },
                    serverSide:     true,
                    fixedColumns:   true,
        			processing: true,
                    fixedHeader: {
                        headerOffset: $("header.main").outerHeight()
                    }
                } );
                $(".dataTables_scrollFoot").hide();
            }', CClientScript::POS_HEAD);
?>

<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'activity-document-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
;
?> 
<ul class="clearfix form-ul material">
    <div class="row">
    <li class="col-sm-4">     
        <?php echo $form->hiddenfield($model, 'id'); ?>  
        <?php echo $form->hiddenfield($model, 'customer_id', array('value' => $customer_id)); ?>
        <label>Document Type <span style="color:red;">*</span></label>
        <?php echo $form->dropDownList($model,'document_type',MasDocument::getActivityDocument(),array('class' => 'form-control tooltipster', 'title' => 'Document Type','data-label'=>'Document Type <span style="color:red;">*</span>','empty'=>'Select'));  ?>                
    </li>
    <li class="col-sm-4">     
        <label>Document Name</label>
<?php echo $form->textField($model, 'document_name', array('class' => 'form-control ', 'title' => 'Document Name', 'data-label' => 'Document Name')); ?>                 
    </li>
    <li class="col-sm-3">
        <label>Document <span style="color:red;">*(Avoid Comma in Filename)</span></label>
        <?php
        $allowedExtensions = array("csv", "zip", "png", "txt", "pdf", "doc", "docx", "jpg", "jpeg", "gif");
        $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
            'id' => 'document_upload',
            'config' => array(
                'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/documents/')),
                'multiple' => true,
                'allowedExtensions' => $allowedExtensions,
                'sizeLimit' => 8 * 1024 * 1024,
                'onStart' => "js:function(){}",
                'onComplete' => "js:function(id, fileName, responseJSON){
                    $('#ActivityDocument_document_file').val(responseJSON.filename);                                    
                }",
            )
        ));
        ?>
        <?php echo $form->hiddenfield($model, 'document_file'); ?>  
    </li>
    <li class="col-sm-1">
	    <button style="margin-top:24px;" type="button" class="activity-document-save-btn btn btn-theme" onclick="saveDocument();">Save</button>
	</li>	
	</div>
</ul>
<br/>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-user"></i> Documents
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_activitydocument_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Document Type</th>
                        <th>Document Name</th>
                        <th>Uploaded By</th>
                        <th>Uploaded Date & Time</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Document Type</th>
                        <th>Document Name</th>
                        <th>Uploaded By</th>
                        <th>Uploaded Date & Time</th>
                        <th>Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>

<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
    <?php
//    $url = Yii::app()->createUrl('activity/saveActivityDocument');
//    echo CHtml::ajaxSubmitButton('Save', $url, array(
//        'dataType' => 'json',
//        'type' => 'post',
//        'success' => 'function(data) {
//                    if(data.status=="success"){  
//                        t8.success("Documents Uploaded Successfully!"); 
//                        reloadTable("#tbl_activitydocument_details");
//                    } else { 
//                        $.each(data, function(key, val) {
//                            t8.error(""+val+""); 
//                        }); 
//                    } 
//                }',
//        'beforeSend' => 'function(){
//                $("#loader").show();
//                    $("#activity-document-form .activity-document-save-btn").prop("disabled", true);  
//                    $("#activity-document-form .activity-document-save-btn").addClass("btn_loading").removeClass("btn-theme");                
//                    $(".toast8-error").hide(); 
//                }',
//        'complete' => 'function(){
//                $("#activity-document-form .activity-document-btn").prop("disabled", false);
//                $("#activity-document-form .activity-document-save-btn").addClass("btn-theme").removeClass("btn_loading");
//                $("#loader").hide();
//            }'
//            ), array('id' => 'mybtn' . rand(), 'class' => 'activity-document-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
//Start Document Save
$cs->registerScript('saveDocument', 'function saveDocument(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#activity-document-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('activity/saveActivityDocument') . '",
        "success":function(data){
            if(data.status=="success"){  
                $("#ActivityDocument_id").val("");
                $("#ActivityDocument_customer_id").val("");
                $("#ActivityDocument_document_name").val("");
                $("#ActivityDocument_document_file").val("");
                $("#ActivityDocument_document_type").multiselect("select","");
                t8.success("Documents Uploaded Successfully!");
                reloadTable("#tbl_activitydocument_details");
            } else { 
               $.each(data, function(key, val) {
                       t8.error(""+val+""); 
               }); 
            } 
        },
        "beforeSend":function(){
            $("#loader").show();
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
//End Document Save
//Script to load details on tab while editing-starts
$cs->registerScript("editdocumentdetails", "function editdocumentdetails(id) {          
        jQuery.ajax({
            'dataType':'json',
            'data' : {
                'id':id
            },
            'type':'post',
            'url': '" . Yii::app()->createUrl('activity/editdocumentdetails') . "',
            'cache': false,
            'success': function(data) { 
                if(data.status='success'){
                    $('#ActivityDocument_id').val(data.id);
                    $('#ActivityDocument_customer_id').val(data.customer_id);
                    $('#ActivityDocument_document_name').val(data.document_name);
                    $('#ActivityDocument_document_name').addClass('filled');
                    $('#ActivityDocument_document_file').val(data.document_file);
                    $('#ActivityDocument_document_type').multiselect('select',data.document_type);
                }
            },
            'beforeSend':function(){
            $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
    });
};", CClientScript::POS_HEAD);
//Script to load details on tab while editing-ends
$cs->registerScript("deletedocument",  "function deletedocument(id){
    var r = confirm('Confirm Document Deletion?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=activity/deletedocument',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_activitydocument_details');
                    t8.success('Document Deleted SuccessFully!');                   
                }else {                   
                    t8.error('Error in Deletion');
                }
               },
               'beforeSend':function(){
                $('#loader').show();
                },
                'complete':function(){
                    $('#loader').hide();
                }
            });
        }
};", CClientScript::POS_HEAD);
?>