<?php

/**
 * This is the model class for table "{{user_target}}".
 *
 * The followings are the available columns in table '{{user_target}}':
 * @property integer $id
 * @property integer $user_id
 * @property integer $target_id
 * @property integer $target_amount
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class UserTarget extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{user_target}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, target_id,target_year, target_amount', 'required'),
			array('user_id, target_id, target_amount, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
                        array('user_id', 'validateduplicatetarget'),
                        array('target_amount', 'validatetarget'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, target_id, target_amount, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'userdetails' => array(self::BELONGS_TO, 'User', 'user_id'),
		);
	}
        public function validatetarget(){
            if($this->target_amount < 0){
                $this->addError('target_amount','Target amount cannot be negative');
                $this->rules();
            }
                return true;
        }
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'target_id' => 'Target',
			'target_amount' => 'Target Amount',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('target_id',$this->target_id);
		$criteria->compare('target_amount',$this->target_amount);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return UserTarget the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function validateduplicatetarget($attribute) {
            if ($this->user_id!=''&& $this->start_date!='' && $this->end_date!='' && $this->target_id!='') {
                $condition='user_id="'.$this->user_id.'" and target_id="'.$this->target_id.'" and start_date>="'.$this->start_date.'" and end_date<="'.$this->end_date.'"';
                if($this->id>0){
                    $condition.=' and id!="'.$this->id.'"';
                }      
                $model = self::model()->find(array('condition' =>$condition));
                if(!empty($model)){
                    $this->addError($attribute, 'Target already exist in this date');
                    return false;
                } 
                else{
                    return true;
                }
            }
           
        }
        public static function listYears($less,$high) {
            $arr_years = array();
            $cur_year  = date("Y");
            $start_year = $cur_year-$less;
            $end_year = $cur_year+$high;
            for ($i=$start_year;$i<=$end_year;$i++){
              $arr_years[$i]=$i;
            }
            return $arr_years;
        }
}
