<?php

/**
 * This is the model class for table "{{user_commission_withdrawal}}".
 *
 * The followings are the available columns in table '{{user_commission_withdrawal}}':
 * @property integer $id
 * @property integer $user_id
 * @property string $transfer_date
 * @property string $transfer_amount
 * @property string $remarks
 * @property integer $created_by
 * @property string $created_date_time
 */
class UserCommissionWithdrawal extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{user_commission_withdrawal}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, transfer_date, transfer_amount', 'required'),
			array('user_id, created_by', 'numerical', 'integerOnly'=>true),
			array('remarks', 'length', 'max'=>5000),
			array('transfer_amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, transfer_date, transfer_amount, remarks, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'user_detail'=>array(self::BELONGS_TO,'User','user_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'transfer_date' => 'Transfer Date',
			'transfer_amount' => 'Transfer Amount',
			'remarks' => 'Remarks',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('transfer_date',$this->transfer_date,true);
		$criteria->compare('transfer_amount',$this->transfer_amount,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return UserCommissionWithdrawal the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
