<?php

/**
 * This is the model class for table "{{mas_provider_plans}}".
 *
 * The followings are the available columns in table '{{mas_provider_plans}}':
 * @property integer $id
 * @property integer $provider_id
 * @property string $plan_name
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasProviderPlans extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_provider_plans}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('provider_id, plan_name', 'required'),
			array('provider_id,icp_months, created_by, updated_by', 'numerical', 'integerOnly'=>true),
                        array('plan_name', 'validateplanname'),
			array('plan_name', 'length', 'max'=>255),
			array('is_deferement_plan,isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, provider_id, plan_name, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'provider'=>array(self::BELONGS_TO,'Provider','provider_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'provider_id' => 'Provider',
			'plan_name' => 'Plan Name',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('provider_id',$this->provider_id);
		$criteria->compare('plan_name',$this->plan_name,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasProviderPlans the static model class
	 */
        public function validateplanname($attribute) {
            $condition= 'provider_id ="'.$this->provider_id.'" and plan_name ="'.$this->plan_name.'"';
            if($this->id>0){
                $condition.=' AND id!="'.$this->id.'"';
            }
            $model = self::model()->findAll(array('condition' => $condition));
            if(!empty($model)){
                $this->addError($attribute, 'Plan already exist for this provider');
                return false;
            }else{
                return true;
            }        
        }
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getPlansByProvider($provider_id=0) {
            $condition='1=1 ';
            if($provider_id>0){
                $condition = 'provider_id =' . $provider_id;
            }
            $model = self::model()->findAll(array('select'=>'t.id,t.plan_name','condition' => $condition, 'order' => 't.plan_name'));
            return CHtml::listData($model, 'id', 'plan_name');
        }
}
