<?php

/**
 * This is the model class for table "{{mas_health_status}}".
 *
 * The followings are the available columns in table '{{mas_health_status}}':
 * @property integer $id
 * @property string $health_status
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 */
class MasHealthStatus extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_health_status}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('health_status', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('health_status,health_logo', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, health_status, isActive, created_by, updated_by, created_date_time, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'health_status' => 'Marital Status',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_date_time' => 'Created Date Time',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	 public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('health_status'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('health_status like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.health_status ASC',
            ),
        ));
    }
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasHealthStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getHealthStatus() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'health_status'));
        return CHtml::listData($model, 'id', 'health_status');
    }
    public static function getStatuswithImg() {
        $model = self::model()->findAll(array( 'condition' => 'isActive = "Y"', 'order'=>'health_status'));
        $data = array();
        foreach( $model as $each )
                $data[$each->id] = array( 'data-image'=> 'uploads/health/'.$each->health_logo );
        return $data;
    }
}
