<?php

/**
 * This is the model class for table "{{mas_document}}".
 *
 * The followings are the available columns in table '{{mas_document}}':
 * @property integer $id
 * @property string $document_name
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasDocument extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_document}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('document_name,view_in', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('document_name', 'length', 'max'=>500),
                        array('document_name', 'validateduplicatedocument'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, document_name, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'document_name' => 'Document Name',
                        'view_in' => 'Document Type',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('document_name',$this->document_name,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasDocument the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getDocumentName() {
            $condition = 'isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name'));
            return CHtml::listData($model, 'id', 'document_name');
        }
        public static function getCustomerDocument() {
            $condition = 'isActive =  "Y" and view_in="2"';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name'));
            return CHtml::listData($model, 'id', 'document_name');
        }
        public static function getActivityDocument() {
            $condition = 'isActive =  "Y" and view_in="1" AND FIND_IN_SET("'.Yii::app()->user->user_group_id.'",usergroup_id)';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name'));
            return CHtml::listData($model, 'id', 'document_name');
        }
        public function validateduplicatedocument($attribute) {
            if ($this->document_name!=''&& $this->view_in!='') {
                $condition='document_name="'.$this->document_name.'" and view_in="'.$this->view_in.'"';
                if($this->id>0){
                    $condition.=' and id!="'.$this->id.'"';
                }      
                $model = self::model()->find(array('condition' =>$condition));
                if(!empty($model)){
                    $this->addError($attribute, 'Document already exist');
                    return false;
                } 
                else{
                    return true;
                }
            }
           
        }
}
