<?php

/**
 * This is the model class for table "{{mas_country}}".
 *
 * The followings are the available columns in table '{{mas_country}}':
 * @property integer $id
 * @property string $country_name
 * @property string $country_code
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 * @property MasCompany[] $masCompanies1
 */
class MasCountry extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_country}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('country_name, country_code', 'required'),
            array('country_name,phone_code,flag_name', 'length', 'max' => 255),
            array('country_name', 'unique'),
            array('country_name', 'filter', 'filter'=>'trim'),
            array('country_code', 'length', 'max' => 100),
            array('isActive,show_country_list', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, country_name, country_code, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'masCompanies' => array(self::HAS_MANY, 'MasCompany', 'bill_country'),
            'masCompanies1' => array(self::HAS_MANY, 'MasCompany', 'shipp_country'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'country_name' => 'Country Name',
            'country_code' => 'Country Code',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
 
        public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('country_name'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('country_name like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.country_name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCountry the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    // function writen by TobyAlex

    public static function getCountry() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'country_name'));
        return CHtml::listData($model, 'id', 'country_name');
    }
    
     public static function getCountryCode() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'country_code'));
        return CHtml::listData($model, 'id', 'country_code');
    }
    
    public static function getCountryNameByCode() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'country_code'));
        return CHtml::listData($model,'country_code', 'country_name');
    }
    
    public static function getCountryName() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'country_name'));
        return CHtml::listData($model, 'id', 'country_name');
    }
    public static function getCountryImg() {
        $model = self::model()->findAll(array('condition' => 'isActive =  "Y"','order'=>'country_name'));
        $data = array();
        foreach( $model as $each )
                $data[$each->id] = array( 'data-image'=> 'uploads/flag/'.$each->flag_name );
        return $data;
    }
    public static function getFilledCountryName($id) {
        $model = self::model()->findByPk($id);
        return $model->country_name;
    }
    public static function getActiveCountryName() {
        $condition = 'isActive =  "Y" AND show_country_list="Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'country_name'));
        return CHtml::listData($model, 'id', 'country_name');
    }
    public static function getCountrywithImg() {
        $model = self::model()->findAll(array('condition' => 'isActive =  "Y" AND show_country_list="Y"','order'=>'country_name'));
        $data = array();
        foreach( $model as $each )
                $data[$each->id] = array( 'data-image'=> 'uploads/flag/'.$each->flag_name );
        return $data;
    }

}
