<?php

/**
 * This is the model class for table "{{lead_customer}}".
 *
 * The followings are the available columns in table '{{lead_customer}}':
 * @property integer $id
 * @property string $customer_first_name
 * @property string $customer_middle_name
 * @property string $customer_last_name
 * @property string $customer_mobile_number
 * @property integer $customer_source_prospect
 * @property string $lead_conversion_date
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class LeadCustomer extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{lead_customer}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $mobile_code;
        public $mobile_number;
        public $country;
        public $source;
        public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_first_name, customer_last_name,customer_country_id, customer_mobile_number, customer_source_prospect', 'required'),
			array('customer_source_prospect,customer_country_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
                        array('customer_first_name, customer_last_name,customer_country_id, customer_mobile_number, customer_source_prospect', 'required', 'on' => 'excelupload'),
			array('call_back_date_time', 'validatefollowupDate', 'on' => 'excelupload'),
                        array('customer_mobile_number', 'validatemobilenumber', 'on' => 'excelupload'),
                        array('customer_first_name, customer_middle_name, customer_last_name,customer_email,referred_by', 'length', 'max'=>500),
			array('customer_mobile_number', 'length', 'max'=>100),
                       // array('customer_mobile_number', 'unique'),
			array('isActive,status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_first_name, customer_middle_name, customer_last_name,customer_country_id, customer_mobile_number, customer_source_prospect, lead_conversion_date, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}
        public function validatefollowupDate($attribute) {
            if($this->call_back_date_time!=''){
                //if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])[0-9]{2}:[0-9]{2} $/", $this->call_back_date_time)) {
                if(DateTime::createFromFormat('Y-m-d H:i', $this->call_back_date_time) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Not in YYYY-mm-dd hh:mm Format');
                    return false; 
                }
            }else{
                return true;
            }
        }
        public function validatemobilenumber($attribute) {
            if($this->customer_mobile_number!=''){
                $model_customer_exist = Customer::model()->find(array('condition' =>'cust_mobile1="'.$this->customer_mobile_number.'" AND cust_executive_id!="'.Yii::app()->user->id.'"'));
                if (!empty($model_customer_exist)) {
                    $this->addError($attribute, 'Mobile number already exist');
                    return false;                 
                } else {
                    return true;
                }
            }
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'addedby' => array(self::BELONGS_TO, 'User', 'created_by'),
                    'countrydetails' => array(self::BELONGS_TO, 'MasCountry', 'customer_country_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_first_name' => 'Customer First Name',
			'customer_middle_name' => 'Customer Middle Name',
			'customer_last_name' => 'Customer Last Name',
			'customer_mobile_number' => 'Customer Mobile Number',
                        'customer_country_id'=>'Customer Country',
			'customer_source_prospect' => 'Customer Source Prospect',
			'lead_conversion_date' => 'Lead Conversion Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_first_name',$this->customer_first_name,true);
		$criteria->compare('customer_middle_name',$this->customer_middle_name,true);
		$criteria->compare('customer_last_name',$this->customer_last_name,true);
		$criteria->compare('customer_mobile_number',$this->customer_mobile_number,true);
		$criteria->compare('customer_source_prospect',$this->customer_source_prospect);
		$criteria->compare('lead_conversion_date',$this->lead_conversion_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return LeadCustomer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function getfullname() {
            return ($this->customer_first_name . ' ' . $this->customer_middle_name. ' ' . $this->customer_last_name);
        }
}
