<?php

/**
 * This is the model class for table "{{customer_dependants}}".
 *
 * The followings are the available columns in table '{{customer_dependants}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $dependant_name
 * @property string $relationship
 * @property string $dependant_date_of_birth
 */
class CustomerDependants extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $dependant_age; 
	public function tableName()
	{
		return '{{customer_dependants}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, dependant_name, relationship, dependant_date_of_birth', 'required'),
			array('customer_id', 'numerical', 'integerOnly'=>true),
			array('dependant_name, relationship', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, dependant_name, relationship, dependant_date_of_birth', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'dependant_name' => 'Name',
			'relationship' => 'Relationship',
			'dependant_date_of_birth' => 'Date Of Birth',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('dependant_name',$this->dependant_name,true);
		$criteria->compare('relationship',$this->relationship,true);
		$criteria->compare('dependant_date_of_birth',$this->dependant_date_of_birth,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerDependants the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
