<?php

/**
 * This is the model class for table "{{customer}}".
 *
 * The followings are the available columns in table '{{customer}}':
 * @property integer $id
 * @property string $cust_first_name
 * @property string $cust_middle_name
 * @property string $cust_last_name
 * @property string $cust_company_name
 * @property integer $cust_emirate_id
 * @property integer $cust_country_code
 * @property integer $cust_nationality_id
 * @property string $cust_po_box
 * @property string $cust_phone_no
 * @property string $cust_mobile1
 * @property string $cust_mobile2
 * @property string $cust_email1
 * @property string $cust_email2
 * @property string $cust_res_address
 * @property string $cust_res_number
 * @property string $cust_smoker
 * @property integer $cust_marital_status
 * @property string $cust_health
 * @property string $cust_executive_id
 * @property string $cust_notes
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Customer extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $cust_age;
    public $cust_executive_name;
    public $cust_spouse_age;

    public function tableName() {
        return '{{customer}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public $mobile_code;
    public $mobile_number;
    public $source,$emt,$nat,$cont,$mt_status,$health,$exec,$gender;
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('cust_first_name, cust_last_name, cust_date_of_birth, cust_emirate_id, cust_country_code, cust_nationality_id, cust_phone_no, cust_mobile1, cust_email1, cust_smoker, cust_marital_status, cust_health, cust_executive_id', 'required'),
            array('cust_gender,cust_emirate_id, cust_nationality_id, cust_marital_status,cust_prospect_source,cust_status, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('cust_first_name, cust_middle_name, cust_last_name, cust_company_name, cust_res_address, cust_res_number, cust_smoker, cust_health, cust_executive_id,cust_spouse_first_name,cust_spouse_middle_name,cust_spouse_last_name,cust_spouse_date_of_birth', 'length', 'max' => 255),
            array('cust_po_box, cust_phone_no, cust_mobile1, cust_mobile2', 'length', 'max' => 100),
            array('cust_first_name, cust_last_name, cust_date_of_birth, cust_emirate_id, cust_country_code, cust_nationality_id, cust_phone_no, cust_mobile1, cust_email1, cust_smoker, cust_marital_status, cust_health, cust_executive_id', 'required','on'=>'excelupload'),
            array('cust_email1, cust_email2', 'length', 'max' => 150),
            array('isActive,cust_executive_change_request,cust_policy_taken,cust_type,cust_mail_needed', 'length', 'max' => 1),
            array('cust_date_of_birth', 'validatedob', 'on' => 'excelupload'),
            array('cust_mobile1', 'unique'),
            array('cust_spouse_first_name', 'validateSpouse'),
            array('cust_mobile1', 'validateNumber'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, cust_first_name, cust_middle_name, cust_last_name, cust_company_name, cust_emirate_id, cust_country_code, cust_nationality_id, cust_po_box, cust_phone_no, cust_mobile1, cust_mobile2, cust_email1, cust_email2, cust_res_address, cust_res_number, cust_smoker, cust_marital_status, cust_health, cust_executive_id, cust_notes,cust_spouse_middle_name,cust_spouse_first_name,cust_spouse_last_name,cust_spouse_date_of_birth, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'country' => array(self::BELONGS_TO, 'MasCountry', 'cust_country_code'),
            'nationality' => array(self::BELONGS_TO, 'MasCountry', 'cust_nationality_id'),
            'emirates' => array(self::BELONGS_TO, 'MasEmirates', 'cust_emirate_id'),
            'executive' => array(self::BELONGS_TO, 'User', 'cust_executive_id'),
            'maritalstatus' => array(self::BELONGS_TO, 'MasMaritalStatus', 'cust_marital_status'),
            'fitness' => array(self::BELONGS_TO, 'MasHealthStatus', 'cust_health'),
            'plandetails' => array(self::HAS_MANY, 'CustomerPlanDetails', 'customer_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'cust_first_name' => 'First Name',
            'cust_middle_name' => 'Middle Name',
            'cust_last_name' => 'Last Name',
            'cust_date_of_birth' => 'Date of Birth',
            'cust_company_name' => 'Company Name',
            'cust_emirate_id' => 'Emirate',
            'cust_country_code' => 'Country',
            'cust_nationality_id' => 'Nationality',
            'cust_po_box' => 'Po Box',
            'cust_phone_no' => 'Phone No',
            'cust_mobile1' => 'Mobile',
            'cust_mobile2' => 'Mobile',
            'cust_email1' => 'Personal Email',
            'cust_email2' => 'Official Email',
            'cust_res_address' => 'Residence Address',
            'cust_res_number' => 'Residence Number',
            'cust_smoker' => 'Residence Area',
            'cust_marital_status' => 'Marital Status',
            'cust_health' => 'Health',
            'cust_executive_id' => 'Executive Name',
            'cust_notes' => 'Notes',
            'cust_spouse_first_name' => 'Spouse First Name',
            'cust_spouse_middle_name' => 'Spouse Middle Name',
            'cust_spouse_last_name' => 'Spouse Last Name',
            'cust_spouse_date_of_birth' => 'Spouse Date of Birth',
            'isActive' => 'Is Active',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('cust_first_name', $this->cust_first_name, true);
        $criteria->compare('cust_middle_name', $this->cust_middle_name, true);
        $criteria->compare('cust_last_name', $this->cust_last_name, true);
        $criteria->compare('cust_company_name', $this->cust_company_name, true);
        $criteria->compare('cust_emirate_id', $this->cust_emirate_id);
        $criteria->compare('cust_country_code', $this->cust_country_code);
        $criteria->compare('cust_nationality_id', $this->cust_nationality_id);
        $criteria->compare('cust_po_box', $this->cust_po_box, true);
        $criteria->compare('cust_phone_no', $this->cust_phone_no, true);
        $criteria->compare('cust_mobile1', $this->cust_mobile1, true);
        $criteria->compare('cust_mobile2', $this->cust_mobile2, true);
        $criteria->compare('cust_email1', $this->cust_email1, true);
        $criteria->compare('cust_email2', $this->cust_email2, true);
        $criteria->compare('cust_res_address', $this->cust_res_address, true);
        $criteria->compare('cust_res_number', $this->cust_res_number, true);
        $criteria->compare('cust_smoker', $this->cust_smoker, true);
        $criteria->compare('cust_marital_status', $this->cust_marital_status);
        $criteria->compare('cust_health', $this->cust_health, true);
        $criteria->compare('cust_executive_id', $this->cust_executive_id, true);
        $criteria->compare('cust_notes', $this->cust_notes, true);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Customer the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    //to get fullname of customer
    public function getFullname() {
        return ($this->cust_first_name . ' ' . $this->cust_middle_name . ' ' . $this->cust_last_name);
    }
    public function getspousefullname() {
        return ($this->cust_spouse_first_name . ' ' . $this->cust_spouse_middle_name . ' ' . $this->cust_spouse_last_name);
    }

    function beforeSave() {
        if (isset($_POST["Customer"]["cust_mobile1"]) && $_POST["Customer"]["cust_mobile1"] != '') {
            $cust_mobile1 = $_POST["Customer"]["cust_mobile1"];
            $cust_mobile1 = str_replace(' ', '', $cust_mobile1);
            $cust_mobile1 = str_replace('+', '', $cust_mobile1);
            $cust_mobile1 = str_replace('-', '', $cust_mobile1);
            $this->cust_mobile1 = $cust_mobile1;
        }
        return true;
    }

    function toFormattedPhoneNo() {
        $cust_country_code = $this->cust_country_code;

        $cust_mobile1 = $this->cust_mobile1;
        $model = MasCountry::model()->findByPk($cust_country_code);
        $prefix = str_replace('+', '', $model->phone_code);

        $cust_mobile1 = substr($cust_mobile1, strlen($prefix));

        $cust_mobile1 = "+" . $prefix . "-" . $cust_mobile1;

        return $cust_mobile1;
    }
    public function validatedob($attribute) {
            if($this->cust_date_of_birth!=''){
                if(DateTime::createFromFormat('Y-m-d', $this->cust_date_of_birth) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Not in YYYY-mm-dd Format');
                    return false; 
                }
            }else{
                return true;
            }
    }
    public function validateNumber($attribute) {
        $cust_mobile1 = $this->cust_mobile1;
        $cust_mobile1 = str_replace(' ', '', $cust_mobile1);
        $cust_mobile1 = str_replace('+', '', $cust_mobile1);
        $cust_mobile1 = str_replace('-', '', $cust_mobile1);
        $condition = " t.cust_mobile1 ='" . $cust_mobile1 . "' ";
        if ($this->id != "") {
            $condition .= " AND t.id !=" . $this->id;
        }
        $model = Customer::model()->findAll($condition);
        if ($model==null) {
            return true;
        } else {
            $this->addError($attribute, 'Mobile Number  Already Exist');
            return false;
        }
    }
    public function validateSpouse($attribute) {
        $spouse = $this->cust_spouse_first_name;
        if ($spouse=='') {
            return true;
        }
        else if($this->cust_spouse_last_name=='' && $this->cust_spouse_date_of_birth==''){
            $this->addError($attribute, 'Spouse Last Name is Mandatory');
            $this->addError($attribute, 'Spouse DOB is Mandatory');
            return false;
        }
        else if($this->cust_spouse_date_of_birth==''){
            $this->addError($attribute, 'Spouse DOB is Mandatory');
            return false;            
        }else if($this->cust_spouse_last_name==''){
            $this->addError($attribute, 'Spouse Last Name is Mandatory');
            return false;
        }
        else{
            return true;
        }     
    }

}
