<?php

class UserwithdrawalController extends Controller {
    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }
 
    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {
 
        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    } 
    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save','GetSelectedUserBalance'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        //echo $_GET; exit;
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
    }

    public function actionGetList() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) { 
        $model = new UserCommissionWithdrawal();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'user_detail.first_name',
            2 => 't.transfer_date',
            3 => 't.transfer_amount',
            4 => 't.remarks'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        // if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
        //     $searchString = $_POST['search']['value'];
        //     $condition .= " and ( user_detail.first_name LIKE '%" . $searchString . "%' OR t.remarks LIKE '%" . $searchString . "%')";
        // }
        // $count = $model->count(array('condition' => $condition));
        // $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        // $recordsTotal = $count;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (CONCAT(user_detail.first_name, ' ', user_detail.last_name) LIKE '%" . $searchString . "%' 
                             OR user_detail.first_name LIKE '%" . $searchString . "%' 
                             OR user_detail.last_name LIKE '%" . $searchString . "%' 
                             OR t.remarks LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('user_detail')->count(array('condition' => $condition));
        $model = $model->with('user_detail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            //$div = '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'use/create&id=' . $row['id'] . '\',\'Edit\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $rowData[] = array(
                $m,
                $row['user_detail']['fullname'],
                date("d/m/Y", strtotime($row['transfer_date'])),
                '<div class="text-right">' . $row['transfer_amount'] . '</div>',
                $row['remarks']
            );
             //,  '<div class="btn-wrap text-center">' . $div . '</div>'
            $m++;
        }



        $data['data'] = $rowData;
        echo json_encode($data);
        // echo json_encode($data);
    }else{
        $this->renderPartial('../index_error');
    }
    }

    public function actionCreate() {
        $model = new UserCommissionWithdrawal();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        Yii::app()->clientScript->scriptMap = array('jquery.js' => false, 'jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(isset($_POST) && count($_POST) > 0){
        $model = new UserCommissionWithdrawal();
        if (isset($_POST['UserCommissionWithdrawal'])) {
            if ((int) @$_POST['UserCommissionWithdrawal']['id'] > 0) {
                $id = (int) @$_POST['UserCommissionWithdrawal']['id'];
                $model = $model->findByPk($id);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['UserCommissionWithdrawal'];
            if ($_POST['UserCommissionWithdrawal']['transfer_date'] != '') {
                $model->transfer_date = str_replace('/', '-', $_POST['UserCommissionWithdrawal']['transfer_date']);
                $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
            }
            if ($model->save()) {
                $desc='Executive Withdrawal ON '.$model->transfer_date;
                $this->savetoCommissionLedger(0,$model->user_id,0,$model->transfer_date,100,
                                            $model->transfer_amount,0,$model->transfer_amount,'EXE_WDL',$desc,'OUT',
                                            'GEN',0,0,0,'NA');
                //update totals to executive
                $model_exe= User::model()->findbyPK($model->user_id);
                $account_balance=$model_exe->account_total_amount-$model->transfer_amount;
                User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['userwithdrawal-form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    else{
        $this->renderPartial('../index_error');
   } 
    }
    ////savetoCommissionLedger-start
    public function savetoCommissionLedger($id,$user_id,$cus_plan_id,$transaction_date,$percentage,
                                            $total_amount,$in_amount,$out_amount,$type,$desc,$in_or_out,
                                            $user_account,$provider_id,$customer_id,$mas_plan_id,$status) {
        $model_ledger = new CommissionLedger();
        $model_ledger->commision_upload_id=$id;
        $model_ledger->user_id=$user_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$desc;
        $model_ledger->user_account=$user_account;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->status=$status;        
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        $model_ledger->save(false);     
        return true;
    }    
    //savetoCommissionLedger-end
    public function actionGetSelectedUserBalance(){
        $user_id =$_POST['user_id'];
        $user_model = User::model()->findByPk($user_id);
        $data['amount']=$user_model->account_total_amount;
        $data['status']='Success';
        echo CJSON::encode($data);
    }
}
