<?php

class SubmissionController extends Controller {

    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetCustomerList'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
    }
    public function actionGetCustomerList1() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) { 
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $model = new Activity();
        $columns = array(
            // datatable column index  => database column name
            0 => 'C.id',
            1 => 'C.cust_first_name',
            2 => 'C.cust_mobile1',
            3 => 'C.cust_email1',
            4 => 'C.customer_phone_no',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        //$orderBy = "t.cust_first_name ASC";
        $current_date=date('Y-m-d'); 
        /******** First Loading Without Search********/
        $condition = 'type_of_activity="6" and application_status="I" AND C.isActive="Y" AND (C.cust_executive_id="'.Yii::app()->user->id.'" OR C.cust_executive_id IN ('.Yii::app()->user->connected_users.'))';
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "type_of_activity='6' and C.isActive='Y' AND 
                            (((C.cust_executive_id='".Yii::app()->user->id."' OR C.cust_executive_id IN (".Yii::app()->user->connected_users."))
                                AND ( C.cust_first_name LIKE '%" . $searchString . "%' 
                                OR C.cust_middle_name LIKE '%" . $searchString . "%'
                                OR C.cust_last_name LIKE '%" . $searchString . "%' 
                                OR C.cust_phone_no LIKE '%" . $searchString . "%' 
                                OR C.cust_mobile1 LIKE '%" . $searchString . "%')
                             )OR(C.cust_mobile1 = '" . $searchString . "' AND C.cust_policy_taken='N' AND C.cust_locked_date<'".$current_date."')
                            )";
        }       
            $connection = Yii::app()->db->createCommand()
                        ->select('C.id as id,C.cust_first_name AS cust_first_name,C.cust_middle_name AS cust_middle_name,C.cust_last_name AS cust_last_name,C.cust_mobile1 AS cust_mobile1,C.cust_email1 as cust_email1,C.cust_executive_id AS cust_executive_id')   
                        ->from('{{customer}} C')
                        ->leftjoin('{{activity}} A', 'C.id = A.customer_id')
                        ->leftjoin('{{provider_send_receive_info}} P','P.customer_id = A.customer_id and A.plan_id = P.plan_id AND ((send_method="1" AND send_receive_type!="2") AND (send_method="2" AND send_receive_type!="2"))')
                        ->where($condition)
                        ->group('C.id');
            $model = $connection->queryAll();
            $count=count($model);
//        $count = $model->with('customerdetails')->count(array('condition' => $condition));
//        $model = $model->with('customerdetails')->findAll(array('condition' => $condition,'group'=>'customer_id', 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        $connected_user=  explode(',', Yii::app()->user->connected_users);
        foreach ($model as $row) {
            $div='';
            if(Yii::app()->user->id==$row['cust_executive_id'] || in_array($row['cust_executive_id'],$connected_user)){
                $div.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'customer/create&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'].' '.$row['cust_middle_name'].' '.$row['cust_last_name']. '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                $div .= ' <a  href="?r=reportpdf/customerdetails&id=' . $row['id'] . '" class="btn btn-primary btn-xs" title="Print Details" target="_blank"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a> ';
                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_send_view"])){
                $div .= ' <button class="btn btn-primary btn-xs" title ="Send Info Provider" onclick="loadPopupModal(\'providerinfo/createsend&customer_id=' . $row['id'] . '\',\'' . $row['cust_first_name'].' '.$row['cust_middle_name'].' '.$row['cust_last_name'] . ' - Send Info Provider ' . '\',\'xl\')"><i class="fa fa-hand-o-right"></i></button>';
                }
                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_receive_view"])){
                $div .= ' <button class="btn btn-primary btn-xs" title ="Information from Provider" onclick="loadPopupModal(\'providerinfo/createreceive&customer_id=' . $row['id'] . '\',\'' .$row['cust_first_name'].' '.$row['cust_middle_name'].' '.$row['cust_last_name']. ' - Information from Provider ' . '\',\'xl\')"><i class="fa fa-arrow-circle-o-left"></i></button>';
                }
            }
            $current_date_time=date("Y-m-d H:i");
            $call_back_or_actual_date='';
            $model_activity = Activity::model()->find(array('condition' =>'type_of_activity="1" and customer_id="'.$row['customer_id'].'" and call_back_or_actual_date>"'.$current_date_time.'"','order'=>'call_back_or_actual_date asc'));
            if($model_activity->call_back_or_actual_date!='' && $model_activity->call_back_or_actual_date!='0000-00-00 00:00:00'){
                $call_back_or_actual_date=date("d/m/Y H:i",strtotime($model_activity->call_back_or_actual_date));
            }
            $customer_code='GR-'.$row['id'];
            $rowData[] = array($customer_code, $row['cust_first_name'].' '.$row['cust_middle_name'].' '.$row['cust_last_name'], $row['cust_mobile1'], $row['cust_email1'],$call_back_or_actual_date ,'<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }else{
        $this->renderPartial('../index_error');
    }

    }
    public function actionGetCustomerList() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) { 
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $model = new Activity();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'customerdetails.cust_first_name',
            2 => 'customerdetails.customer_address',
            3 => 'customerdetails.customer_city',
            4 => 'customerdetails.customer_phone_no',
            5 => 'customerdetails.customer_email_id',
            6 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        //$orderBy = "t.cust_first_name ASC";
        $current_date=date('Y-m-d'); 
        /******** First Loading Without Search********/
        $condition = 'type_of_activity="6" and application_status="I" and customerdetails.isActive="Y" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.'))';
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "type_of_activity='6' and t.isActive='Y' AND 
                            (((customerdetails.cust_executive_id='".Yii::app()->user->id."' OR customerdetails.cust_executive_id IN (".Yii::app()->user->connected_users."))
                                AND ( customerdetails.cust_first_name LIKE '%" . $searchString . "%' 
                                OR customerdetails.cust_middle_name LIKE '%" . $searchString . "%'
                                OR customerdetails.cust_last_name LIKE '%" . $searchString . "%' 
                                OR customerdetails.cust_phone_no LIKE '%" . $searchString . "%' 
                                OR customerdetails.cust_mobile1 LIKE '%" . $searchString . "%')
                             )OR(customerdetails.cust_mobile1 = '" . $searchString . "' AND customerdetails.cust_policy_taken='N' AND customerdetails.cust_locked_date<'".$current_date."')
                            )";
        }        
        $count = $model->with('customerdetails')->count(array('condition' => $condition));
        $model = $model->with('customerdetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        $connected_user=  explode(',', Yii::app()->user->connected_users);
        foreach ($model as $row) {
            $div='';
            if(Yii::app()->user->id==$row['customerdetails']['cust_executive_id'] || in_array($row['customerdetails']['cust_executive_id'],$connected_user)){
                $div.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'customer/create&id=' . $row['customer_id'] . '\',\'' . $row['customer_id'] . ' : ' . $row['customerdetails']['fullname']. '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                $div .= ' <a  href="?r=reportpdf/customerdetails&id=' . $row['customer_id'] . '" class="btn btn-primary btn-xs" title="Print Details" target="_blank"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a> ';
                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_send_view"])){
                    $div .= ' <button class="btn btn-primary btn-xs" title ="Send Info Provider" onclick="loadPopupModal(\'providerinfo/createsend&customer_id=' . $row['customer_id'] . '&activity_id=' . $row['id'] . '&plan_id=' . $row['plan_id'] . '\',\'' . $row['customerdetails']['fullname'] . ' - Send Info Provider ' . '\',\'xl\')"><i class="fa fa-hand-o-right"></i></button>';
                }
                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_receive_view"])){
                    $div .= ' <button class="btn btn-primary btn-xs" title ="Information from Provider" onclick="loadPopupModal(\'providerinfo/createreceive&customer_id=' . $row['customer_id'] . '&activity_id=' . $row['id'] . '&plan_id=' . $row['plan_id'] . '\',\'' . $row['customerdetails']['fullname'] . ' - Information from Provider ' . '\',\'xl\')"><i class="fa fa-arrow-circle-o-left"></i></button>';
                }
            }
            $send_or_receive_date_time='';
            $model_send_info= ProviderSendReceiveInfo::model()->find(array('condition' =>'activity_id="'.$row['id'].'" and send_or_receive="R" and send_receive_type="2"'));
            if($model_send_info->send_or_receive_date_time!='' && $model_send_info->send_or_receive_date_time!='0000-00-00 00:00:00'){
                $send_or_receive_date_time=date("d/m/Y H:i",strtotime($model_send_info->send_or_receive_date_time));
            }
            $customer_code='GR-'.$row['customer_id'];
            
            $rowData[] = array($customer_code, $row['customerdetails']['Fullname'],$row['plan_detail']['masplandetails']['plan_name'],$row['plan_detail']['providerdetails']['provider_name'],$send_or_receive_date_time,'<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);

    }else{
        $this->renderPartial('../index_error');
    }

    }
    
    

}
