<?php

class ProviderController extends Controller {

    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetProviderDetails', 'SaveProvider', 'Upload', 'uploadCommission', 'readCSV', 'SaveUploadedFile',
                    'DownloadErrorCsv', 'downloadformat','UploadCSV'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        //$this->render('index');
        $_GET = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if (count($_GET) > 0) {
            $this->render('index');
        } else {
            $this->renderPartial('../index_error');
        }
    }

    /** For loading Provider Details * */
    public function actionGetProviderDetails() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) {
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $model = new Provider();
            $columns = array(
                // datatable column index  => database column name
                0 => 't.id',
                1 => 't.provider_name',
                2 => 't.currency',
                3 => 'exchange_rate',
                4 => 't.logo_image',
                5 => '',
            );
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
//        $orderBy = $filterColumn . " " . $filterOrder;
            $orderBy = 't.provider_name asc';
            $condition = '1=1 ';
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition .= " AND (t.provider_name LIKE '%" . $searchString . "%' )";
            }
            $count = $model->count(array('condition' => $condition));
            $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData = array();
            $i = 1;
            foreach ($model as $row) {
                $div = '';
                $div .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'provider/create&id=' . $row['id'] . '\',\'' . $row['provider_name'] . ' - Edit' . '\')"><i class="fa fa-edit"></i></button>';
                $div .= ' <button class="btn btn-primary btn-xs" title="Upload Commission" onclick="loadPopupModal(\'provider/uploadCommission&id=' . $row['id'] . '\',\'' . $row['provider_name'] . ' - Upload Commission' . '\')"><i class="fa fa-arrow-circle-up"></i></button>';
                $rowData[] = array($i, $row['provider_name'], $row['currency'], '<div class="text-right">' . $row['exchange_rate'] . '</div">', '<div class="text-center">' . CHtml::image(Yii::app()->baseUrl . "/uploads/provider/" . $row['logo_image'], "", array('style' => '')) . '</div>', '<div class="btn-wrap text-center">' . $div . '</div>');
                $i++;
            }

            $data['data'] = $rowData;
            echo json_encode($data);
        } else {
            $this->renderPartial('../index_error');
        }
    }

    /** For loading Provider Details End* */

    /** ---Create Provider */
    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Provider();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('jquery.js' => false, '*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }

    /** For Saving Provider Details* */
    public function actionSaveProvider() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (isset($_POST) && count($_POST) > 0) {
            $model = new Provider();
            if (isset($_POST['Provider'])) {
                if ($_POST['Provider']['id'] > 0) {
                    $id = $_POST['Provider']['id'];
                    $model = $model->findByPK($id);
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time = date('Y-m-d h:i:s');
                } else {
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time = date('Y-m-d h:i:s');
                }
                $model->attributes = $_POST['Provider'];
                $model->provider_name = strtoupper($_POST['Provider']['provider_name']);
                $model->is_active = 'Y';
                $valid = $model->validate();
                if ($valid) {
                    $model->save();
                    $jsonData['status'] = 'success';
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);
                } else {
                    $error2 = array();
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                    $error = CJSON::encode(array_merge_recursive($error1, $error2));
                    if ($error != '[]')
                        echo $error;
                }
            }
        } else {
            $this->renderPartial('../index_error');
        }
    }

    /** ---Create Upload ExcelFile */
    public function actionUploadCommission() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Provider();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $model_commission = new CommissionUploaded();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('upload_form', array('model' => $model, 'model_commission' => $model_commission));
    }

    //End Creat file
    //CSV read-start
    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }

    //CSV read-end
    //Save uploaded csv
    public function actionSaveUploadedFile() {
        $file_name = $_POST['CommissionUploaded']['uploaded_document_name'];
        $master_commission_file = $_POST['CommissionUploaded']['master_commission_file'];
        $url = Yii::app()->basePath . '/../uploads/providercommission/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/providercommission/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate = TRUE;
        $error_list = array();
        $policy_no_error = array();
        $model_commission = array();
        $statement_date = '';
        $provider_id = $_POST['CommissionUploaded']['provider_id'];
        $model_provider = Provider::model()->findByPk($provider_id);
        $commission_list = $this->readCSV("uploads/providercommission/" . $file_name);
        foreach (array_slice($commission_list, 1) as $i => $data) {
            if ($data[0] != '' || $data[1] != '' || $data[2] != '' || $data[3] != '' || $data[4] != '') {
                $model_commission[$i] = new CommissionUploaded();
                $model_commission[$i]->scenario = "excelupload";
                $model_commission[$i]->created_by = Yii::app()->user->id;
                $model_commission[$i]->created_date_time = date('Y-m-d H:i:s');
                $model_commission[$i]->uploaded_document_name = $file_name;
                $model_commission[$i]->provider_id = $_POST['CommissionUploaded']['provider_id'];
                $model_commission[$i]->provider_name = $_POST['CommissionUploaded']['provider_name'];
                if ($data[0] != '') {
                    $policy_no = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"'));
                    $model_commission[$i]->policy_no = $policy_no;
                    $model_plan_details = CustomerPlanDetails::model()->find(array('condition' => 'policy_no="' . $policy_no . '"'));
                    if (!empty($model_plan_details)) {
                        $model_commission[$i]->customer_plan_id = $model_plan_details->id;
                        $model_commission[$i]->customer_id = $model_plan_details->customer_id;
                        // $model_commission[$i]->customer_name =$model_plan_details->customer->Fullname;
                    }
                } else {
                    $model_commission[$i]->policy_no = 0;
                }
                $policy_no_error[$i] = $model_commission[$i]->policy_no;
                if ($data[1] != '') {
                    $model_commission[$i]->customer_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'));
                } else {
                    $model_commission[$i]->customer_name = '';
                }
                if ($data[2] != '') {
                    $base_currency_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[2]), '"'));
                    $model_commission[$i]->base_currency_amount = $base_currency_amount;
                    $com_amnt = $base_currency_amount * $model_provider->exchange_rate;
                    $model_commission[$i]->commission_amount = number_format($com_amnt, 6, '.', '');
                } else {
                    $model_commission[$i]->base_currency_amount = '';
                    $model_commission[$i]->commission_amount = '';
                }
                if ($data[3] != '') {
                    $model_commission[$i]->type = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"'));
                } else {
                    $model_commission[$i]->type = '';
                }
                if ($data[5] != '') {
                    $commission_date = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[5]), '"'));
                    if ($commission_date != '') {
                        if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $commission_date)) {
                            $statement_date = $commission_date;
                        }
                    }
                    $model_commission[$i]->commission_date = $commission_date;
                } else {
                    $model_commission[$i]->commission_date = '';
                }
                if ($data[6] != '') {
                    $model_commission[$i]->uploaded_icp = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[6]), '"'));
                } else {
                    $model_commission[$i]->uploaded_icp = '';
                }
                $model_commission[$i]->master_commission_file = $master_commission_file;
                $validate = $model_commission[$i]->validate() && $validate;
            }
        }

        function array_not_unique($raw_array) {
            $dupes = array();
            natcasesort($raw_array);
            reset($raw_array);

            $old_key = NULL;
            $old_value = NULL;
            foreach ($raw_array as $key => $value) {
                if ($value === NULL) {
                    continue;
                }
                if (strcasecmp($old_value, $value) === 0) {
                    $dupes[$old_key] = $old_value;
                    $dupes[$key] = $value;
                }
                $old_value = $value;
                $old_key = $key;
            }
            return $dupes;
        }

        //$policy_number_common = array_not_unique($policy_no_error);

        $model_commission_uploaded = CommissionUploaded::model()->find(array('condition' => 'commission_date="' . $statement_date . '" and provider_id="' . $provider_id . '"'));
        if (empty($model_commission_uploaded)) {
            if ($validate) {
                if (!empty($model_commission)) {
                    //Deletion Locking for Previous Entries-Start
                    CommissionUploaded::model()->updateAll(array('deletion_locked' => 'Y'), 'deletion_locked="N"');
                    //Deletion Locking for Previous Entries-End
                    foreach ($model_commission as $eachModel) {
                        $eachModel->save();
                        //$this->addtoCommissionLedger($eachModel->id);
                    }
                    $jsonData['error'] = "";
                    $jsonData['status'] = "success";
                }
            } else {
                if (!empty($model_commission)) {
                    foreach ($model_commission as $s => $data_model) {
                        $error_list[$s]['customer_plan_id'] = $data_model['customer_plan_id'];
                        $error_list[$s]['policy_no'] = $data_model['policy_no'];
                        $error_list[$s]['provider_id'] = $data_model['provider_id'];
                        $error_list[$s]['provider_name'] = $data_model['provider_name'];
                        $error_list[$s]['customer_id'] = $data_model['customer_id'];
                        $error_list[$s]['customer_name'] = $data_model['customer_name'];
                        $error_list[$s]['type'] = $data_model['type'];
                        $error_list[$s]['commission_amount'] = $data_model['base_currency_amount'];
                        $error_list[$s]['commission_date'] = $data_model['commission_date'];
                        $error_list[$s]['uploaded_icp'] = $data_model['uploaded_icp'];
                        $error_list[$s]['uploaded_document_name'] = $data_model['uploaded_document_name'];
                        $error_list[$s]['created_by'] = $data_model['created_by'];
                        $error_list[$s]['created_date_time'] = $data_model['created_date_time'];
                        if ($data_model->validate()) {
                            $error_list[$s]['remarks'] = "Correct";
                        } else {
                            $error_list[$s]['remarks'] = $data_model->getErrors();
                        }
                    }
                }
                $jsonData['status'] = "error";
            }
        } else {
            $jsonData['status'] = "uploaded";
        }
        $j = 0;
        fclose($file);
        $list = array();
        if (!empty($error_list)) {
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Policy No,Customer Name,Amount,Type,Provider,Date,ICP,Remarks';
            foreach ($error_list as $i => $error_detail) {
                if (!empty($error_detail)) {
                    if (!empty($error_detail['remarks'])) {
                        $error_view[$i] = '';
                        foreach ($error_detail['remarks'] as $p => $error_value) {
                            $error_view[$i] .= $error_value[0] . " / ";
                        }
                    } else {
                        $error_view[$i] .= '';
                    }
//                    if (in_array($error_detail['policy_no'], $policy_number_common)){
//                        $error_view[$i] .= " Policy No duplication in CSV /";
//                    }	else {
//                        $error_view[$i] .= '';
//                    }
                    $list[$j++] = $error_detail['policy_no'] . ',' . $error_detail['customer_name'] . ',' . $error_detail['commission_amount'] . ',' . $error_detail['type'] . ',' . $error_detail['provider_name'] . ',' . $error_detail['commission_date'] . ',' . $error_detail['uploaded_icp'] . ',' . $error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }
        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('provider/downloaderrorcsv', 'filename' => $file_name), array('target' => '_blank',
                    'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                    . ''
        ));
        echo CJSON::encode($jsonData);
    }

    public function actionDownloadErrorCsv() {
        $file_name = Yii::app()->request->getParam('filename');
        $error_url = Yii::app()->basePath . '/../uploads/providercommission/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }

    // public function actionDownloadformat() {
    //     $file = fopen("uploads/providercommission/uploadcsv/commission.csv", "w");
    //     $j = 1;
    //     $list[$j++] = 'Policy No,Customer Name,Amount,Type,Provider,Date,ICP';
    //     foreach ($list as $line) {
    //         fputcsv($file, explode(',', $line));
    //     }
    //     fclose($file);
    //     $filename = 'uploads/providercommission/uploadcsv/commission.csv';
    //     header('Content-Type: application/csv');
    //     header("Content-disposition: attachment; filename=\"commission.csv\"");
    //     readfile($filename);
    //     Yii::app()->end();
    //     return;
    // }
    public function actionDownloadformat() {
        $directory = "uploads/providercommission/uploadcsv/";
        if (!is_dir($directory)) {
            mkdir($directory, 0777, true); // Create the directory if it doesn't exist
        }
    
        $file = fopen($directory . "commission.csv", "w");
        if (!$file) {
            throw new CHttpException(500, "Unable to create the file.");
        }
    
        $j = 1;
        $list[$j++] = 'Policy No,Customer Name,Amount,Type,Provider,Date,ICP';
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
    
        $filename = $directory . 'commission.csv';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"commission.csv\"");
        readfile($filename);
        Yii::app()->end();
    }
    
    public function actionUploadCSV2($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // Check if directory exists or create it
        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

        // Define allowed extensions and size limit
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // 2MB

        // Handle file upload
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        
        $fileName = $result['filename']; //GETTING FILE NAME
        // Return JSON response
        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }

    public function actionUploadCSV($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }
        if (!is_writable($folder)) {
            throw new CHttpException(500, "Upload directory is not writable.");
        }
        // make the directory to store the pic:
        // if (!is_dir($folder)) {
        //     mkdir($folder, 0777, TRUE);
        //     //chmod($folder, 0755);
        // }
        $allowedExtensions = array("csv");
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $result['filename'] = "3624_" . $result['filename'];
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }
    
}
