<?php

class PaymentuploadController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('uploadpayment','Upload','Downloadformat','SaveUploadCsv','readCSVfile','DownloadErrorCsv','DownloadPaymentmaster',
                                        'defermentcalculation','savetoCommissionLedger'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionuploadpayment(){	 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_payment');
    }
    public function actionSaveUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');         
        $url = Yii::app()->basePath . '/../uploads/paymentdetails/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/paymentdetails/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $payment_list = Yii::app()->controller->readCSVfile("uploads/paymentdetails/" . $file_name);        
        foreach (array_slice($payment_list, 1) as $i => $data) {
            if($data[0]!=''||$data[1]!=''||$data[2]!=''||$data[3]!=''||$data[4]!=''||$data[5]!=''||$data[6]!=''||$data[7]!=''||$data[8]!='' ||$data[9]!='' ||$data[10]!=''){
            $model_payment[$i] = new CustomerPaymentDetails();
            $model_payment[$i]->scenario="excelupload";	
            $policy_number='';
            $id='';
            if($data[0]!=''){
                $policy_number= trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
            }
            $model_payment[$i]->policy_number =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));  
            $model_plan_details= CustomerPlanDetails::model()->find(array('condition'=>'policy_no="'.$policy_number.'"'));
            if(!empty($model_plan_details)){
                $model_payment[$i]->cus_plan_id=$model_plan_details->id;
                $model_payment[$i]->customer_id=$model_plan_details->customer_id;
                $model_payment[$i]->pay_term_id = $model_plan_details->payment_term;
            }else{
                $model_payment[$i]->customer_id='';
                $model_payment[$i]->cus_plan_id='';
            }
            if($data[1]!=''){
                $model_payment[$i]->payment_due_date =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));
                               
            }else{                    
                $model_payment[$i]->payment_due_date = '';
            }
            if($data[2]!=''){
                $model_payment[$i]->pay_date =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'));
                               
            }else{                    
                $model_payment[$i]->pay_date = '';
            }
            if($data[3]!=''){
                $payment_name =strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"')));
                $payment_type='';
                if($payment_name=='CHEQUE'){
                    $payment_type=1;
                }else if($payment_name=='CREDIT CARD'){
                    $payment_type=2;
                }else if($payment_name=='DIRECT PAYMENT'){
                    $payment_type=3;
                }else if($payment_name=='TELEGRAPHIC TRANSFER'){
                    $payment_type=4;
                }else if($payment_name=='STANDING ORDER'){
                    $payment_type=5;
                }        
                $model_payment[$i]->payment_type =$payment_type;               
            }else{                    
                $model_payment[$i]->payment_type = '';
            }
            $model_payment[$i]->paymentname =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"'));
            if($data[4]!=''){
                $model_payment[$i]->bank_name =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"'));
                               
            }else{                    
                $model_payment[$i]->bank_name = '';
            }
            if($data[5]!=''){
                $model_payment[$i]->ac_no =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[5]), '"'));                        
            }else{                    
                $model_payment[$i]->ac_no = '';
            }
            if($data[6]!=''){
                $model_payment[$i]->expiry_date =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[6]), '"'));                        
            }else{                    
                $model_payment[$i]->expiry_date = '';
            }
            if($data[7]!=''){
                $model_payment[$i]->installment_no =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[7]), '"'));
                               
            }else{                    
                $model_payment[$i]->installment_no = '';
            }
            if($data[8]!=''){
                $model_payment[$i]->pay_amount =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[8]), '"'));
                               
            }else{                    
                $model_payment[$i]->pay_amount = '';
            }
            if($data[9]!=''){
                $model_payment[$i]->realization_date =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[9]), '"'));
                               
            }else{                    
                $model_payment[$i]->realization_date = '';
            }
            if($data[10]!=''){
                $status_name =strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[10]), '"')));
                $status='';
                if($status_name=='COMPLETED'){
                    $status=1;
                }else if($status_name=='INPROCESS'){
                    $status=2;
                }else if($status_name=='CANCELLED'){
                    $status=3;
                }else if($status_name=='RETURNED'){
                    $status=4;
                }      
                $model_payment[$i]->status =$status;
                               
            }else{                    
                $model_payment[$i]->status = '';
            }         
            $model_payment[$i]->statusname =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[10]), '"'));
            $validate = $model_payment[$i]->validate() && $validate; 
            
            }
        }
               
        if ($validate){					
            if (!empty($model_payment)) {
                foreach ($model_payment as $s=>$eachModel) {  
                    $eachModel->save();
                    $model_customer_installment=CustomerPlanInstallments::model()->findAll(array('condition'=>'(status="N" OR status="H") AND cus_plan_id='.$eachModel->cus_plan_id.' AND installment_no IN ('.$eachModel->installment_no.')'));
                    if(!empty($model_customer_installment)){
                        foreach ($model_customer_installment as $each_inst){
                            if($eachModel->status ==2){
                                $status='H';
                                $date =$eachModel->pay_date;
                            }else if($eachModel->status ==1){
                                $status='P';                        
                                $date =$eachModel->realization_date;
                                if($each_inst->cusplandetail->icp_months>12){
                                //if($each_inst->cusplandetail->masplandetails->is_deferement_plan=='Y'){
                                    $this->defermentcalculation($each_inst->id,$eachModel->id);
                                }
                            }else if($eachModel->status == '3'){
                                $status='H';
                                $date =$eachModel->pay_date;
                            }else if($eachModel->status ==4){
                                $status='C';                        
                                $date =$eachModel->pay_date;
                                $modelPlanInstallment = new CustomerPlanInstallments();
                                $modelPlanInstallment->cus_plan_id=$each_inst->cus_plan_id;
                                $modelPlanInstallment->installment_no=$each_inst->installment_no;
                                $modelPlanInstallment->payment_term_id=$each_inst->payment_term_id;
                                $modelPlanInstallment->premium_amount=$each_inst->premium_amount;
                                $modelPlanInstallment->payment_due_date=$each_inst->payment_due_date;
                                $modelPlanInstallment->status='N';
                                $modelPlanInstallment->created_by=Yii::app()->user->id;
                                $modelPlanInstallment->created_date_time=date('Y-m-d H:i:s');
                                $modelPlanInstallment->save(false);
 
                            }
                            CustomerPlanInstallments::model()->updateByPk($each_inst->id, array('status' => $status,'cus_payment_id'=>$eachModel->id,'paid_date'=>$date));        
                        }
                    }
                }
                $jsonData['status'] = "success";
            }	
        } else {			
            if (!empty($model_payment)) {
                foreach ($model_payment as $s => $data_model) {
                    $error_list[$s]['policy_number'] =$data_model['policy_number'];
                    $error_list[$s]['payment_due_date'] =$data_model['payment_due_date'];
                    $error_list[$s]['pay_date'] =$data_model['pay_date'];
                    $error_list[$s]['paymentname']  =$data_model['paymentname'];
                    $error_list[$s]['bank_name']   =$data_model['bank_name'];
                    $error_list[$s]['ac_no']  =$data_model['ac_no'];
                    $error_list[$s]['expiry_date'] =$data_model['expiry_date'];
                    $error_list[$s]['installment_no']    =$data_model['installment_no'];
                    $error_list[$s]['pay_amount']      =$data_model['pay_amount'];
                    $error_list[$s]['realization_date']      =$data_model['realization_date'];
                    $error_list[$s]['statusname']      =$data_model['statusname'];
                    if($data_model->validate()){
                        $error_list[$s]['remarks']     ="correct";
                    }else{
                        $error_list[$s]['remarks']     =$data_model->getErrors();	
                    }
                }
            }	
            $jsonData['status'] = "error";            
	}				
              		 
	$j=0;
        fclose($file);        
        $list = array();        
        if(!empty($error_list)){
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Policy Number!Due Date!Payment Date!Payment Mode!Bank/Card Type!Cheque No/Card(4 dgts)/ A/c!Credit Card Expiry!Installment No!Amount!Realisation Date!Status!Remarks';
            foreach ($error_list as $i => $error_detail) {			
                if(!empty($error_detail)){
                    if(!empty($error_detail['remarks'])){
                            $error_view[$i] = '';
                        foreach($error_detail['remarks'] as $p => $error_value){						
                                $error_view[$i] .= $error_value[0]." / ";	

                        }
                    }else{
                        $error_view[$i] .= '';
                    }               
                    $list[$j++] = $error_detail['policy_number']. '!' .$error_detail['payment_due_date']. '!' .$error_detail['pay_date']. '!' .$error_detail['paymentname']. '!'.$error_detail['bank_name']. '!' .$error_detail['ac_no']. '!' .$error_detail['expiry_date']. '!' .$error_detail['installment_no']. '!' .$error_detail['pay_amount'] . '!' .$error_detail['realization_date'].'!' .$error_detail['statusname']. '!' .$error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode('!', $line));
            }
            fclose($file_error);
        }
		

        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('paymentupload/DownloadErrorCsv', 'file_name'=>$file_name), array('target' => '_blank',
            'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
            . ''
            ));
        echo CJSON::encode($jsonData);
    }
    public function actionDownloadErrorCsv() {
        $file_name =Yii::app()->request->getParam('file_name');
        $error_url = Yii::app()->basePath . '/../uploads/paymentdetails/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    public function actionDownloadformat() {
        $error_url = Yii::app()->basePath . '/../uploads/paymentdetails/paymentuploadformat.csv'; 
        return Yii::app()->getRequest()->sendFile('uploadformat.csv', @file_get_contents($error_url));
    }
    public function actionDownloadPaymentmaster() {
        $error_url = Yii::app()->basePath . '/../uploads/paymentdetails/paymentmode.pdf';
        return Yii::app()->getRequest()->sendFile('paymentmode.pdf', @file_get_contents($error_url));
    }
        ////savetoCommissionLedger-start
    public function defermentcalculation($installment_id,$cus_payment_id) {                       
        $model_installment              = CustomerPlanInstallments::model()->findByPk($installment_id);
        $model_cus_pay                  = CustomerPaymentDetails::model()->findByPk($cus_payment_id);
        $last_deferment_calculated_date = $model_installment->cusplandetail->last_deferment_date;
        $premium_due_date               = $model_installment->payment_due_date;
        $realization_date               = $model_cus_pay->realization_date;
        $ts1 = strtotime($last_deferment_calculated_date);
        $ts2 = strtotime($premium_due_date);
        $year1 = date('Y', $ts1);
        $year2 = date('Y', $ts2);
        $month1 = date('m', $ts1);
        $month2 = date('m', $ts2);
        $no_of_months_between = (($year2 - $year1) * 12) + ($month2 - $month1);
        $model_installment_pending=CustomerPlanInstallments::model()->findAll(array('condition'=>'payment_due_date>="'.$last_deferment_calculated_date.'" AND payment_due_date<="'.$premium_due_date.'" AND (status="N" OR status="H")'));
        if(empty($model_installment_pending)){
            if($no_of_months_between>12){
                $commission_model=CommissionLedger::model()->findAll(array('condition'=>'t.cus_plan_id='.$model_installment->cusplandetail->id.' AND (t.type= "EXE_DEF_COM" OR t.type="EXE_DEF_COM_RET") AND status="HOLD"','order'=>'t.id ASC'));
                $net_amount=0;
                $user_id=$model_installment->cusplandetail->customer->cust_executive_id;                    
                $provider_id=$model_installment->cusplandetail->provider_id;
                $customer_id=$model_installment->cusplandetail->customer_id;
                $mas_plan_id=  $model_installment->cusplandetail->plan_id;      
                if(!empty($commission_model)){
                    foreach($commission_model as $each){
                        if($each->in_or_out=='IN'){
                            $total_amount+=$each->total_amount;
                            $net_amount+=$each->in_amount;
                        }else{
                            $net_amount-=$each->out_amount;
                            $total_amount-=$each->total_amount;
                        }
                        CommissionLedger::model()->updateByPk($each->id,array('status'=>'USED'));
                    }
                    //write to commision ledger transfer from def account to gen acc
                    $scheme_id        = User::model()->findByPK($user_id)->commission_scheme_id;
                    $mas_commission   = MasterCommissionSchemes::model()->findByPK($scheme_id);
                    $percentage= $mas_commission->executive_commission_with_deferment;
                    $desc='Executive Deferment Commission  for Policy No.'.$model_installment->cusplandetail->policy_no.' Calculated Upto '.$premium_due_date.' ('.$percentage.' % of '.$total_amount.')';
                    $this->savetoCommissionLedger(0,$user_id,$model_installment->cusplandetail->id,$realization_date,$percentage,
                                                $total_amount,0,$net_amount,'EXE_DEF_COM',$desc,'OUT',
                                                'DEF',$provider_id,$customer_id,$mas_plan_id,'NA');
                    $this->savetoCommissionLedger(0,$user_id,$model_installment->cusplandetail->id,$realization_date,$percentage,
                                                $total_amount,$net_amount,0,'EXE_DEF_COM',$desc,'IN',
                                                'GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                    //update totals to executive
                    $model_exe= User::model()->findbyPK($user_id);
                    $account_balance=$model_exe->account_total_amount+$net_amount;
                    $account_defer=$model_exe->account_deferement_amount-$net_amount;
                    User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    //update totals to user company
                    $model_comp= User::model()->findbyPK(User::getCompany());
                    $account_defer=$model_comp->account_deferement_amount-$net_amount;
                    User::model()->updateByPK(User::getCompany(), array('account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                }
                CustomerPlanDetails::model()->updateByPk($model_installment->cusplandetail->id, array('last_deferment_date' => $premium_due_date));        

            }
        }   
        //return true;
    }
        ////savetoCommissionLedger-start
    public function savetoCommissionLedger($id,$user_id,$cus_plan_id,$transaction_date,$percentage,
                                            $total_amount,$in_amount,$out_amount,$type,$desc,$in_or_out,
                                            $user_account,$provider_id,$customer_id,$mas_plan_id,$status) {
        $model_ledger = new CommissionLedger();
        $model_ledger->commision_upload_id=$id;
        $model_ledger->user_id=$user_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$desc;
        $model_ledger->user_account=$user_account;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->status=$status;        
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        $model_ledger->save(false);     
        return true;
    }    
    //savetoCommissionLedger-end
}