<?php

class MailController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
     
    function sendmail($apply_from,$id) {
        date_default_timezone_set("Asia/Dubai");
        $subject="";
        $view="";
        //echo $apply_from.'  '.$id;die();
        //Mail Setting
        //$model_mail_setting=Notification::model()->find(array('condition' => 'event_id="'. $apply_from.'"'));       
        //$notifying_employee=$model_mail_setting->mail_users;
        $from='';
        $to='';
        $content='';
        $applicant_name='';
        $salutation='';
        $sent_mail_id=array();
        $mailContent = array();  
        //FactFind Reject
        if($apply_from==1){
            $model_fact=Activity::model()->findByPK($id);
            $subject='Rejection of Factfind';            
            $applicant_name='Excecutive';   
            $actual_date='';
            $to=$model_fact->customerdetails->executive->email;            
            if($model_fact->call_back_or_actual_date!='' && $model_fact->call_back_or_actual_date!='0000-00-00 00:00:00'){
                $call_back_or_actual_date=date("d/m/Y H:i",strtotime($model_fact->call_back_or_actual_date));
                $actual_date=date("Y-m-d",strtotime($model_fact->call_back_or_actual_date));;
            }
            $fact = explode(',', $model_fact->activity_notes);
            $array_fact=array();
            $i=0;
            $model_priority=CustomerPriorities::model()->find(array('condition' =>'start_date="'.$actual_date.'"'));
            foreach($fact as $fact_val) {
                $array_1=explode('-', $fact_val);        

                if($array_1[1]==1) {
                    $array_fact[$i]['priority']=$array_1[1];
                    $array_fact[$i]['type']=$array_1[0];
                    if($array_1[0]=='Family and Welfare'){
                        $array_fact[$i]['required']=$model_priority->fa_welfare_required;
                        $array_fact[$i]['current']=$model_priority->fa_welfare_cur_provision;
                        $array_fact[$i]['short']=$model_priority->fa_welfare_short_fall;
                    }
                    if($array_1[0]=='Children University Education'){
                        $array_fact[$i]['required']=$model_priority->ch_education_required;
                        $array_fact[$i]['current']=$model_priority->ch_education_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ch_education_short_fall;
                    }
                    if($array_1[0]=='Aspiration and Dreams'){
                        $array_fact[$i]['required']=$model_priority->asp_dream_required;
                        $array_fact[$i]['current']=$model_priority->asp_dream_cur_provision;
                        $array_fact[$i]['short']=$model_priority->asp_dream_short_fall;
                    }
                    if($array_1[0]=='Financial Freedom at Retirement'){
                        $array_fact[$i]['required']=$model_priority->ret_finance_required;
                        $array_fact[$i]['current']=$model_priority->ret_finance_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ret_finance_short_fall;
                    }
                    $i++;
                }
                if($array_1[1]==2) {
                    $array_fact[$i]['priority']=$array_1[1];
                    $array_fact[$i]['type']=$array_1[0];
                    if($array_1[0]=='Family and Welfare'){
                        $array_fact[$i]['required']=$model_priority->fa_welfare_required;
                        $array_fact[$i]['current']=$model_priority->fa_welfare_cur_provision;
                        $array_fact[$i]['short']=$model_priority->fa_welfare_short_fall;
                    }
                    if($array_1[0]=='Children University Education'){
                        $array_fact[$i]['required']=$model_priority->ch_education_required;
                        $array_fact[$i]['current']=$model_priority->ch_education_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ch_education_short_fall;
                    }
                    if($array_1[0]=='Aspiration and Dreams'){
                        $array_fact[$i]['required']=$model_priority->asp_dream_required;
                        $array_fact[$i]['current']=$model_priority->asp_dream_cur_provision;
                        $array_fact[$i]['short']=$model_priority->asp_dream_short_fall;
                    }
                    if($array_1[0]=='Financial Freedom at Retirement'){
                        $array_fact[$i]['required']=$model_priority->ret_finance_required;
                        $array_fact[$i]['current']=$model_priority->ret_finance_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ret_finance_short_fall;
                    }
                    $i++;
                }
                if($array_1[1]==3) {
                    $array_fact[$i]['priority']=$array_1[1];
                    $array_fact[$i]['type']=$array_1[0];
                    if($array_1[0]=='Family and Welfare'){
                        $array_fact[$i]['required']=$model_priority->fa_welfare_required;
                        $array_fact[$i]['current']=$model_priority->fa_welfare_cur_provision;
                        $array_fact[$i]['short']=$model_priority->fa_welfare_short_fall;
                    }
                    if($array_1[0]=='Children University Education'){
                        $array_fact[$i]['required']=$model_priority->ch_education_required;
                        $array_fact[$i]['current']=$model_priority->ch_education_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ch_education_short_fall;
                    }
                    if($array_1[0]=='Aspiration and Dreams'){
                        $array_fact[$i]['required']=$model_priority->asp_dream_required;
                        $array_fact[$i]['current']=$model_priority->asp_dream_cur_provision;
                        $array_fact[$i]['short']=$model_priority->asp_dream_short_fall;
                    }
                    if($array_1[0]=='Financial Freedom at Retirement'){
                        $array_fact[$i]['required']=$model_priority->ret_finance_required;
                        $array_fact[$i]['current']=$model_priority->ret_finance_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ret_finance_short_fall;
                    }
                    $i++;
                }
                if($array_1[1]==4) {
                    $array_fact[$i]['priority']=$array_1[1];
                    $array_fact[$i]['type']=$array_1[0];
                    if($array_1[0]=='Family and Welfare'){
                        $array_fact[$i]['required']=$model_priority->fa_welfare_required;
                        $array_fact[$i]['current']=$model_priority->fa_welfare_cur_provision;
                        $array_fact[$i]['short']=$model_priority->fa_welfare_short_fall;
                    }
                    if($array_1[0]=='Children University Education'){
                        $array_fact[$i]['required']=$model_priority->ch_education_required;
                        $array_fact[$i]['current']=$model_priority->ch_education_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ch_education_short_fall;
                    }
                    if($array_1[0]=='Aspiration and Dreams'){
                        $array_fact[$i]['required']=$model_priority->asp_dream_required;
                        $array_fact[$i]['current']=$model_priority->asp_dream_cur_provision;
                        $array_fact[$i]['short']=$model_priority->asp_dream_short_fall;
                    }
                    if($array_1[0]=='Financial Freedom at Retirement'){
                        $array_fact[$i]['required']=$model_priority->ret_finance_required;
                        $array_fact[$i]['current']=$model_priority->ret_finance_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ret_finance_short_fall;
                    }
                    $i++;
                }
                if($array_1[1]=='NA') {
                    $array_fact[$i]['priority']=$array_1[1];
                    $array_fact[$i]['type']=$array_1[0];
                    if($array_1[0]=='Family and Welfare'){
                        $array_fact[$i]['required']=$model_priority->fa_welfare_required;
                        $array_fact[$i]['current']=$model_priority->fa_welfare_cur_provision;
                        $array_fact[$i]['short']=$model_priority->fa_welfare_short_fall;
                    }
                    if($array_1[0]=='Children University Education'){
                        $array_fact[$i]['required']=$model_priority->ch_education_required;
                        $array_fact[$i]['current']=$model_priority->ch_education_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ch_education_short_fall;
                    }
                    if($array_1[0]=='Aspiration and Dreams'){
                        $array_fact[$i]['required']=$model_priority->asp_dream_required;
                        $array_fact[$i]['current']=$model_priority->asp_dream_cur_provision;
                        $array_fact[$i]['short']=$model_priority->asp_dream_short_fall;
                    }
                    if($array_1[0]=='Financial Freedom at Retirement'){
                        $array_fact[$i]['required']=$model_priority->ret_finance_required;
                        $array_fact[$i]['current']=$model_priority->ret_finance_cur_provision;
                        $array_fact[$i]['short']=$model_priority->ret_finance_short_fall;
                    }
                    $i++;
                }

            }
            sort($array_fact); 
            $content='
                Your request for factfind approval has been rejected.Details as follows:<br>
                 <br><b>Customer</b>: '.$model_fact->customerdetails->Fullname. '
                 <br><b>Reject Date</b>: '.$call_back_or_actual_date.'
                 <br><b>Rejection Reason</b>: '.nl2br($model_fact->fact_find_note).'
                 <br><br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                    <thead class="table_header_o">
                        <tr>
                            <th style="border: 1px solid #666;padding: 4px 5px;">Priority Value</th>
                            <th style="border: 1px solid #666;padding: 4px 5px;">Priority Type</th>
                            <th style="border: 1px solid #666;padding: 4px 5px;">Required</th>
                            <th style="border: 1px solid #666;padding: 4px 5px;">Current</th>
                            <th style="border: 1px solid #666;padding: 4px 5px;">Short Closure</th>
                        </tr>
                    </thead>';
                foreach ($array_fact as $key => $value) {
                    $content.='<tr>
                        <td style="border: 1px solid #666;padding: 4px 5px; text-align:center;">'. $value['priority'].'</td>
                        <td style="border: 1px solid #666;padding: 4px 5px; text-align:center;">'.$value['type'].'</td>
                        <td style="border: 1px solid #666;padding: 4px 5px; text-align:center;">'.$value['required'].'</td>
                        <td style="border: 1px solid #666;padding: 4px 5px; text-align:center;">'.$value['current'].'</td>
                        <td style="border: 1px solid #666;padding: 4px 5px; text-align:center;">'.$value['short'].'</td>
                    </tr>';
                        
                    }
                $content.='</table>';
            $view='send_notification';
            $salutation='Dear '.$model_fact->customerdetails->executive->fullname;
            ////Customer Add End
        }
        //start Mail Content
        $mailContent['body'] = '
            <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">
                <tbody>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <div>'.$salutation.',</div>                                              
                        </td>
                    </tr>                                      
                    <tr>
                        <td height="20"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <strong style="font-size: 15px">Subject: '.$subject.'</strong>
                        </td>
                    </tr>
                    <tr>
                        <td height="20"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">'                          
                            .$content.'<br>                       
                            <br>
                            This mail has been sent automatically from Gargash Insurance Team on '.date('d/m/Y H:i').'
                        </td>
                    </tr>
                    <tr style="vertical-align: top"><td></td><td></td></tr>
                </tbody>
            </table>';
        ////End Mail Content
        $message = new YiiMailMessage;        
        $message->view = $view;
        $message->setBody(array('mailContent' => $mailContent), 'text/html');
        $message->subject =$subject;      
        //Mail From Start       
        $message->from ='dikson@mailbluesky.com';
        //End Mail From
        //Mail To Start       
        $message->addTo($to);
        $message->addCC('jishajacob11@gmail.com');
        $message->addCC('dksnrajan@gmail.com');
        //End Mail To                 
        if (filter_var($to, FILTER_VALIDATE_EMAIL)) {
            Yii::app()->mail->send($message); 
        }    
        //Saving Mail Status
        return 'mailsuccess';
    }
}
