<?php

class LeadactivityController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Create','saveCalls','GetActivityList','saveAppointment','loadactivityPage','Deleteactivitydetails'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionCreate() {
        $customer_id= (int) Yii::app()->request->getParam('customer_id');
        $model_lead_customer = LeadCustomer::model()->findbypk($customer_id);
        //Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        Yii::app()->clientScript->scriptMap = array('jquery.js' => false, 'jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('activity_form',array('customer_id'=>$customer_id,'model_lead_customer'=>$model_lead_customer));
    }
    //Code to save calls-start
    public function actionsaveCalls() {
        if (isset($_POST['Activity'])) {
            $model = new Activity();
            if ((int) @$_POST['Activity']['id'] > 0) {
                $model->id = (int) $_POST['Activity']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['Activity'];
            if ($_POST['Activity']['call_date'] != '0000-00-00' && $_POST['Activity']['call_date'] != '' && $_POST['Activity']['call_time'] != '00:00:00' && $_POST['Activity']['call_time'] != '') {
                $call_date=$_POST['Activity']['call_date'].' '.$_POST['Activity']['call_time'];
                $call_date=str_replace('/', '-',$call_date);
                $call_date=date("Y-m-d H:i:s", strtotime($call_date)); 
                $model->call_or_plan_date_time = $call_date;
            }
            if ($_POST['Activity']['callback_date'] != '0000-00-00' && $_POST['Activity']['callback_date'] != '' && $_POST['Activity']['callback_time'] != '00:00:00' && $_POST['Activity']['callback_time'] != '') {
                $callback_date=$_POST['Activity']['callback_date'].' '.$_POST['Activity']['callback_time'];
                $callback_date=str_replace('/', '-',$callback_date);
                $callback_date=date("Y-m-d H:i:s", strtotime($callback_date));
                $model->call_back_or_actual_date = $callback_date;
            }
             $model->activity_notes = $_POST['Activity']['activity_notes'];   
            if ($model->validate()) {
                $model->save();
                $jsonData['customer_id'] =$model->lead_customer_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    //Code to save calls-ends
    //Start Activity List
    public function actionGetActivityList(){
        $model=new Activity();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $id= $_POST['id'];
        $customer_id= $_POST['customer_id'];
        $type= $_POST['type'];
        $columns = array(
            0 =>'id',
            1 =>'type_of_activity',
            2 =>'call_or_plan_date_time',
            3 =>'call_back_or_actual_date',
            4 =>'activity_notes',
            5=>'created_by',
            6=>'created_datetime',
            7=>'',
            8=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   ='call_or_plan_date_time desc';
        $condition = "lead_customer_id='".$customer_id."'"; 
        if($type>0){
            $condition.= ' AND type_of_activity="'.$type.'"';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" AND (activity_notes LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;        
        foreach ($model as $row)
        {
            $button_string=""; 
            $call_or_plan_date_time="-";
            $call_back_or_actual_date="-";
            $created_datetime="";
                if($row['call_or_plan_date_time']!='' && $row['call_or_plan_date_time']!='0000-00-00 00:00:00'){
                $call_or_plan_date_time=date("d/m/Y H:i",strtotime($row['call_or_plan_date_time']));
                }
                if($row['type_of_activity']!=1){
                    if($row['call_back_or_actual_date']!='' && $row['call_back_or_actual_date']!='0000-00-00 00:00:00'){
                        $call_back_or_actual_date=date("d/m/Y H:i",strtotime($row['call_back_or_actual_date']));
                    }
                }
                if($row['created_datetime']!='' && $row['created_datetime']!='0000-00-00 00:00:00'){
                    $created_datetime=date("d/m/Y H:i",strtotime($row['created_datetime']));
                }
                if ($row['type_of_activity']==2) {
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="editactivitydetails(' . $row['type_of_activity'] . ',' . $row['id'] . ');"><i class="fa fa-edit"></i></button>&nbsp;';       
                }
                if($row['isActive']=='Y'){
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Delete" onclick="deleteactivitydetails(' . $row['id']. ');"><i class="fa fa-trash"></i></button>&nbsp;';       
                }
            $rowData[]=array($m,Activity::gettype($row['type_of_activity']),$call_or_plan_date_time,$call_back_or_actual_date,$row['activity_notes'],$row->addedby->fullname,$created_datetime,$button_string,$row['isActive']);
            $m++;
        }
            
        
        $data['data'] = $rowData;
        echo json_encode($data);
    }
     //End Activity List
    //Code to save Appointment details-Start
    public function actionsaveAppointment() {
        if (isset($_POST['Activity'])) {
            $model = new Activity();
            if ((int) @$_POST['Activity']['id'] > 0) {
                $model->id = (int) $_POST['Activity']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['Activity'];
            if ($_POST['Activity']['plan_date'] != '0000-00-00' && $_POST['Activity']['plan_date'] != '' && $_POST['Activity']['plan_time'] != '00:00:00' && $_POST['Activity']['plan_time'] != '') {
                $plan_date=$_POST['Activity']['plan_date'].' '.$_POST['Activity']['plan_time'];
                $plan_date=str_replace('/', '-',$plan_date);
                $plan_date=date("Y-m-d H:i:s", strtotime($plan_date)); 
                $model->call_or_plan_date_time = $plan_date;
            }
            if ($_POST['Activity']['actual_date'] != '0000-00-00' && $_POST['Activity']['actual_date'] != '' && $_POST['Activity']['actual_time'] != '00:00:00' && $_POST['Activity']['actual_time'] != '') {
                $actual_date=$_POST['Activity']['actual_date'].' '.$_POST['Activity']['actual_time'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
            }
            $model->duration = $_POST['Activity']['duration'];
            $model->activity_notes = $_POST['Activity']['activity_notes'];   
            if ($model->validate()) {
                $model->save();
                $jsonData['customer_id'] =$model->lead_customer_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    //Code to save Appointment details-End
    //Edit Page Showing-Starts
    public function actionloadactivityPage() {
        $frm = Yii::app()->request->getparam("frm");
        $id= Yii::app()->request->getparam("id");
        $model=new Activity();
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('activity_appointment', array('model' => $model,'frm'=>$frm));
                 
    }
    //Edit Page Showing-Ends
    public function actionDeleteactivitydetails() {
        $id= Yii::app()->request->getparam("id");
        Activity::model()->updateByPk($id, array('isActive' =>'N'));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
               
    }

}