<?php

class GooglecalenderController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Savelogin', 'index', 'Send'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionSavelogin() {
        $code = $_GET['code'];
        $user_id = Yii::app()->user->id;
        $model = GoogleToken::model()->find("t.user_id = " . $user_id);
        if ($model == null) {
            $model = new GoogleToken();
            $model->user_id = $user_id;
        }
        $model->_token = $code;
        $model->save();
        $this->render('savelogin');
    }

    public function actionSend() {
        $model = GoogleToken::model()->findByPk('1');
        $access_token = $model->_token;
        $url_settings = 'https://www.googleapis.com/calendar/v3/users/me/settings/timezone';

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url_settings);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer '. $access_token));
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		$data = json_decode(curl_exec($ch), true); //echo '<pre>';print_r($data);echo '</pre>';
		$http_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
                //echo $data['value'];
        $this->render('done', array('data' => $data,'code' => $http_code,'access_token'=>$access_token));
    }

    /*     * * START Google Calender***

      public function GetAccessToken($client_id, $redirect_uri, $client_secret, $code) {
      $model = GoogleApi::model()->findByPk('1');
      $url = 'https://accounts.google.com/o/oauth2/token';

      $curlPost = 'client_id=' . $model->client_id . '&redirect_uri=' . $model->redirect_url . '&client_secret=' . $model->client_secret . '&code=' . $code . '&grant_type=authorization_code';
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
      $data = json_decode(curl_exec($ch), true);
      $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
      if ($http_code != 200)
      throw new Exception('Error : Failed to receieve access token');

      return $data;
      }

      public function GetUserCalendarTimezone($access_token) {
      $url_settings = 'https://www.googleapis.com/calendar/v3/users/me/settings/timezone';

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url_settings);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer ' . $access_token));
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
      $data = json_decode(curl_exec($ch), true); //echo '<pre>';print_r($data);echo '</pre>';
      $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
      if ($http_code != 200)
      throw new Exception('Error : Failed to get timezone');

      return $data['value'];
      }

      public function GetCalendarsList($access_token) {
      $url_parameters = array();

      $url_parameters['fields'] = 'items(id,summary,timeZone)';
      $url_parameters['minAccessRole'] = 'owner';

      $url_calendars = 'https://www.googleapis.com/calendar/v3/users/me/calendarList?' . http_build_query($url_parameters);

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url_calendars);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer ' . $access_token));
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
      $data = json_decode(curl_exec($ch), true); //echo '<pre>';print_r($data);echo '</pre>';
      $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
      if ($http_code != 200)
      throw new Exception('Error : Failed to get calendars list');

      return $data['items'];
      }

      public function CreateCalendarEvent($calendar_id, $summary, $all_day, $event_time, $event_timezone, $access_token) {
      $url_events = 'https://www.googleapis.com/calendar/v3/calendars/' . $calendar_id . '/events';

      $curlPost = array('summary' => $summary);
      if ($all_day == 1) {
      $curlPost['start'] = array('date' => $event_time['event_date']);
      $curlPost['end'] = array('date' => $event_time['event_date']);
      } else {
      $curlPost['start'] = array('dateTime' => $event_time['start_time'], 'timeZone' => $event_timezone);
      $curlPost['end'] = array('dateTime' => $event_time['end_time'], 'timeZone' => $event_timezone);
      }
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url_events);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer ' . $access_token, 'Content-Type: application/json'));
      curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($curlPost));
      $data = json_decode(curl_exec($ch), true);
      $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
      if ($http_code != 200)
      throw new Exception('Error : Failed to create event');

      return $data['id'];
      }

      public function actionSavelogin() {
      try {
      // Get event details
      $event = $_POST['event_details'];



      // Get user calendar timezone
      $user_timezone = $this->GetUserCalendarTimezone($_SESSION['access_token']);

      // Create event on primary calendar
      $event_id = $this->CreateCalendarEvent('primary', $event['title'], $event['all_day'], $event['event_time'], $user_timezone, $_SESSION['access_token']);

      echo json_encode([ 'event_id' => $event_id]);
      } catch (Exception $e) {
      header('Bad Request', true, 400);
      echo json_encode(array('error' => 1, 'message' => $e->getMessage()));
      }
      }

      /*     * * END Google Calender*** */
}
