<?php

class AppController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'index','saveCustomerDetails','getCountry','getEmirates','getCountrybycode','getCustomerlist','getCustomerlistbyid',
                'Savecallactivity','getManagerlist','Savevisitactivity','Saveappointments','getActivityhistory','Savefactfind','Savepresentation','Saveapplication','Savereview','getDocumentaddedlist','getDocumentlist',
                'getPlandetails','getbirthdaylist','getanniversary','getfollowup','getfollowupbydate','SaveCustomerPriorities','Savedependants','UpdateCustomerDetails','Saveleads','getLeads','getLeadsbyid','SaveLeadscallactivity','SaveLeadsappointment',
                'getLeadsActivityhistory','getDependantslist','getPrioritylistbydate','getDatelistbyid','getHealthStatus','GetProspectSource','getFitness','getFitnessAndProspectSource','getMasters','Updateappointments','Updatevisitactivity','getActivityappointment',
                'getActivityjointvisit','SaveCrossSales','getCrossSales','getInsurance','GetTargetFactFindDetails','GetTargetAppointmentDetails','GetTargetPolicyDetails','SendMail','GetCustomerPlanDetails','LeedToContact', 'testmail'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetProspectSource',
                    'CustomerPrioritiesDate', 'GetProvider', 'SaveCustomer',
                    'Plans', 'getClass', 'getSubClass','getEmirates','getCountrybycode', 'getSendMethod',
                    'SaveSendInfo', 'getCountry', 'SaveDependant','saveplandetails','SaveLeadsappointment',
                    'SavePaymentdetails', 'getHealthStatus','SaveUser', 'saveCustomerDetails','getCustomerlist','getCustomerlistbyid','Savecallactivity','getManagerlist','Savevisitactivity',
                    'Saveappointments','getActivityhistory','Savefactfind','Savepresentation','Saveapplication','Savereview','getDocumentaddedlist','getDocumentlist','getPlandetails','getbirthdaylist',
                    'getanniversary','getfollowup','getfollowupbydate','SaveCustomerPriorities','Savedependants','UpdateCustomerDetails','Saveleads','getLeads','getLeadsbyid','SaveLeadscallactivity','getLeadsActivityhistory',
                    'getDependantslist','getPrioritylistbydate','getDatelistbyid','getFitness','getFitnessAndProspectSource','getMasters','Updateappointments','Updatevisitactivity','getActivityappointment','getActivityjointvisit',
                    'SaveCrossSales','getCrossSales','getInsurance','GetTargetFactFindDetails','GetTargetAppointmentDetails','GetTargetPolicyDetails','SendMail','GetCustomerPlanDetails','LeedToContact'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    
  /*  public function beforeAction($action)
    {
        // your custom code here, if you want the code to run before action filters,
        // which are triggered on the [[EVENT_BEFORE_ACTION]] event, e.g. PageCache or AccessControl
    
        if (!parent::beforeAction($action)) {
            return false;
        }
    
        // other custom code here
        
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=life.gargashinsurance.com;dbname=' . trim('glife');
        Yii::app()->db->username = 'root';
        Yii::app()->db->password = 'root';
        Yii::app()->db->tablePrefix = 'crm_';
        Yii::app()->db->setActive(true);
    
        return true; // or false to not run the action
    } */
    
     public function validateToken($token){
        //Token
        //$token = $_SERVER['HTTP_TOKEN'];
        $_token = 'insurancegr';
        if( trim($token) == $_token )
            return true;
        else
            return false;
    }
    
        public function Statusupdate($updated_status){
        //Token
        //$token = $_SERVER['HTTP_TOKEN'];
        $user_id = $_SERVER['HTTP_USER_ID'];
       $models = User::model()->findAll(array('condition'=>'id='.$user_id));
        $status = $models[0]['app_update_user_status'];
        if( trim($updated_status) == $status )
            return true;
        else
            return false;
    }

    public function Validate() {
        return true;
    }

    public function actionindex() {
        if ($this->Validate()) {
            echo json_encode(array('status' => 'ok'));
        }
    }

    public function actionGetProspectSource() {
        $param = array(1 => 'Referral',
            2 => 'Network',
            3 => 'Website',
            4 => 'Advertisement');
        echo json_encode($param);
    }

    public function actionCustomerPrioritiesDate() {
        $input = file_get_contents('php://input'); //

        $datas = json_decode($input, true);
        $condition = 'customer_id =  "' . $datas['customer_id'] . '"';
        $models = CustomerPriorities::model()->findAll($condition);
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'dateinformat' => $value->dateinformat
            );
        }
        echo json_encode($data);
    }

    public function actionSaveCustomer() {
        $input = file_get_contents('php://input'); //

        $datas = json_decode($input, true);
        $model = new Customer();
        $modelPriorities = new CustomerPriorities();

        if (isset($datas['Customer'])) {
            if ($datas['Customer']['id'] > 0) {
                $id = $datas['Customer']['id'];
                $model = $model->findByPK($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $scene = 'update';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->cust_locked_date = date('Y-m-d', strtotime('+90 days', strtotime(date('Y-m-d'))));
                $scene = 'new';
            }

            $model->attributes = $datas['Customer'];
            if ($datas['Customer']['mobile_number'] != '') {
                $model->cust_mobile1 = $datas['Customer']['mobile_code'] . '' . $datas['Customer']['mobile_number'];
            }
            if ($datas['Customer']['cust_date_of_birth'] != '') {
                $model->cust_date_of_birth = str_replace('/', '-', $datas['Customer']['cust_date_of_birth']);
                $model->cust_date_of_birth = date("Y-m-d", strtotime($model->cust_date_of_birth));
            }

            if (isset($datas['Customer']['cust_spouse_date_of_birth']) && $datas['Customer']['cust_spouse_date_of_birth'] != '') {
                $model->cust_spouse_date_of_birth = str_replace('/', '-', $datas['Customer']['cust_spouse_date_of_birth']);
                $model->cust_spouse_date_of_birth = date("Y-m-d", strtotime($model->cust_spouse_date_of_birth));
            }
            $valid = $model->validate();
            if ($datas['CustomerPriorities']['id'] > 0) {
                $modelPriorities = $modelPriorities->findByPK($datas['CustomerPriorities']['id']);
                $modelPriorities->updated_by = Yii::app()->user->id;
                $modelPriorities->updated_date_time = date('Y-m-d h:i:s');
                $welfare = $modelPriorities->fa_welfare_priority;
                $education = $modelPriorities->ch_education_priority;
                $dream = $modelPriorities->asp_dream_priority;
                $finance = $modelPriorities->ret_finance_priority;
                $new_welfare = $datas['CustomerPriorities']['fa_welfare_priority'];
                $new_education = $datas['CustomerPriorities']['ch_education_priority'];
                $new_dream = $datas['CustomerPriorities']['asp_dream_priority'];
                $new_finance = $datas['CustomerPriorities']['ret_finance_priority'];
                if (($new_welfare > 0 && $new_education > 0 && $new_dream > 0 && $new_finance > 0) && ($welfare != $new_welfare || $education != $new_education || $dream != $new_dream || $finance != $new_finance)) {
                    $modelPriorities->end_date = date('Y-m-d', strtotime('-1 days', strtotime(date('Y-m-d'))));
                    $modelPriorities->isActive = 'N';
                    $modelPriorities->save();
                    $modelPriorities = new CustomerPriorities();
                    $modelPriorities->created_by = Yii::app()->user->id;
                    $modelPriorities->created_date_time = date('Y-m-d H:i:s');
                    $modelPriorities->start_date = date('Y-m-d');
                }
            } else {
                $modelPriorities->created_by = Yii::app()->user->id;
                $modelPriorities->created_date_time = date('Y-m-d H:i:s');
                $modelPriorities->start_date = date('Y-m-d');
            }
            $modelPriorities->attributes = $datas['CustomerPriorities'];
            $valid = $valid && $modelPriorities->validate();
            if ($valid) {
                $model->save();
                //Updating lead details when coming from lead-Start
                $lead_id = $datas['lead_id'];
                if ($lead_id > 0) {
                    LeadCustomer::model()->updateByPK($lead_id, array('lead_conversion_date' => date('Y-m-d')));
                }
                //End
                $modelPriorities->customer_id = $model->id;
                $modelPriorities->save();
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                $jsonData['first_name'] = $model->cust_first_name;
                $jsonData['middle_name'] = $model->cust_middle_name;
                $jsonData['last_name'] = $model->cust_last_name;

                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($modelPriorities, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));

                /* $error2 = json_decode(CActiveForm::validateTabular($modelcontact, '', false), true);
                  $error3 = json_decode(CActiveForm::validateTabular($modelshipping, '', false), true);
                  $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3)); */
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetProvider() {
        $models = Provider::model()->findAll(' 1 = 1 ');
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'provider_name' => $value->provider_name,
                'iris_main' => $value->iris_main,
                'iris_sub' => $value->iris_sub,
                'department' => $value->department,
                'division' => $value->division,
                'logo_image' => "https://blueskyerp.me/insurance/uploads/provider/" . $value->logo_image
            );
        }
        echo json_encode($data);
    }

    public function actionPlans() {
        $models = MasProviderPlans::model()->findAll(' 1 = 1 ');
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'plan_name' => $value->plan_name,
                'general_vat' => $value->general_vat,
                'icp_months' => $value->icp_months,
                'provider_id' => $value->provider_id,
                'provider' => $value->provider->provider_name,
            );
        }
        echo json_encode($data);
    }

    public function actiongetClass() {
        $models = MasClass::model()->findAll(' 1 = 1 ');
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'class_name' => $value->class_name,
            );
        }
        echo json_encode($data);
    }

    public function actiongetSubClass() {
        $models = MasSubClass::model()->findAll(' 1 = 1 ');
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'class_name' => $value->subclass_name,
            );
        }
        echo json_encode($data);
    }

    public function actiongetSendMethod() {
        $models = MasSendMethods::model()->findAll(' 1 = 1 ');
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'sending_method' => $value->sending_method,
            );
        }
        echo json_encode($data);
    }

    public function actionSaveSendInfo() {
        $input = file_get_contents('php://input'); //

        $datas = json_decode($input, true);
        date_default_timezone_set("Asia/Dubai");
        $model = new ProviderSendReceiveInfo();

        if ($datas['id'] > 0) {
            $id = $datas['id'];
            $model = $model->findByPK($id);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
        } else {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
        }
        $model->attributes = $datas;
        if ($datas['send_or_receive_date_time'] != '') {
            $model->send_or_receive_date_time = str_replace('/', '-', $datas['send_or_receive_date_time']);
            $model->send_or_receive_date_time = date("Y-m-d h:i:s", strtotime($model->send_or_receive_date_time));
        }
        if ($datas['expected_date_time'] != '') {
            $model->expected_date_time = str_replace('/', '-', $datas['expected_date_time']);
            $model->expected_date_time = date("Y-m-d h:i:s", strtotime($model->expected_date_time));
        }
        $valid = $model->validate();
        if ($valid) {
            $model->save();
            $jsonData['status'] = 'success';
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);
        } else {
            $error2 = array();
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error1, $error2));
            if ($error != '[]')
                echo $error;
        }
    }

    public function actiongetCountry() {
        $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];
$updated_status = N;
      // $id=$_GET['id'];
    //  echo $updated_status;  
         if( $this->validateToken($token) ){
             
             if($this->Statusupdate($updated_status)){
            
        $models = MasCountry::model()->findAll(' 1 = 1 ');
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'country_name' => $value->country_name,
                'country_code' => $value->country_code,
                'phone_code' => $value->phone_code,
                'show_country_list' => $value->show_country_list,
              
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
         }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    public function actiongetCountrybycode() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];
$updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        $models = MasCountry::model()->findAll(array('condition'=>'show_country_list="Y"'));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'country_name' => $value->country_name,
                //'country_code' => $value->country_code,
                'phone_code' => $value->phone_code,
                'show_country_list' => $value->show_country_list,
                 'number_digit'=> $value->number_digit,
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
     public function actiongetEmirates() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];
$updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
if($this->Statusupdate($updated_status)){
        $models = MasEmirates::model()->findAll(' 1 = 1 ');
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'emirate_name' => $value->emirate_name,
                'country_id' => $value->country_id,
                
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
}else{
            echo $this->getResponse(800);
        }
     }
      else{
            echo $this->getResponse(301);
        }
        
    }

    public function actionSaveDependant() {
        $input = file_get_contents('php://input'); //

        $datas = json_decode($input, true);
        $modelDependants = new CustomerDependants();

        $customer_id = $datas['customer_id'];
        $dependant_name = $datas['dependant_name'];
        $relationship = $datas['relationship'];
        $date_of_birth = $datas['dependant_date_of_birth'];
        $id = $datas['id'];
        if ($id > 0) {
            $modelDependants = $modelDependants->findByPk($id);
        }
        $modelDependants->customer_id = $customer_id;
        $modelDependants->dependant_name = $dependant_name;
        $modelDependants->relationship = $relationship;
        $modelDependants->dependant_date_of_birth = $date_of_birth;
        $modelDependants->attributes = $modelDependants;

        if ($date_of_birth != '') {
            $modelDependants->dependant_date_of_birth = str_replace('/', '-', $date_of_birth);
            $modelDependants->dependant_date_of_birth = date("Y-m-d", strtotime($modelDependants->dependant_date_of_birth));
        }

        $valid = $modelDependants->validate();

        if ($valid) {

            $modelDependants->save();
            $jsonData['status'] = 'success';
            $jsonData['id'] = $modelDependants->id;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($modelDependants, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }
    public function actionSaveplandetails(){
        
              $input = file_get_contents('php://input'); //

        $datas = json_decode($input, true);
        $modelPlanDetails = new CustomerPlanDetails();

        $id = $datas['id'];
        $customer_id = $datas['customer_id'];
        $provider_id = $datas['provider_id'];
        $plan_id = $datas['plan_id'];
        $amount = $datas['amount'];
        $payment_term_id = $datas['payment_term_id'];
        $annualized_premium = $datas['annualized_premium'];
        $tennure = $datas['tennure'];
        $start_date = $datas['start_date'];
        $class_ids = $datas['class_ids'];
        $subclass_ids = $datas['subclass_ids'];
        $policy_no = $datas['policy_no'];

        if ($id > 0) {
            $modelPlanDetails = $modelPlanDetails->findByPk($id);
        }
        $modelPlanDetails->customer_id = $customer_id;
        $modelPlanDetails->provider_id = $provider_id;
        $modelPlanDetails->plan_id = $plan_id;
        $modelPlanDetails->amount = $amount;
        $modelPlanDetails->payment_term = $payment_term_id;
        $modelPlanDetails->annualized_premium = $annualized_premium;
        $modelPlanDetails->tennure = $tennure;
        $modelPlanDetails->start_date = $start_date;
        $modelPlanDetails->class_ids = $class_ids;
        $modelPlanDetails->policy_no = $policy_no;
        $modelPlanDetails->subclass_ids = $subclass_ids;
        if ($start_date != '') {
            $modelPlanDetails->start_date = str_replace('/', '-', $start_date);
            $modelPlanDetails->start_date = date("Y-m-d", strtotime($modelPlanDetails->start_date));
        }
        $modelPlanDetails->attributes = $modelPlanDetails;

        $valid = $modelPlanDetails->validate();

        if ($valid) {
            $modelPlanDetails->save();
            Customer::model()->updateByPk($customer_id, array('cust_policy_taken' => "Y"));
            $jsonData['status'] = 'success';
            $jsonData['id'] = $modelPlanDetails->id;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($modelPlanDetails, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }
      public function actionSavePaymentdetails() {
           $input = file_get_contents('php://input'); //

        $datas = json_decode($input, true);
        date_default_timezone_set("Asia/Dubai");
        $modelPayDetails = new CustomerPaymentDetails();

        $id = $datas['id'];
        $customer_id = $datas['customer_id'];
        $status = $datas['status'];
        $plan_id = $datas['plan_id'];
        $amount = $datas['amount'];
        $payment_type = $datas['payment_type'];
        $bank_name   = $datas['bank_name'];
        $ac_no = $datas['ac_no'];
        $installment_no = $datas['installment_no'];
        $pay_date = $datas['pay_date'];
        $real_date= $datas['real_date'];

        if ($id > 0) {
            $modelPayDetails = $modelPayDetails->findByPk($id);
            $modelPayDetails->updated_by = Yii::app()->user->id;
            $modelPayDetails->updated_date_time = date('Y-m-d H:i:s');
            $modelPayDetails->status = $status;

        }else{
            $modelPayDetails->status = '2';
            $modelPayDetails->created_by = Yii::app()->user->id;
            $modelPayDetails->created_date_time = date('Y-m-d H:i:s');
        }
        $modelPayDetails->customer_id = $customer_id;
        $modelPayDetails->cus_plan_id = $plan_id;
        $modelPayDetails->pay_amount = $amount;
        $modelPayDetails->payment_type = $payment_type;
        $modelPayDetails->bank_name = $bank_name;
        $modelPayDetails->installment_no = $installment_no;
        $modelPayDetails->pay_date = $pay_date;
        $modelPayDetails->ac_no = $ac_no;

        if ($pay_date != '') {
            $modelPayDetails->pay_date = str_replace('/', '-', $pay_date);
            $modelPayDetails->pay_date = date("Y-m-d", strtotime($modelPayDetails->pay_date));
        }
        if ($real_date != '') {
            $modelPayDetails->realization_date = str_replace('/', '-', $real_date);
            $modelPayDetails->realization_date = date("Y-m-d", strtotime($modelPayDetails->realization_date));
        }else{
            $modelPayDetails->realization_date ='';
        }
        $modelPayDetails->attributes = $modelPayDetails;

        $valid = $modelPayDetails->validate();

        if ($valid) {

            $modelPayDetails->save();
            $jsonData['status'] = 'success';
            $jsonData['id'] = $modelPayDetails->id;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($modelPayDetails, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }
    public function actiongetHealthStatus(){

        $condition = '1=1';
        $models = MasHealthStatus::model()->findAll($condition);
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'health_status' => $value->health_status
            );
        }
        echo json_encode($data);
    }
    
    
    
    
    //code added by mereena on 13/05/2018 
    
    
    /************************************ Code added for new App  -- Sanjana ***************************/
    
    
   public function actionSaveCustomerDetails() {
       $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];
$updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id > 0){
      
       $json = file_get_contents('php://input');
        $data = json_decode($json);
        date_default_timezone_set("Asia/Dubai");
       
        
         $model = new Customer();
         $json = array();
         // $id=$_GET['id'];
        // print_r($id);exit;
        
    //  $id   = $data->id;
        $cust_first_name     =   $data->first_name;
        $cust_middle_name    =   $data->middle_name;
        $cust_last_name      =   $data->last_name;
        
      $cust_date_of_birth  =   $data->dob;
        $cust_gender         =   $data->gender;
        $cust_company_name  =   $data->company_name;
        $cust_phone_no      =   $data->phone;
        $cust_mobile1       =   $data->mobile;
        $cust_email1        =   $data->personal_mail;
        $cust_health        =   $data->fitness;
        $cust_smoker        =   $data->smoker;
        $cust_prospect_source =   $data->prospect_source; 
        $cust_status       =   $data->status;
        $cust_notes        =   $data->notes;
        $cust_country_code =   $data->country;
        $cust_emirate_id   =   $data->emirates;
        $cust_nationality_id  =   $data->nationality;
        $cust_email2       =   $data->official_mail;
        $cust_res_address  =   $data->residence_address;
        $cust_po_box       =   $data->po_box;
        $cust_res_number   =   $data->residence_no;
        $cust_marital_status  =   $data->marital_status;
        $cust_executive_id  =  $user_id;
    //  print_r($cust_marital_status);exit;
       
            $model->created_by = $user_id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->cust_locked_date = date('Y-m-d', strtotime('+90 days', strtotime(date('Y-m-d'))));
            $scene = 'new';
      
     //  $model->attributes = $datas['CustomerApp'];
       $model->cust_executive_id = $cust_executive_id;
        $model->cust_first_name = $cust_first_name;
        $model->cust_middle_name = $cust_middle_name;
        $model->cust_last_name = $cust_last_name;   
     $model->cust_gender = $cust_gender;
        $model->cust_company_name = $cust_company_name;
        $model->cust_phone_no = $cust_phone_no;
        $model->cust_mobile1 = $cust_mobile1;
        $model->cust_email1 = $cust_email1;
        $model->cust_health = $cust_health;
        $model->cust_smoker = $cust_smoker;
        $model->cust_prospect_source = $cust_prospect_source; 
        $model->cust_res_address = $cust_res_address; 
        $model->cust_status = $cust_status;
        $model->cust_notes = $cust_notes;
        $model->cust_country_code= $cust_country_code;
        $model->cust_emirate_id = $cust_emirate_id;
        $model->cust_nationality_id = $cust_nationality_id;
        $model->cust_email2 = $cust_email2;
        $model->cust_po_box = $cust_po_box;
        $model->cust_res_number = $cust_res_number;
        $model->cust_marital_status = $cust_marital_status;
               
               
     if ($cust_date_of_birth != '') {
            $model->cust_date_of_birth = str_replace('/', '-', $cust_date_of_birth);
            $model->cust_date_of_birth = date("Y-m-d", strtotime($cust_date_of_birth));
        }
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
         $json_array['customer_id'] = $model->id;
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          // $cust_mobile1 = $cust_mobile1;
        $cust_mobile1 = str_replace(' ', '', $cust_mobile1);
        $cust_mobile1 = str_replace('+', '', $cust_mobile1);
        $cust_mobile1 = str_replace('-', '', $cust_mobile1);
        $condition = " t.cust_mobile1 ='" . $cust_mobile1 . "' ";
        if ($id != "") {
            $condition .= " AND t.id !=" . $id;
        }
        $model = Customer::model()->findAll($condition);
        if ($model!=null) {
             $error1 = array('status' => 'Failed' ,'cust_mobile1'=>'Mobile Number Already Exist');
          
                    echo json_encode($error1);
                       
        } 
        
                   
    } 
             }
     else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
                 
             }
      else{
            echo $this->getResponse(301);
        }
    }
    
    public function actionUpdateCustomerDetails() {
      $token = $_SERVER['HTTP__TOKEN'];
      $user_id = $_SERVER['HTTP_USER_ID']; $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
              if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
        date_default_timezone_set("Asia/Dubai");
         $model = new Customer();
         $json = array();
            if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        // print_r($id);exit;
        
    //  $id   = $data->id;
        $cust_first_name     =   $data->first_name;
        $cust_middle_name    =   $data->middle_name;
        $cust_last_name      =   $data->last_name;
        
      $cust_date_of_birth  =   $data->dob;
        $cust_gender         =   $data->gender;
        $cust_company_name  =   $data->company_name;
        $cust_phone_no      =   $data->phone;
       // $cust_mobile1       =   $data->mobile;
        $cust_email1        =   $data->personal_mail;
        $cust_health        =   $data->fitness;
        $cust_smoker        =   $data->smoker;
        $cust_prospect_source =   $data->prospect_source; 
        $cust_status       =   $data->status;
        $cust_notes        =   $data->notes;
        $cust_country_code =   $data->country;
        $cust_emirate_id   =   $data->emirates;
        $cust_nationality_id  =   $data->nationality;
        $cust_email2       =   $data->official_mail;
        $cust_res_address  =   $data->residence_address;
        $cust_po_box       =   $data->po_box;
        $cust_res_number   =   $data->residence_no;
        $cust_marital_status  =   $data->marital_status;
        $cust_executive_id  =  $user_id;
     //print_r($id);exit;
        if ($id > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_date_time = date('Y-m-d H:i:s');
              $model->cust_executive_id = $cust_executive_id;
        $model->cust_first_name = $cust_first_name;
        $model->cust_middle_name = $cust_middle_name;
        $model->cust_last_name = $cust_last_name;   
     $model->cust_gender = $cust_gender;
        $model->cust_company_name = $cust_company_name;
        $model->cust_phone_no = $cust_phone_no;
        $model->cust_email1 = $cust_email1;
        $model->cust_health = $cust_health;
        $model->cust_smoker = $cust_smoker;
        $model->cust_prospect_source = $cust_prospect_source; 
        $model->cust_res_address = $cust_res_address; 
        $model->cust_status = $cust_status;
        $model->cust_notes = $cust_notes;
        $model->cust_country_code= $cust_country_code;
        $model->cust_emirate_id = $cust_emirate_id;
        $model->cust_nationality_id = $cust_nationality_id;
        $model->cust_email2 = $cust_email2;
        $model->cust_po_box = $cust_po_box;
        $model->cust_res_number = $cust_res_number;
        $model->cust_marital_status = $cust_marital_status;
        if ($cust_date_of_birth != '') {
            $model->cust_date_of_birth = str_replace('/', '-', $cust_date_of_birth);
            $model->cust_date_of_birth = date("Y-m-d", strtotime($cust_date_of_birth));
        }
        } 
      
     
        
        if( $model->save(false)){
         $json_array['customer_id'] = $model->id;
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
        $json_array['status'] = "success";
            echo json_encode($json_array);
         
       
                   
    }
              }
     else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
   
        
     
     
     
     
      public function actiongetCustomerlistbyid() {
          
      $token = $_SERVER['HTTP__TOKEN'];
      $user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             $id    = Yii::app()->request->getParam('id');
          $models  = Customer::model()->findAll(array('condition'=>'id=' .$id));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            
             $nationality1=$value->cust_nationality_id;
            $model1  = MasCountry::model()->findAll(array('condition'=>'id=' .$nationality1));
           $nationality=$model1[0]['country_name'];
           
             $country1=$value->cust_country_code;
            $model2  = MasCountry::model()->findAll(array('condition'=>'id=' .$country1));
           $country=$model2[0]['country_name'];
           
             $emirates1=$value->cust_emirate_id;
            $model3 = MasEmirates::model()->findAll(array('condition'=>'id=' .$emirates1));
           $emirates=$model3[0]['emirate_name'];
           $gender=$value->cust_gender;
           if($gender == 1){
               $genderr="Male";
           }else if($gender == 2){
                $genderr="Female";
           }
           $fitness=$value->cust_health;
            if($fitness == 1){
               $fitnes ="Good Health";
           }else if($fitness == 2){
                $fitnes="Under Medication";
           }
            $prospect_source = $value->cust_prospect_source;
            if($prospect_source == 1){
               $prospect_sourcee ="Referral";
           }else if($prospect_source == 2){
                $prospect_sourcee="Network";
           }else if($prospect_source == 3){
                $prospect_sourcee="Website";
           }else if($prospect_source == 4){
                $prospect_sourcee="Advertisement";
           }
           $cust_statuss=$value->cust_status;
            if($cust_statuss == 1){
               $cust_status ="Hot";
           }else if($cust_statuss == 2){
                $cust_status="Warm";
           }else if($cust_statuss == 3){
                $cust_status="Cold";
           }
           
          $maritalstatus= $value->cust_marital_status;
          if($maritalstatus == 1){
               $maritalstatuss ="Single";
           }else if($maritalstatus == 2){
                $maritalstatuss="Married";
           }else if($maritalstatus == 3){
                $maritalstatuss="Widow / Widower";
           }else if($maritalstatus == 4){
                $maritalstatuss="Divorced";
           }else if($maritalstatus == 5){
                $maritalstatuss="Separated";
           }
           
           $custm= $value->cust_policy_taken;
           if($custm == Y)
           {
               $prspct = "Customer";
           }else if($custm == N){
                $prspct="Prospect";
           }
           
            $data['data'][] = array(
                'id' => $value->id,
                'cust_first_name' => $value->cust_first_name,
                'cust_middle_name' => $value->cust_middle_name,
                'cust_last_name' => $value->cust_last_name,
                'cust_gender' => $value->cust_gender,
                'cust_gender_value' => $genderr,
                'cust_company_name' => $value->cust_company_name,
                'cust_phone_no' => $value->cust_phone_no,
                'cust_mobile1' => $value->cust_mobile1,
                'cust_email1' => $value->cust_email1,
                'cust_health' => $value->cust_health,
                'cust_health_value' => $fitnes,
                'cust_smoker' => $value->cust_smoker,
                'cust_prospect_source' => $value->cust_prospect_source,
                 'cust_prospect_source_value' => $prospect_sourcee,
                'cust_res_address' => $value->cust_res_address,
                'cust_status' => $value->cust_status,
                'cust_status_value' => $cust_status,
                'cust_notes' => $value->cust_notes,
                'cust_country_code' => $value->cust_country_code,
                'cust_country_name' =>$country,
                'cust_emirate_id' => $value->cust_emirate_id,
                'cust_emirate_name' => $emirates,
                'cust_nationality_name' =>$nationality,
                'cust_nationality_id' =>$value->cust_nationality_id,
                'cust_date_of_birth' =>date("d-m-Y", strtotime($value->cust_date_of_birth)),
                'cust_email2' => $value->cust_email2,
                'cust_po_box' => $value->cust_po_box,
                'cust_res_number' => $value->cust_res_number,
                'cust_marital_status' => $value->cust_marital_status,
                'cust_marital_status_value' =>$maritalstatuss,
                'cust_executive_id' => $value->cust_executive_id,
                'cust_type' =>$prspct
               
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
      }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    
     
     
      public function actiongetCustomerlist() {
          
          
$token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             
             if($user_id > 0){
         
       
      
          $models  = Customer::model()->findAll(array('condition'=>'isActive="Y" AND cust_executive_id ='.$user_id,'order' => 'cust_first_name,cust_last_name ASC'));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            
            $data['data'][] = array(
                'id' => $value->id,
                'cust_first_name' => $value->cust_first_name,
                'cust_last_name' => $value->cust_last_name,
                'cust_mobile1' => $value->cust_mobile1,
                'cust_email1' => $value->cust_email1,
                'cust_emirate_id' => $value->cust_emirate_id,
                'cust_nationality_id' => $value->cust_nationality_id,
                'cust_date_of_birth' => date("d-m-Y", strtotime($value->cust_date_of_birth)),
                'cust_status' => $value->cust_status,
                'cust_policy_taken' => $value->cust_policy_taken,
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
     }
         
         else{
            echo $this->getResponse(201); 
         }
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    
    
    public function actionSaveUser(){
        header('Content-type:application/json');
        $input = file_get_contents('php://input'); //

        $datas = json_decode($input, true);
       
print_r($datas);

       /* $model = new User();

        if (isset($datas['User'])) {
            $response = $this->writeResponse($input); //Response log
            //Success
            echo $this->getResponse(100);
        }
        else{
             $response = $this->writeResponse($input); //Response log
            //Success
            echo $this->getResponse(100);
        }*/
        
    }
    
     /**
     * JSON Response Array
     */
    public function getResponse($resposnecode) {
        $responseArray = array(
            //Success
            100 => array(
                'code' => 100,
                'status' => 'success',
                'message' => 'Saved successfully',
            ),
            //Input
            200 => array(
                'code' => 200,
                'status' => 'failed',
                'message' => 'User input is empty',
            ),
            201 => array(
                'code' => 201,
                'status' => 'failed',
                'message' => 'Invaid User',
            ),
            202 => array(
                'code' => 202,
                'status' => 'failed',
                'message' => '',
            ),
            203 => array(
                'code' => 203,
                'status' => 'failed',
                'message' => 'No Database found',
            ),
            204 => array(
                'code' => 204,
                'status' => 'failed',
                'message' => '',
            ),
            205 => array(
                'code' => 205,
                'status' => 'failed',
                'message' => '',
            ),
            206 => array(
                'code' => 206,
                'status' => 'failed',
                'message' => '',
            ),
            207 => array(
                'code' => 207,
                'status' => 'failed',
                'message' => '',
            ),
            208 => array(
                'code' => 208,
                'status' => 'failed',
                'message' => '',
            ),
            209 => array(
                'code' => 209,
                'status' => 'failed',
                'message' => '',
            ),
            210 => array(
                'code' => 210,
                'status' => 'failed',
                'message' => 'Date format invalid',
            ),
            211 => array(
                'code' => 211,
                'status' => 'failed',
                'message' => '',
            ),
            //Token
            300 => array(
                'code' => 300,
                'status' => 'failed',
                'message' => 'Token not Found',
            ),
            301 => array(
                'code' => 301,
                'status' => 'failed',
                'message' => 'Token Verification Failed',
            ),
            800 => array(
                'code' => 800,
                'status' => 'failed',
                'message' => 'password changed',
            ),
            801 => array(
                'code' => 801,
                'status' => 'failed',
                'message' => '',
            ),
        );

        return json_encode($responseArray[$resposnecode]);
    }
    
    
    
    
    public function actionSavecallactivity() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
         if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        // print_r($id);exit;
        $idd=0;
        
    //  $id   = $data->id;
    if($data->call_time != ""){
     $activity_call_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->call_time)));
    }
     if($data->call_back_time != ""){
      $activity_call_back_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->call_back_time)));
     }
     if($data->call_date != ""){
        $activity_call_date     =   $data->call_date;
     }
       if($data->call_back_date != ""){
        $activity_call_back_date     =   $data->call_back_date;
       }
       // print_r($activity_call_time);print_r($activity_call_back_time);exit;
     
        $activity_notes        =   $data->notes;
        
       $activity_customer_id  =   $id;
        if($activity_call_date != "" && $activity_call_time != ""){
       $call_date_time = date('Y-m-d H:i:s', strtotime("$activity_call_date $activity_call_time"));}
       if($activity_call_back_date != "" && $activity_call_back_time != ""){
       //$call_date_time = date('Y-m-d H:i:s', strtotime("$activity_call_date $activity_call_time"));
        $callback_date_time = date('Y-m-d H:i:s', strtotime("$activity_call_back_date $activity_call_back_time"));}
    // print_r($callback_date_time);exit;
        if ($idd > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
            $scene = 'new';
        }
       $model->attributes = $datas['Activity'];
       $model->customer_id = $activity_customer_id;
       $model->type_of_activity=1;
       
        $model->call_or_plan_date_time = $call_date_time;
        $model->call_back_or_actual_date = $callback_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
             }
      else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
               
         }
      else{
            echo $this->getResponse(301);
        }
                 
    }
    
     public function actionSavevisitactivity() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
          $id=$_GET['id'];
        // print_r($id);exit;
        $idd=0;
       // $activity_planned_time = '00:00:00';
    //  $id   = $data->id;
    if($data->planned_time !=""){
     $activity_planned_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->planned_time)));
    }if($data->actual_time !=""){
      $activity_actual_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->actual_time)));
    }if($data->planned_date !=""){
        $activity_planned_date     =   $data->planned_date;
    }
     if($data->actual_date !=""){
       
        $activity_actual_date     =   $data->actual_date;
     }
       // print_r($activity_call_time);print_r($activity_call_back_time);exit;
     
        $activity_notes        =   $data->notes;
        $manager_id = $data->manager;
       $activity_customer_id  =   $id;
       if($activity_planned_date !="" && $activity_planned_time!=""){
       $plan_date_time = date('Y-m-d H:i:s', strtotime("$activity_planned_date $activity_planned_time"));}
       if($activity_actual_date !="" && $activity_actual_time!=""){
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));}
    //  print_r($cust_res_address);exit;
        if ($idd > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
            $scene = 'new';
        }
       $model->attributes = $datas['Activity'];
       $model->customer_id = $activity_customer_id;
       $model->type_of_activity=3;
       $model->manager_id=$manager_id;
        $model->call_or_plan_date_time = $plan_date_time;
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
             }
      else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
     }
     
      else{
            echo $this->getResponse(301);
        }
                 
    }
    
    public function actionUpdatevisitactivity() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
              if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
          if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        
      $activity_actual_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->actual_time)));
       
        $activity_actual_date     =   $data->actual_date;
      
        $activity_notes        =   $data->notes;
        
     if($activity_actual_time !="" && $activity_actual_date!=""){
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));}
    //  print_r($cust_res_address);exit;
        if ($id > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $data->user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        } 
       $model->attributes = $datas['Activity'];
       
       $model->type_of_activity=3;
      
       
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
         } else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
     }
      else{
            echo $this->getResponse(301);
        }     
    }
    
     public function actiongetManagerlist() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
       
          $models  = User::model()->findAll(array('condition'=>'isActive="Y"'));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'first_name' => $value->first_name,
                'last_name' => $value->last_name,
                'username' => $value->username,
                
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
   
    
    
  public function actiongetPlandetails() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
               if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
       //echo $id;exit;
     
            $models  = CustomerPlanDetails::model()->findAll(array('condition'=>'customer_id=' .$id,'order' => 'id DESC'));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            
             $provider_name1=$value->provider_id;
            $model1 = Provider::model()->findAll(array('condition'=>'id=' .$provider_name1));
           $provider_name=$model1[0]['provider_name'];
            $plan_name1=$value->plan_id;
            $model2  = MasProviderPlans::model()->findAll(array('condition'=>'id=' .$plan_name1));
           $plan_name=$model2[0]['plan_name'];
          
           
           
            $data['data'][] = array(
                'id' => $value->id,
                'provider_id' => $provider_name,
                'plan_id' => $plan_name,
                'policy_no' => $value->policy_no,
                
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    
    }
     
    
    
    
    
     public function actionSaveappointments() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
               if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
     date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
            if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
          
       $planned_time=$data->planned_time;
       $actual_time=$data->actual_time;
       $actual_date= $data->actual_date;
        $planned_date= $data->planned_date;
        if($planned_time !=""){ //echo $planned_time;exit;
     $activity_planned_time  = date("H:i:s", strtotime(str_replace(' ', '', $planned_time)));}
     if($actual_time != ""){
      $activity_actual_time  = date("H:i:s", strtotime(str_replace(' ', '', $actual_time)));}
      if($planned_date != ""){
        $activity_planned_date     =   $planned_date;
      }
      if($actual_date != ""){
        $activity_actual_date     =   $actual_date;
      }
     
        $activity_notes        =   $data->notes;
        $duration = $data->duration;
       $activity_customer_id  =   $id;
       if($activity_planned_date !="" && $activity_planned_time!=""){
       $plan_date_time = date('Y-m-d H:i:s', strtotime("$activity_planned_date $activity_planned_time"));
           
            //$json_array['datetime'] = $plan_date_time;
            //echo json_encode($json_array);
           //exit;
       }
       if($activity_actual_date !="" && $activity_actual_time!=""){
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));
}
       
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
            $scene = 'new';
        
       $model->attributes = $datas['Activity'];
       $model->customer_id = $activity_customer_id;
       $model->type_of_activity=2;
       $model->duration=$duration;
        $model->call_or_plan_date_time = $plan_date_time;
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
         }
         
      else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
        
        
                 
    }
    
     public function actionUpdateappointments() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id >0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
           if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        // print_r($id);exit;
       // $idd=0;
        
    //  $id   = $data->id;
    
      $activity_actual_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->actual_time)));
       
        $activity_actual_date     =   $data->actual_date;
      
        $activity_notes        =   $data->notes;
       // $duration = $data->duration;
      // $activity_customer_id  =   $id;
       
      // $plan_date_time = date('Y-m-d H:i:s', strtotime("$activity_planned_date $activity_planned_time"));
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));
    //  print_r($cust_res_address);exit;
        if ($id > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        }
       $model->attributes = $datas['Activity'];
      // $model->customer_id = $activity_customer_id;
       $model->type_of_activity=2;
      // $model->duration=$duration;
       // $model->call_or_plan_date_time = $plan_date_time;
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
             }
         
      else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
        
     }
      else{
            echo $this->getResponse(301);
        }
                 
    }
    
    
     public function actiongetActivityhistory() {
         
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
          if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
       
          $models  = Activity::model()->findAll(array('condition'=>'isActive="Y" AND customer_id =' .$id,'order' => 'call_back_or_actual_date DESC'));
         
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            
            $createddby=$value->created_by;
            $model1  = User::model()->findAll(array('condition'=>'id=' .$createddby));
         
         $created_byy=  "".$model1[0]['first_name']." ".$model1[0]['last_name'];
        
            $activity=$value->type_of_activity;
            if($activity == 1)
            {
                $activityy="Call";
            }
             if($activity == 2)
            {
                $activityy="Appointment";
            }
             if($activity == 3)
            {
                $activityy = "Joint Field Visit"	;
            }
             if($activity == 4)
            {
                $activityy="Fact Find";
            }
             if($activity == 5)
            {
                $activityy="Presentation";
            }
             if($activity == 6)
            {
                $activityy="Application";
            }
             if($activity == 7)
            {
                $activityy="Review Meeting";
            }
            $actual_date = '';
            $actual_time ='';
            $actual_time_date='';
            $call_time_date='';
            $calll_time='';
            $calll_date='';
            if($value->call_or_plan_date_time !='0000-00-00 00:00:00' AND $value->call_or_plan_date_time !='1970-01-01 00:00:00' ){
            $calll_date=date('d-m-Y',strtotime($value->call_or_plan_date_time));
             $calll_time=date('H:i a',strtotime($value->call_or_plan_date_time));
             $call_time_date=date('d-m-Y h:i a ', strtotime($value->call_or_plan_date_time));
            }if($value->call_back_or_actual_date !='0000-00-00 00:00:00' AND $value->call_back_or_actual_date !='1970-01-01 00:00:00' ){
              $actual_date=date('d-m-Y',strtotime($value->call_back_or_actual_date));
             $actual_time=date('H:i a',strtotime($value->call_back_or_actual_date));
             $actual_time_date=date('d-m-Y h:i a', strtotime($value->call_back_or_actual_date));
            }
            $data['data'][] = array(
                'id' => $value->id,
                'type_of_activity' => $activityy,
                'call_or_plan_date_time' => $call_time_date,
                'call_back_or_actual_date' => $actual_time_date,
                'call_or_plan_date'=>$calll_date,
                'call_or_plan_time'=>$calll_time,
                'callback_or_actual_date'=>$actual_date,
                'callback_or_actual_time'=>$actual_time,
                'duration' => $value->duration,
                'manager_id' => $value->manager_id,
                'activity_notes' => $value->activity_notes,
                 'plan_id' => $value->plan_id,
                'application_status' => $value->application_status,
                'created_by' => $created_byy,
                'created_datetime' =>date('d-m-Y h:i a', strtotime($value->created_datetime)),
               
                
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    
     public function actionSavefactfind() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        

       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $modeldoc=new ActivityDocument();
         $json = array();
           if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        // print_r($id);exit;
       
        
    //  $id   = $data->id;
    if($data->actual_time !=""){
      $activity_actual_time  = $_POST['actual_time'];
    }
         if($data->actual_date !=""){
        $activity_actual_date     =   $_POST['actual_date'];
         }
       // print_r($activity_call_time);print_r($activity_call_back_time);exit;
     
        $activity_notes        =   $_POST['notes'];
         $document_name        =   $_POST['document_name'];
        
       $activity_customer_id  =   $id;
       
    //  print_r($activity_actual_date);exit;
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));
     
        
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
           
       
       $model->attributes = $datas['Activity'];
    $model->customer_id = $activity_customer_id;
       $model->type_of_activity=4;
       
         
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes; 
        
       $modeldoc->document_type=3;
         $modeldoc->document_name=$document_name;
          $modeldoc->document_from=1;
           $modeldoc->customer_id=$activity_customer_id;
        $modeldoc->created_by = $user_id;
            $modeldoc->created_date_time = date('Y-m-d h:i:s');
       
        
        $target_dir = "uploads/documents/";
                $file_name = basename($_FILES["file_name"]["name"]);
                
               
                $target_file = $target_dir . $file_name;
                while (file_exists($target_file)) {
                    $file_name = substr(sha1(rand()), 0, 6) . "_" . basename($_FILES["file_name"]["name"]);
                    $target_file = $target_dir . $file_name;
                }
               
                $imagename = '';
                if (move_uploaded_file($_FILES["file_name"]["tmp_name"], "uploads/documents/" . $file_name)) {
                    $imagename = $file_name;
                     $modeldoc->document_file = $imagename;
                }
               
               // $json_array['status'] = $imagename;
          //  echo json_encode($json_array);
     
     
        $valid = $model->validate();
        if ($valid) {
     $modeldoc->save();
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
        
             
    }
         else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    
     
     public function actionSavepresentation() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id>0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
          if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        // print_r($id);exit;
        $idd=0;
        
    //  $id   = $data->id;
     if($data->actual_time !=""){
      $activity_actual_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->actual_time)));
     }
       if($data->actual_date !=""){
        $activity_actual_date     =   $data->actual_date;
       }
        //print_r($activity_actual_time);print_r($activity_actual_date);exit;
     
        $activity_notes        =   $data->notes;
        
       $activity_customer_id  =   $id;
         if($activity_actual_date !="" && $activity_actual_time!=""){
       
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));
         }
      //print_r($actual_date_time);exit;
        if ($idd > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
            $scene = 'new';
        }
       $model->attributes = $datas['Activity'];
       $model->customer_id = $activity_customer_id;
       $model->type_of_activity=5;
      
       
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
         }
         
      else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
                 
    }
   
     
     
     public function actionSaveapplication() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
           if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        // print_r($id);exit;
        $idd=0;
        
    //  $id   = $data->id;
      if($data->actual_time !=""){
      $activity_actual_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->actual_time)));
      }
       if($data->actual_date !=""){
       
        $activity_actual_date     =   $data->actual_date;
       }
       // print_r($activity_call_time);print_r($activity_call_back_time);exit;
     
        $activity_notes        =   $data->notes;
        $plan_name = $data->plan_name;
       $activity_customer_id  =   $id;
       
       
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));
    //  print_r($cust_res_address);exit;
        if ($idd > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
            $scene = 'new';
        }
       $model->attributes = $datas['Activity'];
       $model->customer_id = $activity_customer_id;
       $model->type_of_activity=6;
        $model->plan_id=$plan_name;
      
       
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
        
         }
          else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
                 
    }
   
    



     public function actionSavereview() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id >0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
           if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        // print_r($id);exit;
        $idd=0;
        
    //  $id   = $data->id;
     if($data->actual_time !=""){
         
      $activity_actual_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->actual_time)));
     
     }
     if($data->actual_date !=""){
        $activity_actual_date     =   $data->actual_date;
     }  // print_r($activity_call_time);print_r($activity_call_back_time);exit;
     
        $activity_notes        =   $data->notes;
        
       $activity_customer_id  =   $id;
       
       
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));
    //  print_r($cust_res_address);exit;
        if ($idd > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
            $scene = 'new';
        }
       $model->attributes = $datas['Activity'];
       $model->customer_id = $activity_customer_id;
       $model->type_of_activity=7;
      
      
       
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
     
        
         }
          else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
         }
      else {
            echo $this->getResponse(301);
        } 
                 
    }
    
    
       public function actiongetDocumentlist() {
       $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
          $models  = MasDocument::model()->findAll(array('condition'=>'isActive="Y" AND app_view = "1"'));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'document_name' => $value->document_name,
               
                
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
     public function actiongetDocumentaddedlist() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
       if( $this->validateToken($token) ){
           if($this->Statusupdate($updated_status)){
       $id=$_GET['id'];
          $models  = ActivityDocument::model()->findAll(array('condition'=>'document_type=3 AND customer_id =' .$id,));
         
        $data = array();
        
        $data['status'] = 'success';
        $data['data'] = array();
       
        foreach ($models as $value) {
            
             $document_type1=$value->document_type;
            $model1  = MasDocument::model()->findAll(array('condition'=>'id=' .$document_type1));
           $document_type=$model1[0]['document_name'];
           
           
            $createddby=$value->created_by;
            $model2  = User::model()->findAll(array('condition'=>'id=' .$createddby));
          
         $created_byy=  "".$model2[0]['first_name']." ".$model2[0]['last_name'];
          $file=$value->document_file;
          
         // $arr_file=explode(",",$file);$count_arr=count($arr_file);
        // print_r(count($arr_file));exit;
        //  $path=Yii::app()->baseUrl/'uploads/documents/'.$file; 
         $path=Yii::app()->baseUrl.'/uploads/documents/';
       // $image_files=array();
      /*   foreach ($arr_file as $i => $row) {
            $image_files[] = array(
              
                'file_name' => $row,
              
                      
            );
            }*/
            $data['data'][] = array(
                'id' => $value->id,
                'document_type' =>$document_type,
                'document_name' => $value->document_name,
                 'customer_id' => $value->customer_id,
                  'created_by' => $created_byy,
                    'created_date_time' =>date("d-m-Y h:i a", strtotime($value->created_date_time)),
                    'file_path' => $path,
                    'images' => $file,
                    
                      
            );
           
        }
     //  print_r($data);exit;
        echo json_encode($data);
           }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    //MIS Dashboard
    
  public function actiongetbirthdaylist() {
        $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
         $today = date("m-d"); 
        $enddate=Strtotime('+10 day');$enddatee=(date("m-d", $enddate));
      
        $condition = ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(cust_date_of_birth,"%m-%d")>="'.$today.'" AND DATE_FORMAT(cust_date_of_birth,"%m-%d")<="'.$enddatee.'"';
        $condition1 = ' 1=1 AND C.created_by="'.$user_id.'" AND DATE_FORMAT(D.dependant_date_of_birth,"%m-%d")>="'.$today.'" AND DATE_FORMAT(D.dependant_date_of_birth,"%m-%d")<="'.$enddatee.'"';
$SQL  = 'SELECT * FROM ((SELECT  id as customerid,CONCAT(cust_first_name,cust_middle_name,cust_last_name) as name,
                            cust_gender as gender,
                            cust_phone_no as phone,
                            cust_mobile1 as mobile,
                            cust_email1 as email,
                            cust_date_of_birth as dob,"C" AS tal 
                            FROM crm_customer  where '.$condition.') 
                            UNION ALL (SELECT D.customer_id as customerid,D.dependant_name as name,D.id as gender,D.id as phone,D.id as mobile,
                            D.id as email,dependant_date_of_birth as dob,
                            "CD" AS tal FROM crm_customer_dependants AS D 
                            INNER JOIN crm_customer AS C ON  C.id=D.customer_id  where '.$condition1.')) results ORDER BY DATE_FORMAT(dob,"%m-%d") ASC';
$list = Yii::app()->db->createCommand($SQL)->queryAll(); 
       // $models = Customer::model()->findAll(array('condition'=>$condition,'order'=>' DATE_FORMAT(cust_date_of_birth,"%m-%d") ASC'));
      // echo $token;  exit;
        $count=count($list);
        $data = array();
        $data['status'] = 'success';
        $data['count'] = $count;
        $data['data'] = array();
        foreach ($list as $i => $row) {           
        
            if($row['tal'] == 'CD'){
                $customer_id  = $row['customerid'];
                $modelCust  = Customer::model()->findByPk($customer_id);
                $phnno  = $modelCust['cust_phone_no'];
                $mob  = $modelCust['cust_mobile1'];
                $email  = $modelCust['cust_email1'];
                
            }
            else{
                $phnno  = $row['phone'];
                $mob  = $row['mobile'];
                $email  = $row['email'];
            }
      
            $data['data'][] = array(
               
                'cust_first_name' => $row['name'],
               'cust_phone_no' => $phnno,
                'cust_mobile1' => $mob,
                'cust_email1' => $email,
                 'cust_date_of_birth' =>date('M d', strtotime($row['dob'])),
              
            );
        }
        //print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
     public function actiongetanniversary() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        // echo Yii::app()->user->id;exit;
        //$today = date("m-d"); 
        //$enddate=Strtotime('+10 day');$enddatee=(date("m d", $enddate));
        $current_date_15 = date('Y-m-d', strtotime('+10 days', strtotime(date('Y-m-d'))));
                        $current_day = date('d');
                        $current_day_15 = date('d', strtotime($current_date_15));
                        $current_month = date('m');
                        $current_month_15 = date('m', strtotime($current_date_15));
                        //$id=9;
   $condition='policy_status="O" AND (cust_executive_id="'.$user_id.'"  OR cust_executive_id IN ('.$user_id.')) AND DAY(start_date)>="'.$current_day.'" AND DAY(start_date)<="'.$current_day_15.'" AND MONTH(start_date)="'.$current_month.'" AND MONTH(start_date)="'.$current_month_15.'"';
                  $models= CustomerPlanDetails::model()->with('customer')->findAll(array('condition' =>$condition,'order'=>'DAY(start_date) asc'));
         $count=count($models);//print_r($models);exit;
        $data = array();
        $data['status'] = 'success';
        $data['count'] = $count;
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'cust_first_name' => $value->customer->cust_first_name,
                'cust_middle_name' => $value->customer->cust_middle_name,
                'cust_last_name' => $value->customer->cust_last_name,
                'cust_gender' => $value->customer->cust_gender,
               'cust_phone_no' => $value->customer->cust_phone_no,
                'cust_mobile1' => $value->customer->cust_mobile1,
                'cust_email1' => $value->customer->cust_email1,
                'created_date_time' =>date('M d', strtotime($value->start_date)),
              
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    /* public function actiongetanniversary() {
        $today = date("m-d"); 
        $enddate=Strtotime('+10 day');$enddatee=(date("m d", $enddate));
      
        $condition = ' 1=1 AND DATE_FORMAT(t.created_date_time,"%m-%d")>="'.$today.'" AND DATE_FORMAT(t.created_date_time,"%m-%d")<="'.$enddatee.'"';
        $models = Customer::model()->findAll(array('condition'=>$condition,'order'=>' DATE_FORMAT(created_date_time,"%m-%d") ASC'));
         $count=count($models);
        $data = array();
        $data['status'] = 'success';
        $data['count'] = $count;
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'cust_first_name' => $value->cust_first_name,
                'cust_middle_name' => $value->cust_middle_name,
                'cust_last_name' => $value->cust_last_name,
                'cust_gender' => $value->cust_gender,
               'cust_phone_no' => $value->cust_phone_no,
                'cust_mobile1' => $value->cust_mobile1,
                'cust_email1' => $value->cust_email1,
                'created_date_time' =>date('M d', strtotime($value->created_date_time)),
              
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
    }
    */
     public function actiongetfollowup() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
         $date=$_GET['date'];
       $maindate=date("d-m-Y", strtotime($date));
        $maindate1=date("d-m", strtotime($date));
     // $today=date('m d');
    // echo $date;
    
     $conditionc = ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(cust_date_of_birth,"%d-%m")="'.$maindate1.'"';
        $conditiond = ' 1=1 AND C.created_by="'.$user_id.'" AND DATE_FORMAT(dependant_date_of_birth,"%d-%m")="'.$maindate1.'"';
        
$SQL  = 'SELECT * FROM ((SELECT  id as customerid,CONCAT(cust_first_name,cust_middle_name,cust_last_name) as name,
                            cust_gender as gender,
                            cust_phone_no as phone,
                            cust_mobile1 as mobile,
                            cust_email1 as email,
                            cust_date_of_birth as dob,"C" AS tal 
                            FROM crm_customer  where '.$conditionc.') 
                            UNION ALL (SELECT D.customer_id as customerid,D.dependant_name as name,D.id as gender,D.id as phone,D.id as mobile,
                            D.id as email,dependant_date_of_birth as dob,
                            "CD" AS tal FROM crm_customer_dependants AS D 
                            INNER JOIN crm_customer AS C ON  C.id=D.customer_id  where '.$conditiond.')) results ORDER BY DATE_FORMAT(dob,"%m-%d") ASC';
$modelsbirthday = Yii::app()->db->createCommand($SQL)->queryAll(); 
//print_r($modelsbirthday);


  $anniversary='policy_status="O" AND (cust_executive_id="'.$user_id.'"  OR cust_executive_id IN ('.$user_id.')) AND DAY(start_date)="'.$maindate1.'"';
                 

       // $anniversary = ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(t.start_date,"%d-%m")="'.$maindate1.'"';
       // $birthday = ' 1=1 AND DATE_FORMAT(t.cust_date_of_birth,"%d-%m")="'.$maindate1.'"';
        $calltype1= ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(t.call_back_or_actual_date,"%d-%m-%Y")="'.$maindate.'" AND (t.type_of_activity)="1"';
         $plandate1= ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(t.call_or_plan_date_time,"%d-%m-%Y")="'.$maindate.'" AND (t.type_of_activity)="2"';
          $plandate2= ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(t.call_or_plan_date_time,"%d-%m-%Y")="'.$maindate.'" AND (t.type_of_activity)="3"';
          $actualdate1= ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(t.call_back_or_actual_date,"%d-%m-%Y")="'.$maindate.'" AND (t.type_of_activity)="4"';
          $actualdate2= ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(t.call_back_or_actual_date,"%d-%m-%Y")="'.$maindate.'" AND (t.type_of_activity)="5"';
          $actualdate3= ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(t.call_back_or_actual_date,"%d-%m-%Y")="'.$maindate.'" AND (t.type_of_activity)="6"';
          $actualdate= ' 1=1 AND created_by="'.$user_id.'" AND DATE_FORMAT(t.call_back_or_actual_date,"%d-%m-%Y")="'.$maindate.'" AND (t.type_of_activity)="7"';
        //$modelsanniversary = CustomerPlanDetails::model()->findAll(array('condition'=>$anniversary));
         $modelsanniversary= CustomerPlanDetails::model()->with('customer')->findAll(array('condition' =>$anniversary,'order'=>'DAY(start_date) asc'));
         //$modelsbirthday = Customer::model()->findAll(array('condition'=>$birthday));
     $modelactivitycall = Activity::model()->findAll(array('condition'=>$calltype1));
     $modelactivityappointment = Activity::model()->findAll(array('condition'=>$plandate1));
      $modelactivityvisit = Activity::model()->findAll(array('condition'=>$plandate2));
      $modelactivityfactfind = Activity::model()->findAll(array('condition'=>$actualdate1));
      $modelactivitypresentation = Activity::model()->findAll(array('condition'=>$actualdate2));
      $modelactivityapplication = Activity::model()->findAll(array('condition'=>$actualdate3));
      $modelactivityreview = Activity::model()->findAll(array('condition'=>$actualdate));
      
        $data = array();
        $data['status'] = 'success';
      //  $data['count'] = $count;
        $data['anniversary'] = array();
       $data['birthday'] = array();
       $data['call_back'] = array();
       $data['plan_date'] = array();
        $data['actual_date'] = array();
        
        
        
        foreach ($modelsanniversary as $value) {
             $customer_id=$value->customer_id;
            if($customer_id > 0){
            $model1  = Customer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['cust_first_name'];
            $cust_middle_name=$model1[0]['cust_middle_name'];
             $cust_last_name=$model1[0]['cust_last_name'];
              $cust_mobile1=$model1[0]['cust_mobile1'];
               $cust_email1=$model1[0]['cust_email1'];
               $cust_phn=$model1[0]['cust_phone_no'];
               $cust_createdtime=$model1[0]['created_date_time'];
               
              $dob=date("d-m-Y", strtotime($model1[0]['cust_date_of_birth']));   
               //print_r($modelsanniversary);exit;
            }
            
            
            $data['anniversary'][] = array(
                'id' => $value->id,
                'cust_first_name' => $cust_first_name,
                'cust_middle_name' => $cust_middle_name,
                'cust_last_name' => $cust_last_name,
                'cust_date_of_birth' => $dob,
               'cust_phone_no' => $cust_phn,
                'cust_mobile1' => $cust_mobile1,
                'cust_email1' => $cust_email1,
                'created_date_time' => date("d-m-Y", strtotime($value->start_date)),
                'customer_id' => $customer_id,
            );
        }
        
        
        
        
        
        foreach ($modelsbirthday as $i => $row) {           
        $customer_id=0;
            if($row['tal'] == 'CD'){
                $customer_id  = $row['customerid'];
                $modelCust  = Customer::model()->findByPk($customer_id);
                $phnno  = $modelCust['cust_phone_no'];
                $mob  = $modelCust['cust_mobile1'];
                $email  = $modelCust['cust_email1'];
                
            }
            else{
                $phnno  = $row['phone'];
                $mob  = $row['mobile'];
                $email  = $row['email'];
            }
      
            $data['birthday'][] = array(
               
                'cust_first_name' => $row['name'],
                
               'cust_phone_no' => $phnno,
                'cust_mobile1' => $mob,
                'cust_email1' => $email,
                 'cust_date_of_birth' =>date('M d', strtotime($row['dob'])),
                'customer_id' => $row['customerid'],
              
            );
        }
        
        
       /* foreach ($modelsbirthday as $value) {
            
            
            $data['birthday'][] = array(
                'id' => $value->id,
                'cust_first_name' => $value->cust_first_name,
                'cust_middle_name' => $value->cust_middle_name,
                'cust_last_name' => $value->cust_last_name,
                'cust_date_of_birth' => $value->cust_date_of_birth,
               'cust_phone_no' => $value->cust_phone_no,
                'cust_mobile1' => $value->cust_mobile1,
                'cust_email1' => $value->cust_email1,
                'created_date_time' => $value->created_date_time,
              
            );
        }*/
         foreach ($modelactivitycall as $value) {
             $customer_id=$value->customer_id;
            if($customer_id > 0){
            $model1  = Customer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['cust_first_name'];
            $cust_middle_name=$model1[0]['cust_middle_name'];
             $cust_last_name=$model1[0]['cust_last_name'];
              $cust_mobile1=$model1[0]['cust_mobile1'];
               $cust_email1=$model1[0]['cust_email1'];
                
            }else
            {
                 $customer_id=$value->lead_customer_id;
               $model1  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['customer_first_name'];
            $cust_middle_name=$model1[0]['customer_middle_name'];
             $cust_last_name=$model1[0]['customer_last_name'];
              $cust_mobile1=$model1[0]['customer_mobile_number'];
               $cust_email1=$model1[0]['customer_email'];  
            }
            
            $data['call_back'][] = array(
                'id' => $value->id,
                'cust_first_name' => $cust_first_name,
                'cust_middle_name' =>$cust_middle_name,
                'cust_last_name' => $cust_last_name,
                'call_back_or_actual_date' => $value->call_back_or_actual_date,
               'type_of_activity' =>"Call",
                'cust_mobile1' => $cust_mobile1,
                'cust_email1' => $cust_email1,
                'customer_id' => $customer_id,
               
              
            );
        }
       
       
         foreach ($modelactivityappointment as $value) {
              /*else{
                   
                   $model1  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$lead_customer_id));
           $cust_first_name=$model1[0]['customer_first_name'];
            $cust_middle_name=$model1[0]['customer_middle_name'];
             $cust_last_name=$model1[0]['customer_last_name'];
              $cust_mobile1=$model1[0]['customer_mobile_number'];
               $cust_email1=$model1[0]['customer_email'];
                   
               }*/
             $customer_id=$value->customer_id;
            if($customer_id > 0){
            $model1  = Customer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['cust_first_name'];
            $cust_middle_name=$model1[0]['cust_middle_name'];
             $cust_last_name=$model1[0]['cust_last_name'];
              $cust_mobile1=$model1[0]['cust_mobile1'];
               $cust_email1=$model1[0]['cust_email1'];
                
            }else
            {
                 $customer_id=$value->lead_customer_id;
               $model1  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['customer_first_name'];
            $cust_middle_name=$model1[0]['customer_middle_name'];
             $cust_last_name=$model1[0]['customer_last_name'];
              $cust_mobile1=$model1[0]['customer_mobile_number'];
               $cust_email1=$model1[0]['customer_email'];  
            }
            $data['plan_date'][] = array(
                'id' => $value->id,
                'cust_first_name' => $cust_first_name,
                'cust_middle_name' =>$cust_middle_name,
                'cust_last_name' => $cust_last_name,
               
               'type_of_activity' =>"App",
               'cust_mobile1' => $cust_mobile1,
                'cust_email1' => $cust_email1,
                'created_datetime' => date("d-m-Y h:i a", strtotime($value->created_datetime)),
                'call_or_plan_date_time' => $value->call_or_plan_date_time,
                'customer_id' => $customer_id,
              
            );
        }

         foreach ($modelactivityvisit as $value) {
             $customer_id=$value->customer_id;
            if($customer_id > 0){
            $model1  = Customer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['cust_first_name'];
            $cust_middle_name=$model1[0]['cust_middle_name'];
             $cust_last_name=$model1[0]['cust_last_name'];
              $cust_mobile1=$model1[0]['cust_mobile1'];
               $cust_email1=$model1[0]['cust_email1'];
                
            }else
            {
                 $customer_id=$value->lead_customer_id;
               $model1  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['customer_first_name'];
            $cust_middle_name=$model1[0]['customer_middle_name'];
             $cust_last_name=$model1[0]['customer_last_name'];
              $cust_mobile1=$model1[0]['customer_mobile_number'];
               $cust_email1=$model1[0]['customer_email'];  
            }
            $data['plan_date'][] = array(
                'id' => $value->id,
               'cust_first_name' => $cust_first_name,
                'cust_middle_name' =>$cust_middle_name,
                'cust_last_name' => $cust_last_name,
               
               'type_of_activity' =>"JFV",
              'cust_mobile1' => $cust_mobile1,
                'cust_email1' => $cust_email1,
                'created_datetime' => date("d-m-Y h:i a", strtotime($value->created_datetime)),
                'call_or_plan_date_time' => $value->call_or_plan_date_time,
                'customer_id' => $customer_id,
              
            );
        }
        //factfind
         foreach ($modelactivityfactfind as $value) {
            $customer_id=$value->customer_id;
            if($customer_id > 0){
            $model1  = Customer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['cust_first_name'];
            $cust_middle_name=$model1[0]['cust_middle_name'];
             $cust_last_name=$model1[0]['cust_last_name'];
              $cust_mobile1=$model1[0]['cust_mobile1'];
               $cust_email1=$model1[0]['cust_email1'];
                
            }else
            {
                 $customer_id=$value->lead_customer_id;
               $model1  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['customer_first_name'];
            $cust_middle_name=$model1[0]['customer_middle_name'];
             $cust_last_name=$model1[0]['customer_last_name'];
              $cust_mobile1=$model1[0]['customer_mobile_number'];
               $cust_email1=$model1[0]['customer_email'];  
            }
            
            $data['actual_date'][] = array(
                'id' => $value->id,
               'cust_first_name' => $cust_first_name,
                'cust_middle_name' =>$cust_middle_name,
                'cust_last_name' => $cust_last_name,
               
               'type_of_activity' =>"FF",
              'cust_mobile1' => $cust_mobile1,
                'cust_email1' => $cust_email1,
                'call_back_or_actual_date' => $value->call_back_or_actual_date,
                'customer_id' => $customer_id,
              
            );
        }

//presentation
 foreach ($modelactivitypresentation as $value) {
            $customer_id=$value->customer_id;
            if($customer_id > 0){
            $model1  = Customer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['cust_first_name'];
            $cust_middle_name=$model1[0]['cust_middle_name'];
             $cust_last_name=$model1[0]['cust_last_name'];
              $cust_mobile1=$model1[0]['cust_mobile1'];
               $cust_email1=$model1[0]['cust_email1'];
                
            }else
            {
                 $customer_id=$value->lead_customer_id;
               $model1  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['customer_first_name'];
            $cust_middle_name=$model1[0]['customer_middle_name'];
             $cust_last_name=$model1[0]['customer_last_name'];
              $cust_mobile1=$model1[0]['customer_mobile_number'];
               $cust_email1=$model1[0]['customer_email'];  
            }
            
            $data['actual_date'][] = array(
                'id' => $value->id,
               'cust_first_name' => $cust_first_name,
                'cust_middle_name' =>$cust_middle_name,
                'cust_last_name' => $cust_last_name,
               
               'type_of_activity' =>"Presentation",
              'cust_mobile1' => $cust_mobile1,
                'cust_email1' => $cust_email1,
                'call_back_or_actual_date' => $value->call_back_or_actual_date,
                'customer_id' => $customer_id,
              
            );
        }

//application

 foreach ($modelactivityapplication as $value) {
            $customer_id=$value->customer_id;
            if($customer_id > 0){
            $model1  = Customer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['cust_first_name'];
            $cust_middle_name=$model1[0]['cust_middle_name'];
             $cust_last_name=$model1[0]['cust_last_name'];
              $cust_mobile1=$model1[0]['cust_mobile1'];
               $cust_email1=$model1[0]['cust_email1'];
                
            }else
            {
                 $customer_id=$value->lead_customer_id;
               $model1  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['customer_first_name'];
            $cust_middle_name=$model1[0]['customer_middle_name'];
             $cust_last_name=$model1[0]['customer_last_name'];
              $cust_mobile1=$model1[0]['customer_mobile_number'];
               $cust_email1=$model1[0]['customer_email'];  
            }
            
            $data['actual_date'][] = array(
                'id' => $value->id,
               'cust_first_name' => $cust_first_name,
                'cust_middle_name' =>$cust_middle_name,
                'cust_last_name' => $cust_last_name,
               
               'type_of_activity' =>"Application",
              'cust_mobile1' => $cust_mobile1,
                'cust_email1' => $cust_email1,
                'call_back_or_actual_date' => $value->call_back_or_actual_date,
                'customer_id' => $customer_id,
              
            );
        }

        
        
        //Review
         foreach ($modelactivityreview as $value) {
            $customer_id=$value->customer_id;
            if($customer_id > 0){
            $model1  = Customer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['cust_first_name'];
            $cust_middle_name=$model1[0]['cust_middle_name'];
             $cust_last_name=$model1[0]['cust_last_name'];
              $cust_mobile1=$model1[0]['cust_mobile1'];
               $cust_email1=$model1[0]['cust_email1'];
                
            }else
            {
                 $customer_id=$value->lead_customer_id;
               $model1  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$customer_id));
           $cust_first_name=$model1[0]['customer_first_name'];
            $cust_middle_name=$model1[0]['customer_middle_name'];
             $cust_last_name=$model1[0]['customer_last_name'];
              $cust_mobile1=$model1[0]['customer_mobile_number'];
               $cust_email1=$model1[0]['customer_email'];  
            }
            
            $data['actual_date'][] = array(
                'id' => $value->id,
               'cust_first_name' => $cust_first_name,
                'cust_middle_name' =>$cust_middle_name,
                'cust_last_name' => $cust_last_name,
               
               'type_of_activity' =>"RM",
              'cust_mobile1' => $cust_mobile1,
                'cust_email1' => $cust_email1,
                'call_back_or_actual_date' => $value->call_back_or_actual_date,
                'customer_id' => $customer_id,
              
            );
        }

    
        echo json_encode($data);
         //'echo <pre>';print_r($data); 'echo <pre>';
             }else{
            echo $this->getResponse(800);
        }
         
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    
    
       public function actionSaveCustomerPriorities() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
         date_default_timezone_set("Asia/Dubai");
         $model = new CustomerPriorities();
         $json = array();
          $id=$_GET['id'];
        // print_r($data);exit;
        $date = date('Y-m-d');
    //  $id   = $data->id;
        $customer_id     =   $data->customer_id;
        $welfare_priority    =   $data->welfare_priority;
        $welfare_required     =   $data->welfare_required;
        
      $welfare_cur_provision  =   $data->welfare_cur_provision;
        $welfare_short_fall         =   $data->welfare_short_fall;
        $education_priority  =   $data->education_priority;
        $education_required     =   $data->education_required;
        $education_cur_provision      =   $data->education_cur_provision;
        $education_short_fall       =   $data->education_short_fall;
        $dream_priority     =   $data->dream_priority;
        $dream_required      =   $data->dream_required;
        $dream_cur_provision =   $data->dream_cur_provision; 
        $dream_short_fall     =   $data->dream_short_fall;
        $finance_priority     =   $data->finance_priority;
        $finance_required =   $data->finance_required;
        $finance_cur_provision   =   $data->finance_cur_provision;
        $finance_short_fall  =   $data->finance_short_fall;
      //  $start_date       =   $data->start_date;
        $condition = " t.start_date ='" . $date . "' AND  t.customer_id ='" . $customer_id . "'";
         $modelpriorities = CustomerPriorities::model()->find($condition);
        if ($modelpriorities->id > 0) {
             $pid = $modelpriorities['id'];
    
       
            $model = $model->findByPK($pid);
            $model->updated_by = $user_id;
            $model->updated_date_time = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_date_time = date('Y-m-d H:i:s');
          $model->start_date = date('Y-m-d');
            $scene = 'new';
        }
       


       $model->customer_id = $customer_id;
       $model->fa_welfare_priority = $welfare_priority;
        $model->fa_welfare_required = $welfare_required;
        $model->fa_welfare_cur_provision = $welfare_cur_provision;   
     $model->fa_welfare_short_fall = $welfare_short_fall;
        $model->ch_education_priority = $education_priority;
        $model->ch_education_required = $education_required;
        $model->ch_education_cur_provision = $education_cur_provision;
        $model->ch_education_short_fall = $education_short_fall;
        $model->asp_dream_priority = $dream_priority;
        $model->asp_dream_required = $dream_required;
        $model->asp_dream_cur_provision = $dream_cur_provision; 
        $model->asp_dream_short_fall = $dream_short_fall; 
        $model->ret_finance_priority = $finance_priority;
        $model->ret_finance_required = $finance_required;
        $model->ret_finance_cur_provision= $finance_cur_provision;
        $model->ret_finance_short_fall = $finance_short_fall;
      //  $model->start_date = $start_date;
        
               
               
    
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
         //  $json_array['customer_id'] = $model->id;
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
         $json_array['status'] = "failed";
            echo json_encode($json_array);
        } 
             }
      else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }        
    
    }
   
    
    public function actionLogin(){
        
        $json = file_get_contents('php://input');
        $data = json_decode($json);
       
        $username = $data->username;
        $password = $data->password;
        $company_code = $data->company_code;
        
        $username = strtolower($username);
        //$company_id = MasCompany::getCompanyId($company_code);
        $company_id  = MasCompany::model()->find(array('condition' => 'company_code = "'.$company_code.'"'))->id; 
        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password = crypt($password, $salt);
        
        $user = User::model()->find('LOWER(username)=? AND isActive=? AND company_id=?', array($username, 'Y',$company_id));
        if ($user == null){
            $jsonData['status'] = 'error = '.$password;
            $jsonData['error_msg'] = 'Incorrect Username';
        }
        else if ($user->password != $password){
            $jsonData['status'] = 'error = '.$password;
            $jsonData['error_msg'] = 'Incorrect Password';
        }
        else {
            $idd= $user->id;
              $modeluser = new user;
              $modeluser = $modeluser->findByPK($idd);
              $modeluser->app_update_user_status = 'N';
              $modeluser->save(false);
            $jsonData['status'] = 'success';
            $jsonData['login_id'] = $user->id;
            $jsonData['first_name'] = $user->first_name;
            $jsonData['last_name'] = $user->last_name;
            $jsonData['updated_status'] = $modeluser->app_update_user_status;
            $jsonData['token'] = "insurancegr";
            
          
        }
        
        
        echo json_encode($jsonData);
        
        
    }
    
    
      public function actionSavedependants() {
      
$token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
        date_default_timezone_set("Asia/Dubai");
         $model = new CustomerDependants();
          $modelmain = new Customer();
         $json = array();
        
        // print_r($data);exit;
        
    //  $id   = $data->id;
        $customer_id    =   $data->customer_id;
        $dependant_name    =   $data->dependant_name;
        $relationship      =   $data->relationship;
         $dependant_date_of_birth  =   $data->dependant_date_of_birth;
         
         $spouse_first_name    =   $data->spouse_first_name;
        $spouse_middle_name   =   $data->spouse_middle_name;
        $spouse_last_name     =   $data->spouse_last_name;
         $spouse_date_of_birth  =   $data->spouse_date_of_birth;
        
      //print_r($spouse_date_of_birth);exit;
       
      // $model->attributes = $datas['CustomerApp'];
      if($spouse_first_name !=""){
      $modelmain = $modelmain->findByPK($customer_id);
      $modelmain->cust_spouse_first_name = $spouse_first_name;
        $modelmain->cust_spouse_middle_name = $spouse_middle_name;
        $modelmain->cust_spouse_last_name = $spouse_last_name;
        
        if ($spouse_date_of_birth != '') {
            $modelmain->cust_spouse_date_of_birth = str_replace('/', '-', $spouse_date_of_birth);
            $modelmain->cust_spouse_date_of_birth = date("Y-m-d", strtotime($spouse_date_of_birth));
        }}
      
       $model->customer_id = $customer_id;
        $model->dependant_name = $dependant_name;
        $model->relationship = $relationship;
       
               
     if ($dependant_date_of_birth != '') {
            $model->dependant_date_of_birth = str_replace('/', '-', $dependant_date_of_birth);
            $model->dependant_date_of_birth = date("Y-m-d", strtotime($dependant_date_of_birth));
        }
        $valid = $model->validate();
        if ($valid) {
     $modelmain->save();
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
        $json_array['status'] = "failed";
            echo json_encode($json_array);
              
       
                   
    }
         }
         
        
         
          else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
      }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    //leads
    
    
     public function actionSaveleads() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             if($user_id > 0){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
        date_default_timezone_set("Asia/Dubai");
         $model = new LeadCustomer();
         $json = array();
          $id=$_GET['id'];
      



        $first_name     =   $data->first_name;
        $middle_name    =   $data->middle_name;
        $last_name      =   $data->last_name;
        $refers  =   $data->refers;
        $remarks        =   $data->remarks;
        $mobile  =   $data->mobile;
        $email     =   $data->email;
        $status       =   $data->status;
        $prospect_source        =   $data->prospect_source;
        $country  =  $data->country;
    //  print_r($cust_marital_status);exit;
        if ($id > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_date_time = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_date_time = date('Y-m-d H:i:s');
           
            $scene = 'new';
        }
    
        $model->customer_first_name = $first_name;
        $model->customer_middle_name = $middle_name;
        $model->customer_last_name = $last_name;   
        $model->referred_by = $refers;
        $model->remarks = $remarks;
        $model->customer_mobile_number = $mobile;
        $model->customer_email = $email;
        $model->status = $status;
        $model->customer_source_prospect = $prospect_source;
         $model->customer_country_id = $country;
       
               
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
        // $json_array['lead_id'] = $model->id;
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          // $cust_mobile1 = $cust_mobile1;
      $json_array['status'] = "Failed";
            echo json_encode($json_array);
                       
        } 
             } 
        
         
          else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
         }
         
        else
      {
            echo $this->getResponse(301);
        }             
    
    }
    
    public function actiongetLeads() {
        $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
       //  $id=$_GET['id'];
         date_default_timezone_set("Asia/Dubai");
          $models  = LeadCustomer::model()->findAll(array('condition'=>'isActive="Y" AND created_by ='.$user_id,'order' => 'customer_first_name,customer_last_name ASC'));
       
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            
   
           
             $coun_name=$value->customer_country_id;
            $model3 = MasCountry::model()->findAll(array('condition'=>'id=' .$coun_name));
           $con_name=$model3[0]['country_name'];
           $createddby=$value->created_by;
            $model1  = User::model()->findAll(array('condition'=>'id=' .$createddby));
         
         $created_byy=  "".$model1[0]['first_name']." ".$model1[0]['last_name'];
           
           
           
            $data['data'][] = array(
                'id' => $value->id,
                'first_name' => $value->customer_first_name,
                'middle_name' => $value->customer_middle_name,
                'last_name' => $value->customer_last_name,
                'country_id' => $con_name,
                'mobile_number' => $value->customer_mobile_number,
                'customer_email' => $value->customer_email,
                'prospect_source' => $value->customer_source_prospect,
                'remarks' => $value->remarks,
                'status' => $value->status,
                'referred_by' => $value->referred_by,
                'created_by' => $created_byy,
                
               
               
               
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    public function actiongetLeadsbyid() {
        $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
          if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
         
      //  $id=9;
        // print_r($id);exit;
       date_default_timezone_set("Asia/Dubai");
          $models  = LeadCustomer::model()->findAll(array('condition'=>'id=' .$id));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
        
             $coun_name=$value->customer_country_id;
            $model3 = MasCountry::model()->findAll(array('condition'=>'id=' .$coun_name));
           $con_name=$model3[0]['country_name'];
           $createddby=$value->created_by;
            $model1  = User::model()->findAll(array('condition'=>'id=' .$createddby));
         
         $created_byy=  "".$model1[0]['first_name']." ".$model1[0]['last_name'];
           
           
           
            $data['data'][] = array(
                'id' => $value->id,
                'first_name' => $value->customer_first_name,
                'middle_name' => $value->customer_middle_name,
                'last_name' => $value->customer_last_name,
                'country_id' => $con_name,
                'mobile_number' => $value->customer_mobile_number,
                'customer_email' => $value->customer_email,
                'prospect_source' => $value->customer_source_prospect,
                'remarks' => $value->remarks,
                'status' => $value->status,
                'referred_by' => $value->referred_by,
                'created_by' => $created_byy,
                
               
               
               
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
         
      else{
            echo $this->getResponse(301);
        }
    }
    
    
      public function actionSaveLeadscallactivity() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
           if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
         
        $idd=0;
        
    //  $id   = $data->id;
     if($data->call_time != ""){
     $activity_call_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->call_time)));
     }
     if($data->call_back_time != ""){
      $activity_call_back_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->call_back_time)));
     }
     if($data->call_date != ""){
        $activity_call_date     =   $data->call_date;
     }
       if($data->call_back_date != ""){
        $activity_call_back_date     =   $data->call_back_date;
       }
       // print_r($activity_call_time);print_r($activity_call_back_time);exit;
     
        $activity_notes        =   $data->notes;
        
       $activity_customer_id  =   $id;
        if($activity_call_date != "" && $activity_call_time != ""){
       $call_date_time = date('Y-m-d H:i:s', strtotime("$activity_call_date $activity_call_time"));
        } if($activity_call_back_date != "" && $activity_call_back_time != ""){
        $callback_date_time = date('Y-m-d H:i:s', strtotime("$activity_call_back_date $activity_call_back_time"));
        }
     // print_r($callback_date_time);exit;
        if ($idd > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
            $scene = 'new';
        }
      // $model->attributes = $datas['Activity'];
       $model->lead_customer_id = $activity_customer_id;
       $model->type_of_activity=1;
       
        $model->call_or_plan_date_time = $call_date_time;
        $model->call_back_or_actual_date = $callback_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        }
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
                 
    }
    
    
    
    
     public function actionSaveLeadsappointment() {
      $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      //  print_r($json);exit;
      date_default_timezone_set("Asia/Dubai");
         $model = new Activity();
         $json = array();
           if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        // print_r($id);exit;
        $idd=0;
        
    //  $id   = $data->id;
    $planned_time=$data->planned_time;
       $actual_time=$data->actual_time;
       $actual_date= $data->actual_date;
        $planned_date= $data->planned_date;
    if($planned_time !=""){ 
     $activity_planned_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->planned_time)));
    }
     if($actual_time != ""){
      $activity_actual_time  = date("H:i:s", strtotime(str_replace(' ', '', $data->actual_time)));
     }
      if($planned_date != ""){
        $activity_planned_date     =   $data->planned_date;
      }
      if($actual_date != ""){
        $activity_actual_date     =   $data->actual_date;
      }
       // print_r($activity_call_time);print_r($activity_call_back_time);exit;
     
        $activity_notes        =   $data->notes;
        $duration = $data->duration;
       $activity_customer_id  =   $id;
        if($activity_planned_date !="" && $activity_planned_time!=""){
       $plan_date_time = date('Y-m-d H:i:s', strtotime("$activity_planned_date $activity_planned_time"));
        }
         if($activity_actual_date !="" && $activity_actual_time!=""){
        $actual_date_time = date('Y-m-d H:i:s', strtotime("$activity_actual_date $activity_actual_time"));
         }
    //  print_r($cust_res_address);exit;
        if ($idd > 0) {
            $model = $model->findByPK($id);
            $model->updated_by = $user_id;
            $model->updated_datetime = date('Y-m-d H:i:s');
            $scene = 'update';
        } else {
            $model->created_by = $user_id;
            $model->created_datetime = date('Y-m-d H:i:s');
           
            $scene = 'new';
        }
       $model->attributes = $datas['Activity'];
       $model->lead_customer_id = $activity_customer_id;
       $model->type_of_activity=2;
       $model->duration=$duration;
        $model->call_or_plan_date_time = $plan_date_time;
        $model->call_back_or_actual_date = $actual_date_time;
        $model->activity_notes = $activity_notes;   
     
     
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
        
                 
    }
    
    public function actiongetLeadsActivityhistory() {
        $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
          if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
       
          $models  = Activity::model()->findAll(array('condition'=>'isActive="Y" AND lead_customer_id =' .$id,'order' => 'call_back_or_actual_date DESC'));
         
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            
            $createddby=$value->created_by;
            $model1  = User::model()->findAll(array('condition'=>'id=' .$createddby));
         
         $created_byy=  "".$model1[0]['first_name']." ".$model1[0]['last_name'];
        
            $activity=$value->type_of_activity;
            if($activity == 1)
            {
                $activityy="Call";
            }
             if($activity == 2)
            {
                $activityy="Appointment";
            }
             $calll_date = '';
            $calll_time ='';
            $actual_date='';
            $actual_time='';
           $actual_time_date='';
            $call_time_date='';
            if($value->call_or_plan_date_time !='0000-00-00 00:00:00' AND $value->call_or_plan_date_time !='1970-01-01 00:00:00' ){
             $calll_date=date('d-m-Y',strtotime($value->call_or_plan_date_time));
             $calll_time=date('H:i a',strtotime($value->call_or_plan_date_time));
            $call_time_date=date('d-m-Y h:i a ', strtotime($value->call_or_plan_date_time));
            }if($value->call_back_or_actual_date !='0000-00-00 00:00:00' AND $value->call_back_or_actual_date !='1970-01-01 00:00:00' ){
              $actual_date=date('d-m-Y',strtotime($value->call_back_or_actual_date));
             $actual_time=date('H:i a',strtotime($value->call_back_or_actual_date));
              $actual_time_date=date('d-m-Y h:i a', strtotime($value->call_back_or_actual_date));
            
            }
           
             
            $data['data'][] = array(
                'id' => $value->id,
                'type_of_activity' => $activityy,
                'call_or_plan_date_time' => $call_time_date,
                'call_back_or_actual_date' =>$actual_time_date,
                'call_or_plan_date'=>$calll_date,
                'call_or_plan_time'=>$calll_time,
                'callback_or_actual_date'=>$actual_date,
                'callback_or_actual_time'=>$actual_time,
                'activity_notes' => $value->activity_notes,
                 'created_by' => $created_byy,
                'created_datetime' =>date('d-m-Y h:i a', strtotime($value->created_datetime)),
               
                
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    public function actiongetDependantslist() {
        $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
          $models  = Customer::model()->findAll(array('condition'=>'cust_spouse_first_name!="" AND id ='.$id));
          $depenmodels  = CustomerDependants::model()->findAll(array('condition'=>'customer_id ='.$id));
         //print_r($models);exit;
        $count=count($models);//echo $count;exit; 
        $data = array();
        $data['status'] = 'success';
       // $data['data'] = array();
        $data['spouse'] = array();
        $data['dependant'] = array();
        if($count != 0){
       $data['spouse'][] = array(
                
               'spouse_first_name' => $models[0]['cust_spouse_first_name'],
              'spouse_middle_name' =>  $models[0]['cust_spouse_middle_name'],
              'spouse_last_name' =>   $models[0]['cust_spouse_last_name'],
               'spouse_date_of_birth'=>date('d-m-Y', strtotime($models[0]['cust_spouse_date_of_birth'])),
                
            );}
        foreach ($depenmodels as $value) {
            
            $data['dependant'][] = array(
                'id' => $value->id,
                'dependant_name' => $value->dependant_name,
                'relationship' => $value->relationship,
                'dependant_date_of_birth' => date("d-m-Y", strtotime($value->dependant_date_of_birth)),
                
            );
        }
        
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
    ////////////priority list by date
    
     public function actiongetPrioritylistbydate() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){

         
         $date = Yii::app()->request->getParam('date');
         $id = Yii::app()->request->getParam('id');
         $maindate=date("d-m-Y", strtotime($date));
         if($date != "" && $id !=""){
       
        $condition = ' 1=1 AND DATE_FORMAT(t.start_date,"%d-%m-%Y")="'.$maindate.'" AND t.customer_id ="'.$id.'"';
        $models = CustomerPriorities::model()->findAll(array('condition'=>$condition,'order'=>' DATE_FORMAT(start_date,"%d-%m-%Y") ASC'));
         }else if($date == "" && $id != ""){
          //print_r($id);exit;
          $con = ' 1=1 AND t.customer_id ="'.$id.'"';
             $modeldate = CustomerPriorities::model()->findAll(array('condition'=>$con,'limit' => 1,'order'=>' DATE_FORMAT(start_date,"%d-%m-%Y") DESC'));
             $last_date=$modeldate[0]['start_date'];//print_r($last_date);exit;
              $cond = ' 1=1 AND DATE_FORMAT(t.start_date,"%Y-%m-%d")="'.$last_date.'" AND t.customer_id ="'.$id.'"';
              $models = CustomerPriorities::model()->findAll(array('condition'=>$cond));
         }
         $count=count($models);
        $data = array();
        $data['status'] = 'success';
        $data['count'] = $count;
        $data['data'] = array();
        foreach ($models as $value) {
            
     
          /*  $data['data'][] = array(
                'id' => $value->id,
                'customer_id' => $value->customer_id,
                'fa_welfare_priority' => $value->fa_welfare_priority,
                'fa_welfare_required' => $value->fa_welfare_required,
                'fa_welfare_cur_provision' => $value->fa_welfare_cur_provision,
                'fa_welfare_short_fall' => $value->fa_welfare_short_fall,
               'ch_education_priority' => $value->ch_education_priority,
                'ch_education_required' => $value->ch_education_required,
                'ch_education_cur_provision' => $value->ch_education_cur_provision,
                'ch_education_short_fall' => $value->ch_education_short_fall,
                'asp_dream_priority' => $value->asp_dream_priority,
                'asp_dream_required' => $value->asp_dream_required,
                'asp_dream_cur_provision' => $value->asp_dream_cur_provision,
               'asp_dream_short_fall' => $value->asp_dream_short_fall,
                'ret_finance_priority' => $value->ret_finance_priority,
                'ret_finance_required' => $value->ret_finance_required,
                'ret_finance_cur_provision' => $value->ret_finance_cur_provision,
                'ret_finance_short_fall' => $value->ret_finance_short_fall,
                'start_date' => $value->start_date,
               
              
            );*/
            $data['data'][] = array(
                'id' => $value->id,
                'customer_id' => $value->customer_id,
                'type' => 'Family and Welfare',
                'priority' => $value->fa_welfare_priority,
                'required' => $value->fa_welfare_required,
                'cur_provision' => $value->fa_welfare_cur_provision,
                'short_fall' => $value->fa_welfare_short_fall,
                'start_date' => date("d-m-Y", strtotime($value->start_date)),
             );
            $data['data'][] = array(
                'id' => $value->id,
                'customer_id' => $value->customer_id,
                'type' => 'Children University Education',
               'priority' => $value->ch_education_priority,
                'required' => $value->ch_education_required,
                'cur_provision' => $value->ch_education_cur_provision,
                'short_fall' => $value->ch_education_short_fall,
              'start_date' =>date("d-m-Y", strtotime($value->start_date)),
             
            );
            $data['data'][] = array(
                'id' => $value->id,
                'customer_id' => $value->customer_id,
                'type' => 'Aspiration and Dreams' ,
                'priority' => $value->asp_dream_priority,
                'required' => $value->asp_dream_required,
                'cur_provision' => $value->asp_dream_cur_provision,
               'short_fall' => $value->asp_dream_short_fall,
                'start_date' => date("d-m-Y", strtotime($value->start_date)),
               
              
            );
            $data['data'][] = array(
                'id' => $value->id,
                'customer_id' => $value->customer_id,
                'type' => 'Financial Freedom at Retirement' ,
                'priority' => $value->ret_finance_priority,
                'required' => $value->ret_finance_required,
                'cur_provision' => $value->ret_finance_cur_provision,
                'short_fall' => $value->ret_finance_short_fall,
                'start_date' => date("d-m-Y", strtotime($value->start_date)),
               
              
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    public function actiongetDatelistbyid() {
         $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
      if($this->Statusupdate($updated_status)){
         $id = Yii::app()->request->getParam('id');
        
       
        //$condition = ' 1=1 AND DATE_FORMAT(t.start_date,"%d-%m-%Y")="'.$date.'" AND t.customer_id ="'.$id.'"';
        $models = CustomerPriorities::model()->findAll(array('condition'=>'customer_id='.$id));
         
         $count=count($models);
        $data = array();
        $data['status'] = 'success';
        $data['count'] = $count;
        $data['data'] = array();
        foreach ($models as $value) {
            
     
            $data['data'][] = array(
                'id' => $value->id,
                'customer_id' => $value->customer_id,
               
                'start_date' =>date("d-m-Y", strtotime($value->start_date)) ,
               
              
            );
      

        }
       // print_r($data);exit;
        echo json_encode($data);
      }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
     public function actiongetFitnessAndProspectSource() {
       $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        $data = array();
        $data['status'] = 'success';
       $data['fitness'] = array();
       $data['prospect_source'] = array();
       
       // $data['fitness']=array(array("id"=>"1","fitness"=>"Good Health"),array("id"=>"2","fitness"=>"Under Medication"));
       $data['fitness'] = array(1 => 'Good Health',
            2 => 'Under Medication',
            );
        $data['prospect_source'] = array(1 => 'Referral',
            2 => 'Network',
            3 => 'Website',
            4 => 'Advertisement');
        echo json_encode($data);
       // echo '<pre>';print_r($data);echo '<pre>';
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
     public function actiongetMasters() {
       $token = $_SERVER['HTTP__TOKEN']; 
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
    
   
         if( $this->validateToken($token) ){ 
       if($this->Statusupdate($updated_status)){
        $data['status'] = 'success';
              $data['fitness'] = array();
              $data['prospect_source'] = array();
              $data['emirates'] = array();
              $data['country'] = array();
              $data['countrycode'] = array();
               $data['gender'] = array();
              $data['marital_status'] = array();
               $data['customer_status'] = array();
        $data['fitness']=array(array("id"=>"1","fitness"=>"Good Health"),array("id"=>"2","fitness"=>"Under Medication"));
       
        $data['prospect_source'] = array(
        array("id"=>"1","prospect_source" => 'Referral'),
        array("id"=>"2","prospect_source" => 'Network')
        ,array("id"=>"3","prospect_source" => 'Website')
        ,array("id"=>"4","prospect_source" => 'Advertisement'));
        
        
        $emiratesmodels = MasEmirates::model()->findAll(' 1 = 1 ');

        foreach ($emiratesmodels as $value) {
            $data['emirates'][] = array(
                'id' => $value->id,
                'emirate_name' => $value->emirate_name,
                'country_id' => $value->country_id,
                
            );
        }
        
         $countrymodels = MasCountry::model()->findAll(' 1 = 1 ');
 foreach ($countrymodels as $value) {
            $data['country'][] = array(
                'id' => $value->id,
                'country_name' => $value->country_name,
                'country_code' => $value->country_code,
                'phone_code' => $value->phone_code,
                'show_country_list' => $value->show_country_list,
              
            );
           
 }
  $codemodels = MasCountry::model()->findAll(array('condition'=>'show_country_list="Y"'));
  foreach ($codemodels as $value) {
            $data['countrycode'][] = array(
                'id' => $value->id,
                'country_name' => $value->country_name,
                //'country_code' => $value->country_code,
                'phone_code' => $value->phone_code,
                'show_country_list' => $value->show_country_list,
                 'number_digit'=> $value->number_digit,
            );
  } 
  $data['gender']=array(array("id"=>"1","gender"=>"Male"),array("id"=>"2","gender"=>"Female"));
  
  
            $data['marital_status']=array(array("id"=>"1","status"=>"Single"),array("id"=>"2","status"=>"Married"),array("id"=>"3","status"=>"Widow / Widower"),array("id"=>"4","status"=>"Divorced"),array("id"=>"5","status"=>"Separated"));
            
             $data['customer_status']=array(array("id"=>"1","status"=>"Hot"),array("id"=>"2","status"=>"Warm"),array("id"=>"3","status"=>"Cold"));
        echo json_encode($data);
      // echo '<pre>';print_r($data);echo '<pre>';
       }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    
     }
     
      public function actiongetActivityappointment() {
          $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
          $type=2;
            if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
           $condition = " t.type_of_activity ='" . $type . "' AND t.id = '" . $id . "'";
        $models = Activity::model()->findAll(array('condition'=>$condition));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $actual_date = '';
            $actual_time ='';
            if($value->call_back_or_actual_date !='0000-00-00 00:00:00' AND $value->call_back_or_actual_date !='1970-01-01 00:00:00' ){
                $actual_date = date("d-m-Y", strtotime($value->call_back_or_actual_date));
                $actual_time = date("h:i a", strtotime($value->call_back_or_actual_date));
            }
            $data['data'][] = array(
                'id' => $value->id,
                'customer_id' => $value->customer_id,
                'planned_date' => date("d-m-Y", strtotime($value->call_or_plan_date_time)),
                'planned_time' => date("h:i a", strtotime($value->call_or_plan_date_time)),
                'actual_date' => $actual_date,
                 'actual_time' =>$actual_time,
                 'notes' => $value->activity_notes,
                 'created_datetime' => date("d-m-Y h:i a", strtotime($value->created_datetime)),
               
            );
        }
     //  print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
    
          public function actiongetActivityjointvisit() {
              $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
          $type=3;
            if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
           $condition = " t.type_of_activity ='" . $type . "' AND t.id = '" . $id . "'";
        $models = Activity::model()->findAll(array('condition'=>$condition));
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            
             $actual_date = '';
            $actual_time ='';
            $planned_date='';
            $planned_time='';
           
            if($value->call_or_plan_date_time !='0000-00-00 00:00:00' AND $value->call_or_plan_date_time !='1970-01-01 00:00:00' ){
            $planned_date=date('d-m-Y',strtotime($value->call_or_plan_date_time));
             $planned_time=date('h:i a',strtotime($value->call_or_plan_date_time));
            
            }if($value->call_back_or_actual_date !='0000-00-00 00:00:00' AND $value->call_back_or_actual_date !='1970-01-01 00:00:00' ){
              $actual_date=date('d-m-Y',strtotime($value->call_back_or_actual_date));
             $actual_time=date('h:i a',strtotime($value->call_back_or_actual_date));
            
            }
            $data['data'][] = array(
                'id' => $value->id,
                'customer_id' => $value->customer_id,
                'planned_date' => $planned_date,
                'planned_time' => $planned_time,
                'actual_date' => $actual_date,
                 'actual_time' =>$actual_time,
                 'notes' => $value->activity_notes,
                 'created_datetime' => date("d-m-Y h:i a", strtotime($value->created_datetime)),
               
            );
        }
     //  print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
 
     public function actionSaveCrossSales() {
     $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
       $json = file_get_contents('php://input');
        $data = json_decode($json); 
      date_default_timezone_set("Asia/Dubai");
         $model = new CustomerOtherDetails();
         
         $json = array();
           if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
       
        $insurance_type     =   $data->insurance_type;
        $date       =  date('Y-m-d', strtotime($data->date));
       // $user_id        =   $user_id;
        $notes        =   $data->notes;
        $customer_id  =   $id;
     
     
     $condition = " t.loan_type ='" . $insurance_type . "' AND  t.customer_id ='" . $customer_id . "'";
         $modelCrossSales = CustomerOtherDetails::model()->find($condition);
          if ($modelCrossSales->id > 0) {
               $json_array['status'] = "failed";
            echo json_encode($json_array);
          }else{
            
        
      //$model->attributes = $datas['CrossSales'];
    $model->customer_id = $customer_id;
      
        $model->loan_type = $insurance_type;
        $model->expiry_date = $date; 
       
       $model->created_by=$user_id;
        $model->note=$notes;
         
        $valid = $model->validate();
        if ($valid) {
     
         $model->save();
          
            $json_array['status'] = "success";
            echo json_encode($json_array);
               
        
     }
    else {
        
          $json_array['status'] = "failed";
            echo json_encode($json_array);
                       
        } 
         }
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
                 
    }
    
    public function actiongetCrossSales() {
        $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
          if(isset($_GET['id']) && $_GET['id']!=""){
            $id=$_GET['id'];
         }
         else{
              $id=$data->id;
         }
        
        $models = CustomerOtherDetails::model()->findAll(array('condition'=>'customer_id =' .$id));
        
         
        $data = array();
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $insur=$value->loan_type;
            $model1  = MasLoantype::model()->findAll(array('condition'=>'id=' .$insur));
           $insurancetype=$model1[0]['loan_type'];
           
            $data['data'][] = array(
                'id' => $value->id,
                'insurance_type' =>$insurancetype,
                'insurance_id' =>$value->loan_type,
                'customer_id' => $value->customer_id,
                'date' => $value->expiry_date,
                'notes' => $value->note,
              
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
         }
      else{
            echo $this->getResponse(301);
        }
    }
    
   
    public function actiongetInsurance() {
       $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
       
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        $models = MasLoantype::model()->findAll(array('condition'=>'isActive = "Y"'));
        $data = array(); 
        $data['status'] = 'success';
        $data['data'] = array();
        foreach ($models as $value) {
            $data['data'][] = array(
                'id' => $value->id,
                'insurance_type' => $value->loan_type,
               
              
            );
        }
       // print_r($data);exit;
        echo json_encode($data);
             }else{
            echo $this->getResponse(800);
        }
    }
      else{
            echo $this->getResponse(301);
        }
    } 
    
    
    public function actionGetTargetFactFindDetails(){
        $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        $year = Yii::app()->request->getParam('year');
        //print_r($currentyear);
         $id = Yii::app()->request->getParam('id');
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=blueskye_crm_insurance_staging';
        Yii::app()->db->tablePrefix = 'crm_';
        Yii::app()->db->setActive(true);
        

        if(!empty($year)){
            $currentyear = (int) $_GET['year'];
            
        }
        else{
            $currentyear = (int) date('Y');
            
        }
       
       $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
       /*
         $SQL ='SELECT find_fact,
(CASE WHEN MONTH(`call_back_or_actual_date`)=1 THEN COUNT(*)
 END) AS Jan, 
(CASE WHEN MONTH(`call_back_or_actual_date`)=2 THEN COUNT(*)
 END) AS Feb , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=3 THEN COUNT(*)
 END) AS Mar , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=4 THEN COUNT(*)
 END) AS Apr , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=5 THEN COUNT(*)
 END) AS May , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=6 THEN COUNT(*)
 END) AS Jun , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=7 THEN COUNT(*)
 END) AS Jul , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=8 THEN COUNT(*)
 END) AS Aug , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=9 THEN COUNT(*)
 END) AS Sep , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=10 THEN COUNT(*)
 END) AS Oct , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=11 THEN COUNT(*)
 END) AS Nov , 
(CASE WHEN MONTH(`call_back_or_actual_date`)=12 THEN COUNT(*)
 END) AS Dece 
FROM `view_fact_find_details` WHERE user_id='.$id.' AND fact_find_status=2 AND YEAR(`call_back_or_actual_date`)='.$currentyear;
$arr_find_fact_details = Yii::app()->db->createCommand($SQL)->queryAll();
*/
$year  = date('Y');
$month = 12;
if($currentyear == $year){
    $month =  date('m');
}

$SQL    = "SELECT  find_fact as target FROM `view_fact_find_details` WHERE user_id=".$user_id." AND fact_find_status=2 AND (year(call_back_or_actual_date)=".$currentyear.") GROUP BY user_id";
$target = Yii::app()->db->createCommand($SQL)->queryAll();
$findfact  = (int) $target[0]['target'];
//$dataArry['details'] = array('findfact'=>$findfact);

$month_array  = array();

$totalvariance=0;
$totaltarget=0;
for($i=1;$i<=$month;$i++){
   
    
    
    $SQL_achieve = "SELECT count(find_fact) as achieve FROM `view_fact_find_details` WHERE user_id=".$user_id." AND fact_find_status=2 AND (year(call_back_or_actual_date)=".$currentyear." AND month(call_back_or_actual_date)=".$i.") GROUP BY user_id";
    $arr_achieve = Yii::app()->db->createCommand($SQL_achieve)->queryAll();
    $achieve  = (int) $arr_achieve[0]['achieve'];
    $variance= $achieve - $findfact;
    $percentage = ($variance/ $findfact)*100;
   
   
    $data = array();
       
       //$data['details'] = array();
      
$dataArry['status'] = 'success';

$dataArry['details'][] = array(            'target'=>$findfact,
                                'month' => $array_month[$i],
                                'achieve' => $achieve,
                                'variance' => $variance,
                                'variance_percentage' => number_format($percentage,"2")
                            );
                            $totalvariance+=$variance;
                            $totaltarget+=$findfact;
                            $totalachieve+=$achieve;
}
$dataArry['sum'][] = array(
                        'variance'=>$totalvariance,
                        'target'=> $totaltarget,
                        'achieve' =>$totalachieve
                    );

                       
                         echo json_encode($dataArry);
                     //  echo '<pre>'; print_r($dataArry);echo '<pre>';
             }else{
            echo $this->getResponse(800);
        } 
         }
      else{
            echo $this->getResponse(301);
        }
    
    }
   
   
   public function actionGetTargetAppointmentDetails(){
       $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        $year = Yii::app()->request->getParam('year');
        //print_r($currentyear);
        // $id = Yii::app()->request->getParam('$user_id');
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=blueskye_crm_insurance_staging';
        Yii::app()->db->tablePrefix = 'crm_';
        Yii::app()->db->setActive(true);
        

        if(!empty($year)){
            $currentyear = (int) $_GET['year'];
            
        }
        else{
            $currentyear = (int) date('Y');
            
        }
       
       $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
       
   
$year  = date('Y');
$month = 12;
if($currentyear == $year){
    $month =  date('m');
}

$SQL    = "SELECT  appointment as target FROM `view_appointment_details` WHERE user_id=".$user_id." AND (year(call_back_or_actual_date)=".$currentyear.") GROUP BY user_id";
$target = Yii::app()->db->createCommand($SQL)->queryAll();
$appoint  = (int) $target[0]['target'];
//$dataArry['details'] = array('findfact'=>$appoint);

$month_array  = array();
for($i=1;$i<=$month;$i++){
   
    
    
    $SQL_achieve = "SELECT count(appointment) as achieve FROM `view_appointment_details` WHERE user_id=".$user_id." AND (year(call_back_or_actual_date)=".$currentyear." AND month(call_back_or_actual_date)=".$i.") GROUP BY user_id";
    $arr_achieve = Yii::app()->db->createCommand($SQL_achieve)->queryAll();
    $achieve  = (int) $arr_achieve[0]['achieve'];
    $variance=$achieve - $appoint;
    $percentage = ($variance/ $appoint)*100;
    $data = array();
       
       //$data['details'] = array();
      
$dataArry['status'] = 'success';

$dataArry['details'][] = array(            'target'=>$appoint,
                                'month' => $array_month[$i],
                                'achieve' => $achieve,
                                'variance' => $variance,
                                'variance_percentage' => number_format($percentage,"2")
                            );
   
                              $totalvariance+=$variance;
                            $totaltarget+=$appoint;
                             $totalachieve+=$achieve;
}
$dataArry['sum'][] = array(
                        'variance'=>$totalvariance,
                        'target'=> $totaltarget,
                        'achieve' =>$totalachieve
                    );                   
                         echo json_encode($dataArry);
                     //  echo '<pre>'; print_r($dataArry);echo '<pre>';
             }else{
            echo $this->getResponse(800);
        }     
         }
      else{
            echo $this->getResponse(301);
        } 
    
    }
   
   
      public function actionGetTargetPolicyDetails(){
          $token = $_SERVER['HTTP__TOKEN'];
$user_id = $_SERVER['HTTP_USER_ID'];  $updated_status = N;
      // $id=$_GET['id'];
      //  echo $token;  
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
        $year = Yii::app()->request->getParam('year');
        //print_r($currentyear);
         $id = Yii::app()->request->getParam('id');
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=blueskye_crm_insurance_staging';
        Yii::app()->db->tablePrefix = 'crm_';
        Yii::app()->db->setActive(true);
        

        if(!empty($year)){
            $currentyear = (int) $_GET['year'];
            
        }
        else{
            $currentyear = (int) date('Y');
            
        }
       
       $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
       
   
$year  = date('Y');
$month = 12;
if($currentyear == $year){
    $month =  date('m');
}

$SQL    = "SELECT  target_per_month as target FROM `view_policy_target` WHERE user_id=".$user_id." AND (year(start_date)=".$currentyear.") GROUP BY user_id";
$target = Yii::app()->db->createCommand($SQL)->queryAll();
$policy  = (int) $target[0]['target'];
//$dataArry['details'] = array('findfact'=>$policy);

$month_array  = array();
for($i=1;$i<=$month;$i++){
   
    
    
    $SQL_achieve = "SELECT annualized_premium as achieve FROM `view_policy_target` WHERE user_id=".$user_id." AND (year(start_date)=".$currentyear." AND month(start_date)=".$i.") GROUP BY user_id";
    $arr_achieve = Yii::app()->db->createCommand($SQL_achieve)->queryAll();
    $achieve  = (int) $arr_achieve[0]['achieve'];
    $variance=$achieve -$policy;
    $percentage = ($variance/ $policy)*100;
    $data = array();
       
       //$data['details'] = array();
      
$dataArry['status'] = 'success';

$dataArry['details'][] = array(            'target'=>$policy,
                                    'month' => $array_month[$i],
                                'achieve' => $achieve,
                                'variance' => $variance,
                                'variance_percentage' => number_format($percentage,"2")
                            );
   
                           $totalvariance+=$variance;
                            $totaltarget+=$policy;
                            $totalachieve+=$achieve;
}
$dataArry['sum'][] = array(
                        'variance'=>$totalvariance,
                        'target'=> $totaltarget,
                        'achieve' =>$totalachieve
                    );                              
                         echo json_encode($dataArry);
                     //  echo '<pre>'; print_r($dataArry);echo '<pre>';
             }else{
            echo $this->getResponse(800);
        }   
       
         }
      else{
            echo $this->getResponse(301);
        }
    }

    
    public function actionSendMail(){
        $token = $_SERVER['HTTP__TOKEN'];
        //$user_id = $_SERVER['HTTP_USER_ID'];  
        //$token = 'insurancegr';
        //$user_id = (int) 1;  
         if( $this->validateToken($token) ){
            $type = $_REQUEST['type'];
            $customer_id = (int)$_REQUEST['cust_id'];
            $from =$_REQUEST['from'];
            if(!empty($from)){
                 $from = "info@blueskyerp.me";
            }
           
            if($customer_id > 0){
                $model = Customer::model()->findByPk($customer_id);
                $customer_name = $model->cust_first_name;
                if(!empty($model->cust_middle_name)){
                    $customer_name.=" ".$model->cust_middle_name;
                }
                 if(!empty($model->cust_last_name)){
                    $customer_name.=" ".$model->cust_last_name;
                }
                $email = $model->cust_email1;
                if($type==1){//birthday
                    $view="birthday";
                    $title = 'Happy Birthday';
                    $subject = 'Happy Birthday';
                }
                elseif($type==2){//Cheque
                    $view="cheque";
                    $title = 'Policy Reminder';
                    $subject = 'Policy Reminder';
                }
                
                $mailContent = array();
                $mailContent['title'] = $title;
                $mailContent['model'] = $model;
                $message = new YiiMailMessage;
                $message->view = $view;
                $message->setBody(array('mailContent' => $mailContent,'customer_name'=>$customer_name), 'text/html');
                $message->subject = $subject;
                $message->from = $from;
                
                //$message->addto($email);
                //echo "hi";
                //mail("parvez1487@gmail.com","Success","Send mail from localhost using PHP");
                $message->addTo("mereenavinod83@gmail.com");
                if(Yii::app()->mail->send($message)){
                    $jsonData['status'] ="success";
                }
                else{
                    $jsonData['status'] ="failed";
                }
                 echo CJSON::encode($jsonData);
            }
            else{
                 echo $this->getResponse(200);
            }
            
         }
        else{
            echo $this->getResponse(301);
        }
        
        Yii::app()->end();
        /*$token = $_SERVER['HTTP__TOKEN'];
        $user_id = $_SERVER['HTTP_USER_ID'];  
         if( $this->validateToken($token) ){
             
             $input = file_get_contents('php://input'); //

            $datas = json_decode($input, true);
             
            $type = $datas['type'];
            $customer_id = (int) $datas['cust_id'];
            $from =$datas['from'];
            if(empty($from)){
                 $from = "info@blueskyerp.me";
            }
           
            if($customer_id > 0){
                $model = Customer::model()->findByPk($customer_id);
                $customer_name = $model->cust_first_name;
                if(!empty($model->cust_middle_name)){
                    $customer_name.=" ".$model->cust_middle_name;
                }
                 if(!empty($model->cust_last_name)){
                    $customer_name.=" ".$model->cust_last_name;
                }
                $email = $model->cust_email1;
                if($type==1){//birthday
                    $view="birthday";
                    $title = 'Happy Birthday';
                    $subject = 'Happy Birthday';
                }
                elseif($type==2){//cheque
                    $view="cheque";
                    $title = 'Policy Reminder';
                    $subject = 'Policy Reminder';
                }
                
                $mailContent = array();
                $mailContent['title'] = $title;
                $mailContent['model'] = $model;
                $message = new YiiMailMessage;
                $message->view = $view;
                $message->setBody(array('mailContent' => $mailContent,'customer_name'=>$customer_name), 'text/html');
                $message->subject = $subject;
                $message->from = $from;
                
                //$message->addto($email);
                $message->addTo("arunjv@gmail.com");
                $message->addTo("mereenavinod83@gmail.com");
                if(Yii::app()->mail->send($message)){
                    $jsonData['status'] ="success";
                }
                else{
                    $jsonData['status'] ="failed";
                }
                
                echo CJSON::encode($jsonData);
            }
            else{
                 echo $this->getResponse(200);
            }
            
         }
        else{
            echo $this->getResponse(301);
        }
        
        Yii::app()->end();*/
    }
    
   
    
    public function actionGetCustomerPlanDetails(){
        $token = $_SERVER['HTTP__TOKEN'];
        $user_id = $_SERVER['HTTP_USER_ID'];  
        if( $this->validateToken($token) ){
             $customer_id = $_REQUEST['cust_id'];
            $models  = CustomerPlanDetails::model()->findAll(array('condition'=>'customer_id=' .$customer_id,'order' => 'id DESC'));
            
            $data = array();
            $data['status'] = 'success';
            $data['data'] = array();
            foreach ($models as $value) {
                
                 $provider_name1=$value->provider_id;
                $model1 = Provider::model()->findAll(array('condition'=>'id=' .$provider_name1));
               $provider_name=$model1[0]['provider_name'];
                $plan_name1=$value->plan_id;
                $model2  = MasProviderPlans::model()->findAll(array('condition'=>'id=' .$plan_name1));
               $plan_name=$model2[0]['plan_name'];
              
               
               
                $data['data'][] = array(
                    'id' => $value->id,
                    'provider_id' => $provider_name,
                    'plan_id' => $plan_name,
                    'policy_no' => $value->policy_no,
                    'amount' => $value->amount,
                    'payment_mode' => $value->payterm_details->payment_term,
                    'annualized_premium' => $value->annualized_premium,
                    'start_date' => date('d/m/Y',strtotime($value->start_date)),
                    
                );
            }
            
            echo json_encode($data);
        }
        else{
            echo $this->getResponse(301);
        }
    }

    public function actionLeedToContact(){
        $token = $_SERVER['HTTP__TOKEN'];
        $user_id = $_SERVER['HTTP_USER_ID'];
        //$user_id=1;
        $updated_status = N;
         if( $this->validateToken($token) ){
             if($this->Statusupdate($updated_status)){
             
             if($user_id > 0){
      
                $json = file_get_contents('php://input');
                /*$json ='{"first_name":"Test","middle_name":"","last_name":"test","dob":"01/02/2000","gender":"1","company_name":"Bluesky","phone":"455-123-896","mobile":"455-123-896","personal_mail":"test@gargash.com","fitness":"1",
             "smoker":"N","prospect_source":"2","status":"2","notes":"testnotes","country":"1",
             "emirates":"10","nationality":"72","official_mail":"off@gargash.com","residence_address":"testresaddress","po_box":"14444",
             "residence_no":"10fdfdf","marital_status":"2" 
             }';*/
                $data = json_decode($json);
                date_default_timezone_set("Asia/Dubai");
               
                
                $model = new Customer();
                $json = array();
                $cust_first_name     =   $data->first_name;
                $cust_middle_name    =   $data->middle_name;
                $cust_last_name      =   $data->last_name;
                
                $cust_date_of_birth  =   $data->dob;
                $cust_gender         =   $data->gender;
                $cust_company_name  =   $data->company_name;
                $cust_phone_no      =   $data->phone;
                $cust_mobile1       =   $data->mobile;
                $cust_email1        =   $data->personal_mail;
                $cust_health        =   $data->fitness;
                $cust_smoker        =   $data->smoker;
                $cust_prospect_source =   $data->prospect_source; 
                $cust_status       =   $data->status;
                $cust_notes        =   $data->notes;
                $cust_country_code =   $data->country;
                $cust_emirate_id   =   $data->emirates;
                $cust_nationality_id  =   $data->nationality;
                $cust_email2       =   $data->official_mail;
                $cust_res_address  =   $data->residence_address;
                $cust_po_box       =   $data->po_box;
                $cust_res_number   =   $data->residence_no;
                $cust_marital_status  =   $data->marital_status;
                $cust_executive_id  =  $user_id;
               
                $model->created_by = $user_id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->cust_locked_date = date('Y-m-d', strtotime('+90 days', strtotime(date('Y-m-d'))));
                $scene = 'new';
              
               $model->cust_executive_id = $cust_executive_id;
                $model->cust_first_name = $cust_first_name;
                $model->cust_middle_name = $cust_middle_name;
                $model->cust_last_name = $cust_last_name;   
                $model->cust_gender = $cust_gender;
                $model->cust_company_name = $cust_company_name;
                $model->cust_phone_no = $cust_phone_no;
                $model->cust_mobile1 = $cust_mobile1;
                $model->cust_email1 = $cust_email1;
                $model->cust_health = $cust_health;
                $model->cust_smoker = $cust_smoker;
                $model->cust_prospect_source = $cust_prospect_source; 
                $model->cust_res_address = $cust_res_address; 
                $model->cust_status = $cust_status;
                $model->cust_notes = $cust_notes;
                $model->cust_country_code= $cust_country_code;
                $model->cust_emirate_id = $cust_emirate_id;
                $model->cust_nationality_id = $cust_nationality_id;
                $model->cust_email2 = $cust_email2;
                $model->cust_po_box = $cust_po_box;
                $model->cust_res_number = $cust_res_number;
                $model->cust_marital_status = $cust_marital_status;
                       
                       
             if ($cust_date_of_birth != '') {
                    $model->cust_date_of_birth = str_replace('/', '-', $cust_date_of_birth);
                    $model->cust_date_of_birth = date("Y-m-d", strtotime($cust_date_of_birth));
                }
                $valid = $model->validate();
                if ($valid) {
             
                 $model->save();
                 $json_array['customer_id'] = $model->id;
                    $json_array['status'] = "success";
                    echo json_encode($json_array);
                       
                
             }
            else {
                
                  // $cust_mobile1 = $cust_mobile1;
                $cust_mobile1 = str_replace(' ', '', $cust_mobile1);
                $cust_mobile1 = str_replace('+', '', $cust_mobile1);
                $cust_mobile1 = str_replace('-', '', $cust_mobile1);
                $condition = " t.cust_mobile1 ='" . $cust_mobile1 . "' ";
                if ($id != "") {
                    $condition .= " AND t.id !=" . $id;
                }
                $model = Customer::model()->findAll($condition);
                if ($model!=null) {
                     $error1 = array('status' => 'Failed' ,'cust_mobile1'=>'Mobile Number Already Exist');
                  
                            echo json_encode($error1);
                               
                } 
                
                   
    } 
             }
     else{
            echo $this->getResponse(201);
        }
             }else{
            echo $this->getResponse(800);
        }
                 
             }
      else{
            echo $this->getResponse(301);
        }
    }

    public function actiontestmail(){
        $to       = 'jobindas82@gmail.com';
        $subject  = 'Testing sendmail.exe';
        $message  = 'Hi, you just received an email using sendmail!';
        $headers  = 'From: info@blueskyerp.me' . "\r\n" .
                    'MIME-Version: 1.0' . "\r\n" .
                    'Content-type: text/html; charset=utf-8';
        if(mail($to, $subject, $message, $headers))
            echo "Email sent";
        else
            echo "Email sending failed";
    }
   
}
