<?php

class ReportsController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','LoadMasterReportFilter','GetCustomerDetails','loadactivitylist','loadcustomerlist', 'loadCustomerPolicy','loadCustomerPolicypending',
                    'GetPlans','loadPayment','loadprioritylist','LoadCommissionLedgerList','LoadcreditcardExpiry','GetCustomerwthcreditcard',
                    'loadexecutivecommission','loadvatdetails','loadexecutivecommissiondetails','loadlogdetails','GetPolicyNumber','loadexpirydetails','LoadFactFindList'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    //Report index page-start
    public function actionIndex() {
        $frm = Yii::app()->request->getParam('frm');
        $this->render('index', array('frm' => $frm));
    }
    //Report index page-end
    public function actionLoadMasterReportFilter() {
        $report_from = Yii::app()->request->getparam('report_from');
        if ($report_from == 'activity_list') {
            $this->renderPartial('filter_activity_list', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'customer_list') {
            $this->renderPartial('filter_customer_list', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'customer_policy'){
             $this->renderPartial('filter_customer_policy', array('report_from' => $report_from), false, true);
        }
          else if ($report_from == 'customer_policy_pending'){
             $this->renderPartial('filter_customer_policy_pending', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'customer_payment'){
             $this->renderPartial('filter_customer_payment', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'customer_priority'){
             $this->renderPartial('filter_customer_priority', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'commission_ledger'){
             $this->renderPartial('filter_commission_ledger', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'credit_card_expiry'){
             $this->renderPartial('filter_credit_card_expiry', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'executive_ledger'){
             $this->renderPartial('filter_executive_ledger', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'vat_report'){
             $this->renderPartial('filter_vat_report', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'executive_commission'){
             $this->renderPartial('filter_executive_commission', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'insurance_log_details'){
             $this->renderPartial('filter_log_details', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'customer_expiry'){
             $this->renderPartial('filter_expiry_details', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'fact_find_list') {
            $this->renderPartial('filter_fact_find_list', array('report_from' => $report_from), false, true);
        }
        else{
            $this->renderPartial('filter_not_found');
        }
    }
    //Customer details for autocomplete-start
    public function actionGetCustomerDetails() {
        $searchTerm = $_GET['term'];
        $condition = '(t.isActive="Y" AND (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND (cust_first_name LIKE "%' . $searchTerm . '%" OR cust_middle_name LIKE "%' . $searchTerm . '%" OR cust_last_name LIKE "%' . $searchTerm . '%"))';
        $model = new Customer();
        $model = $model->findAll(array('condition' => $condition, 'limit' => 200));
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->Fullname;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    //Customer details for autocomplete-end
    public function actionGetPlans(){
        $searchTerm = $_GET['term'];
        $condition = '(plan_name LIKE "%' . $searchTerm . '%")';
        $model = new MasProviderPlans();
        $model = $model->findAll(array('condition' => $condition, 'limit' => 200));
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->plan_name;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    //Loading Activity List-view-Start
    public function actionloadactivitylist() {
        $type= $_POST['type'];
        $customer_id= $_POST['customer_id'];
        $plan_date_from= $_POST['plan_date_from'];
	$plan_date_to= $_POST['plan_date_to'];
        $actual_date_from= $_POST['actual_date_from'];
        $actual_date_to= $_POST['actual_date_to'];
        $user= $_POST['user'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_activity_list', array('type' => $type, 'customer_id' => $customer_id,'actual_date_from' => $actual_date_from, 'actual_date_to' => $actual_date_to, 'plan_date_from' => $plan_date_from, 'plan_date_to' => $plan_date_to, 'user' => $user), false, true);
    }
//Loading Activity List-view-End
//Loading Customer List-view-Start
   public function actionloadcustomerlist() {

        $customer_id= $_POST['customer_id'];
        $policy_taken= $_POST['policy_taken'];
	$prospectus_status= $_POST['prospectus_status'];
        $cust_prospect_source= $_POST['cust_prospect_source'];
        $cust_marital_status= $_POST['cust_marital_status'];
        $cust_health= $_POST['cust_health'];
        $cust_smoker= $_POST['cust_smoker'];
        $cust_customer= $_POST['cust_customer'];

        //echo "ok".$cust_customer;
       // die();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_customer_list', array('customer_id' => $customer_id, 'policy_taken' => $policy_taken,'prospectus_status' => $prospectus_status, 'cust_prospect_source' => $cust_prospect_source, 'cust_marital_status' => $cust_marital_status, 'cust_health' => $cust_health, 'cust_smoker' => $cust_smoker,'cust_customer' => $cust_customer), false, true);
    }
    //Loading Customer List-view-End

    // Loading Customer Policy START
    public function actionloadCustomerPolicy(){
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_customer_policy', $_REQUEST, false, true);
    }

    // Loading Customer Policy END
       // Loading Customer Policy START
    public function actionloadCustomerPolicypending(){
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_customer_policy_pending', $_REQUEST, false, true);
    }

    // Loading Customer Policy END
     // Loading Customer payment START
    public function actionloadPayment(){
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_customer_payment', $_REQUEST, false, true);
    }
    // Loading Customer payment END
    //Loading Priority List-view-Start
    public function actionloadprioritylist() {
        
        $cust_id= $_POST['cust_id'];
        $priority_from_date= $_POST['priority_from_date'];
	$priority_to_date= $_POST['priority_to_date'];
        $priority_status= $_POST['priority_status'];
        
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_priority_list', array('cust_id' => $cust_id, 'priority_from_date' => $priority_from_date,'priority_to_date' => $priority_to_date, 'priority_status' => $priority_status), false, true);
    }
    //Loading Priority List-view-End
    //Loading CommissionLedger List-view-Start
    public function actionLoadCommissionLedgerList() {
        
        /*$cust_id= $_POST['cust_id'];
        $priority_from_date= $_POST['priority_from_date'];
	$priority_to_date= $_POST['priority_to_date'];
        $priority_status= $_POST['priority_status'];*/
        
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_commissionledger_list', $_REQUEST, false, true);
    }
    //Loading CommissionLedger List-view-End
    //Loading Credit card expiry List-view-Start
    public function actionLoadcreditcardExpiry() {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_creditcard_expiry_list', $_REQUEST, false, true);
    }
    //Loading Credit card expiry List-view-End
    
    //Customer details for autocomplete-start
    public function actionGetCustomerwthcreditcard() {
        $searchTerm = $_GET['term'];
        $condition = '(payment_type="2" and cus_details.isActive="Y" AND (cus_details.cust_executive_id="'.Yii::app()->user->id.'" OR cus_details.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND (cus_details.cust_first_name LIKE "%' . $searchTerm . '%" OR cus_details.cust_middle_name LIKE "%' . $searchTerm . '%" OR cus_details.cust_last_name LIKE "%' . $searchTerm . '%"))';
        $model = new CustomerPaymentDetails();
        $model = $model->with('cus_details')->findAll(array('condition' => $condition, 'limit' => 200));
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->cus_details->id;
            $data[$i]['label'] = $eachModel->cus_details->Fullname;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    //Customer details for autocomplete-end
    public function actionloadexecutivecommission() {
        
        $customer= $_POST['customer'];
        $from_date= $_POST['from_date'];
	$to_date= $_POST['to_date'];
        $provider= $_POST['provider'];       
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_executive_commission',array('customer'=>$customer,'from_date'=>$from_date,'to_date'=>$to_date,'provider'=>$provider), false, true);
    }
    public function actionloadvatdetails() {        
        $from_date= $_POST['from_date'];
	$to_date= $_POST['to_date'];
        $provider= $_POST['provider'];       
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_vat_details',array('from_date'=>$from_date,'to_date'=>$to_date,'provider'=>$provider), false, true);
    }
    public function actionloadexecutivecommissiondetails() {
        
        $customer= $_POST['customer'];
        $from_date= $_POST['from_date'];
	$to_date= $_POST['to_date'];
        $provider= $_POST['provider'];  
        $executive= $_POST['executive'];  
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_executive_commission_details',array('customer'=>$customer,'executive'=>$executive,'from_date'=>$from_date,'to_date'=>$to_date,'provider'=>$provider), false, true);
    }
    public function actionloadlogdetails() {
        
        $user= $_POST['user'];
        $from_date= $_POST['from_date'];
	$to_date= $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_log_details',array('user'=>$user,'from_date'=>$from_date,'to_date'=>$to_date), false, true);
    }
    //Customer details for autocomplete-start
    public function actionGetPolicyNumber() {
        $searchTerm = $_GET['term'];
        $condition = 'policy_no LIKE "%' . $searchTerm . '%"';
        $model = new CustomerPlanDetails();
        $model = $model->findAll(array('condition' => $condition, 'limit' => 200));
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->policy_no;
            $data[$i]['label'] = $eachModel->policy_no;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    //Customer details for autocomplete-end
    public function actionloadexpirydetails() {
        $from_date= $_POST['from_date'];
	$to_date= $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_expiry_details',array('from_date'=>$from_date,'to_date'=>$to_date), false, true);
    }
    
    //Loading Fact find List-view-Start
    public function actionLoadFactFindList() {
        $customer_id    = $_POST['customer_id'];
        $date_from      = $_POST['date_from'];
	    $date_to        = $_POST['date_to'];
        $user           = $_POST['user'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_fact_find_list', array('customer_id' => $customer_id,'date_from' => $date_from, 'date_to' => $date_to, 'user' => $user), false, true);
    }
    //Loading Activity List-view-End
}
