<?php

class ReportpdfController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('pdfactivitylist', 'CustomerDetails', 'pdfcustomerlist','loadCustomerPolicy','loadCustomerPolicypending', 'loadCustomerPayment', 'pdfprioritylist',
                    'Pdfcommissionledgerlist','pdfcreditcardexpiry','pdfexecutivecommission','pdfvatdetails','pdfexecutivecommissiondetails','pdflogdetails',
                    'pdfexpirydetails','PDFFactFindList'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    //Loading Activity Pdf List-view-Start
    public function actionpdfactivitylist() {
        $type = $_GET['type'];
        $customer_id = $_GET['customer_id'];
        $plan_date_from = $_GET['plan_date_from'];
        $plan_date_to = $_GET['plan_date_to'];
        $actual_date_from = $_GET['actual_date_from'];
        $actual_date_to = $_GET['actual_date_to'];
        $user = $_GET['user'];
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.activity_list', array('type' => $type, 'customer_id' => $customer_id, 'actual_date_from' => $actual_date_from, 'actual_date_to' => $actual_date_to, 'plan_date_from' => $plan_date_from, 'plan_date_to' => $plan_date_to, 'user' => $user), true));
        $mPDF1->Output('activitylist.pdf', 'I');
    }

    public function actionpdfcustomerlist() {


        $customer_id = $_GET['customer_id'];
        $policy_taken = $_GET['policy_taken'];
        $prospectus_status = $_GET['prospectus_status'];
        $cust_prospect_source = $_GET['cust_prospect_source'];
        $cust_marital_status = $_GET['cust_marital_status'];
        $cust_health = $_GET['cust_health'];
        $cust_smoker = $_GET['cust_smoker'];
        $cust_customer = $_GET['cust_customer'];
        // echo "ok".$customer_id;
        //die();
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.customer_list', array('customer_id' => $customer_id, 'policy_taken' => $policy_taken, 'prospectus_status' => $prospectus_status, 'cust_prospect_source' => $cust_prospect_source, 'cust_marital_status' => $cust_marital_status, 'cust_health' => $cust_health, 'cust_smoker' => $cust_smoker, 'cust_customer' => $cust_customer), true));
        $mPDF1->Output('customerlist.pdf', 'I');
    }

    //Loading Activity Pdf List-view-End
    //Loading Activity Pdf List-view-Start
    public function actionCustomerDetails() {
        $id = $_GET['id'];
        $model_customer = Customer::model()->findbyPK($id);
        $model_priority_details = CustomerPriorities::model()->find(array('condition' => 'customer_id="' . $id . '" and isActive="Y"'));
        $model_dependant_details = CustomerDependants::model()->findAll(array('condition' => 'customer_id="' . $id . '"'));
        $model_plan_details = CustomerPlanDetails::model()->findAll(array('condition' => 'customer_id="' . $id . '"'));
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.customer_details', array('model_customer' => $model_customer, 'model_priority_details' => $model_priority_details, 'model_dependant_details' => $model_dependant_details, 'model_plan_details' => $model_plan_details), true));
        $mPDF1->Output($model_customer->Fullname . '.pdf', 'I');
    }

    //Loading Activity Pdf List-view-End
    /// Load Customer Policy START
    public function actionloadCustomerPolicy() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.view_customer_policy', $_GET, true));
        $mPDF1->Output('customerpolicylist.pdf', 'I');
    }

    /// Load Customer Policy END
    
      public function actionloadCustomerPolicypending() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.view_customer_policy_pending', $_GET, true));
        $mPDF1->Output('customerpendingpolicylist.pdf', 'I');
    }

    public function actionloadCustomerPayment() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.view_customer_payment', $_GET, true));
        $mPDF1->Output('customerpolicylist.pdf', 'I');
    }

    public function actionpdfprioritylist() {
        $cust_id = $_GET['cust_id'];
        $priority_from_date = $_GET['priority_from_date'];
        $priority_to_date = $_GET['priority_to_date'];
        $priority_status = $_GET['priority_status'];
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.priority_list', array('cust_id' => $cust_id, 'priority_from_date' => $priority_from_date, 'priority_to_date' => $priority_to_date, 'priority_status' => $priority_status), true));
        $mPDF1->Output('prioritylist.pdf', 'I');
    }

    public function actionPdfcommissionledgerlist() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.commission_list', $_REQUEST ,true));
        $mPDF1->Output('commission_list.pdf', 'I');
    }
    public function actionPdfcreditcardexpiry() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.credit_card_expiry', $_GET, true));
        $mPDF1->Output('creditcardexpirylist.pdf', 'I');
    }
    public function actionpdfexecutivecommission() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.executive_commission', $_GET, true));
        $mPDF1->Output('executivecommissionlist.pdf', 'I');
    }
    public function actionpdfvatdetails() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.vat_details', $_GET, true));
        $mPDF1->Output('vatdetails.pdf', 'I');
    }
    public function actionpdfexecutivecommissiondetails() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.executive_commission_details', $_GET, true));
        $mPDF1->Output('executivecommission.pdf', 'I');
    }
    public function actionpdflogdetails() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.log_details', $_GET, true));
        $mPDF1->Output('logdetails.pdf', 'I');
    }
    public function actionpdfexpirydetails() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.expiry_details', $_GET, true));
        $mPDF1->Output('list.pdf', 'I');
    }
    
     //Loading Activity Pdf List-view-Start
    public function actionPDFFactFindList() {
        $customer_id = $_GET['customer_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        $user = $_GET['user'];
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reportpdf.fact_find_list', array('customer_id' => $customer_id, 'date_from' => $date_from, 'date_to' => $date_to, 'user' => $user), true));
        $mPDF1->Output('factfindlist.pdf', 'I');
    }
}
