<?php

/**

 * Controller is the customized base controller class.

 * All controller classes for this application should extend from this base class.

 */
class Controller extends CController {

    public $layout = 'layout';
    public $menu = array();
    public $breadcrumbs = array();
    public $numberFormat = array('decimals' => 2, 'decimalSeparator' => ',', 'thousandSeparator' => '');

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'TableRo', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Upload', 'UploadProfilePhoto','UploadDocuments','UploadCustomerDocuments','readCSVfile','index'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array('accessControl'); // perform access control for CRUD operations
    }

    public function beforeAction($action) {
        if (isset(Yii::app()->user->company_db_name) && Yii::app()->user->company_db_name != "") {
            $company_db_name = Yii::app()->user->company_db_name;
            Yii::app()->db->setActive(false);
            Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
            Yii::app()->db->tablePrefix = 'crm_';
            Yii::app()->db->setActive(true);
        }
        if (Yii::app()->request->isAjaxRequest)
            $this->layout = false;

        return parent::beforeAction($action);
    }

    public function actionLogin() {
        if (Yii::app()->user->isGuest) {
            if (!Yii::app()->request->isAjaxRequest)
            $this->layout = "login";
            $model = new LoginForm;
            if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
                echo CActiveForm::validate($model);
                Yii::app()->end();
            }
            if (isset($_POST['LoginForm'])) {
                $model->attributes = $_POST['LoginForm'];
                // validate user input and redirect to the previous page if valid

                if ($model->validate() && $model->login()) {
                    if (!Yii::app()->request->isAjaxRequest)
                        $this->redirect(Yii::app()->user->returnUrl);
                    else {                       
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                    }
                } else {
                    if (!Yii::app()->request->isAjaxRequest)
                        $this->redirect(array('site/login'));
                    else {

                        $jsonData['status'] = 'error';

                        echo CJSON::encode($jsonData);
                    }
                }
            } else {
                // display the login form
                if (!Yii::app()->request->isAjaxRequest)
                    $this->render('login', array('model' => $model));

                else {
                    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
                    $this->renderPartial('login', array('model' => $model), false, true);
                }
            }
        } else {
            if (!Yii::app()->request->isAjaxRequest)
                $this->redirect(array('site/index'));
            else {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        }
    }

    /**

     * Logs out the current user and redirect to homepage.

     */
    public function actionLogout() {
        $ip_address=$_SERVER['REMOTE_ADDR'];
        $model_user_logdetails=UserLog::model()->find(array('select'=>'max(id) as id','condition'=>'ip_address="'.$ip_address.'" and user_id="'.Yii::app()->user->id.'" and logout_time="0000-00-00 00:00:00"'));
        if($model_user_logdetails->id>0){
            UserLog::model()->updateByPK($model_user_logdetails->id, array('logout_time' =>date('Y-m-d H:i:s')));
        }
        Yii::app()->user->logout();
        $this->redirect(Yii::app()->homeUrl);
    }

    public function actionForgotpassword() {
        $this->layout = "login";
        $model = new User;
        if (isset($_POST['User'])) {
            $model->attributes = $_POST['User'];
            $model->scenario = 'forgotpassword';
            if ($model->validate()) {
                if (($model = $model->find(array('condition' => 'email="' . $model->email . '"'))) != null) {
                    $session = new CHttpSession;
                    $session->open();
                    $model->auth_code = $session->getSessionID() . time();
                    $model->save(false);
                    $modelMail = new MailForm;
                    $modelMail->subject = "Password recovery";
                    $resetLink = Yii::app()->createAbsoluteurl('site/recover', array('key' => $model->auth_code));
                    $modelMail->message = "Please " . CHtml::link("Click here", $resetLink) . "  or type this link to reset your pasword<br>" . $resetLink;
                    $message = new YiiMailMessage;
                    $message->view = 'mailtemplate';
                    $message->setBody(array('model' => $modelMail), 'text/html');
                    $message->from = Yii::app()->params['adminMail'];
                    $message->addTo($model->email);
                    $message->addTo("test@mailbluesky.com");
                    $message->addCc("copymail@mailbluesky.com");
                    Yii::app()->mail->send($message);
                    Yii::app()->user->setFlash('success', "A mail sent to your inbox, please check it");
                    $this->redirect(array('site/login'));
                } else {
                    $model->addError('email', 'No such user exists');
                }
            }
        }
        $this->render('forgotpassword', array('model' => $model));
    }

    public function actionRecover() {
        $this->layout = "login";
        $model = new User;
        $model->auth_code = $_GET['key'];
        if (($model = $model->find(array('condition' => 'auth_code="' . $model->auth_code . '"'))) != null) {
            if (isset($_POST['User'])) {
                $model->attributes = $_POST['User'];
                $model->scenario = 'reset_password';
                if ($model->validate()) {
                    if (($model = $model->find(array('condition' => 'auth_code="' . $model->auth_code . '"'))) != null) {
                        $model->auth_code = "";
                        $model->save(false);
                        Yii::app()->user->setFlash('success', "Password updated");
                        $this->redirect(array('site/login'));
                    } else {
                        //$this->redirect(array('site/login'));
                        die("Auth code expired!");
                    }
                }
            }
            $this->render('resetpassword', array('model' => $model));
        } else {
            die("Auth code expired!");
        }
    }

    /**

     * This is the action to handle external exceptions.

     */
    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    function CropIfImage($folder, $fileName, $width = 100, $height = 100) {
        $imageCropParams = array(array($width, $height));
        $imagefile = getimagesize($folder . $fileName);
        if (is_array($imagefile)) {
            foreach ($imageCropParams as $eachImageCropParam) {
                $width = $eachImageCropParam[0];
                $height = $eachImageCropParam[1];
                $thumb = Yii::app()->phpThumb->create($folder . '/' . $fileName);
                $thumb->resize($width, $height);
                $thumb->save($folder . '/' . $width . $height . '_' . $fileName);
            }
        }
    }

    public function actionUpload($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
            //chmod($folder, 0755);
        }
        $allowedExtensions = array();
        $sizeLimit = 1 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropIfImage($folder, $fileName, 100, 100);
        echo $return; // it's array
    }

    public function downloadFile($file, $folder) {
        $filename = Yii::app()->getBaseUrl(true) . $folder . $file;
        header('Content-Type: application/octet-stream');
        header("Content-Transfer-Encoding: Binary");
        header("Content-disposition: attachment; filename=\"" . $file . "\"");
        readfile($filename);
    }

    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            if ($contents[1] == "")
                $contents = explode(';', $contents[0]);
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }

    public function actionUploadProfilePhoto($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if (isset($_GET['field_id'])) {

            $field_id = Yii::app()->request->getParam('field_id');
        }
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("jpg", "jpeg", "gif", "png"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $imagename = Yii::app()->basePath . '/../uploads/profilephotos/' . $fileName;
        $imagename_thumb = Yii::app()->basePath . '/../uploads/profilephotos/thumbs/' . $fileName;
        Yii::import("ext.EPhpThumb.EPhpThumb");
        $thumb = new EPhpThumb();
        $thumb->init(); //this is needed
        //chain functions
        $thumb->create($imagename)->resize(100, 100)->save($imagename_thumb);
        echo $return; // it's array
    }

    public function actionUploadDocuments($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if (isset($_GET['field_id'])) {

            $field_id = Yii::app()->request->getParam('field_id');
        }
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("pdf", "doc", "docx", "txt", ".xls", ".xlsx");
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $imagename = Yii::app()->basePath . '/../uploads/documents/' . $fileName;
        echo $return; // it's array
    }

    public function actionUploadCustomerDocuments($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
            //chmod($folder, 0755);
        }
        $allowedExtensions = array("jpg", "png", "doc", "docx", "xls", "xlsx", "pdf", "bmp", "jpeg");
        $sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropIfImage($folder, $fileName, 100, 100);
        echo $return; // it's array
    }
    
    /*     * ******************** Small image upload for Drodown ************** */

    public function actionUploadDropDownImage($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);

            //chmod($folder, 0755);
        }
        $allowedExtensions = array();
        $sizeLimit = 1 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropIfImage($folder, $fileName, 36, 24);
        $result['filename'] = "3624_" . $result['filename'];
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }

    /*     * ******************** Small image upload for Drodown ************** */

    //CSV read-start
    public function readCSVfile($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }

    //CSV read-end
}
