<?php

class MasplanpaymenttermController extends Controller
{
	public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SavePlanPaymentTerm','DeletePlanPaymentTerm'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
    	public function actionIndex()
    	{
    		$this->render('index');
    	}
          public function actionGetList()
        {
                $model=new MasPlanPaymentTerms();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'payment_term'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" AND (payment_term LIKE '%".$searchString."%' OR no_of_times LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model as $row)
                {
                    $div = '';
                    {
                        $div .=   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'masplanpaymentterm/create&id='.$row['id'].'\',\'Edit PlanPaymentTerm Status\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    $rowData[]=array($m,$row['payment_term'],$row['no_of_times'],'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasPlanPaymentTerms();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('add_edit_payment', array('model' => $model), false, false);
        }
  
  
        public function actionSavePlanPaymentTerm()
        {
            $model = new MasPlanPaymentTerms();
            if (isset($_POST['MasPlanPaymentTerms']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasPlanPaymentTerms']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasPlanPaymentTerms']['id'];
                    $model=$model->findByPk($id);  
                }
                $model->attributes=$_POST['MasPlanPaymentTerms'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
}