<?php

class MascommissionschemeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveScheme','View'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    public function actionGetList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $executive_id = $_POST['executive_id'];
        $model = new MasterCommissionSchemes();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'scheme_name',     
            2 => 'executive_total_commission',
            3 => 'executive_commission_without_deferment',
            4 => 'excecutive_deferment_commission',
            5 => 'executive_commission_with_deferment',
            6 => 'executive_quarter_sale_commission',
            7 => 'executive_annual_sale_commission',
            8 => 'manager_total_commision',
            9 => 'manager_with_assitant_commission',
            10 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        /******** First Loading Without Search********/
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (scheme_name LIKE '%" . $searchString . "%' )";
        }             
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        foreach ($model as $row) {
            $div='';
            $model_user_exist = User::model()->find(array('condition' =>'commission_scheme_id="'.$row['id'].'"'));
            if(empty($model_user_exist)){
                $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'mascommissionscheme/create&id=' . $row['id'] . '\',\'Edit Scheme\',\'xl\')"><i class="fa fa-pencil"></i></button>&nbsp;';
            }
            $div .= ' <button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'mascommissionscheme/view&id=' . $row['id'] . '\',\'View Scheme Details\')"><i class="fa fa-eye"></i></button>';
            $rowData[] = array($m, $row->scheme_name,$row->executive_total_commission,$row->executive_commission_without_deferment,$row->excecutive_deferment_commission,$row->executive_commission_with_deferment,$row->executive_quarter_sale_commission,$row->executive_annual_sale_commission,$row->manager_total_commision,$row->manager_with_assitant_commission.'-'.$row->manager_with_assitant_commission, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new MasterCommissionSchemes();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }
    public function actionSaveScheme() {
        $model = new MasterCommissionSchemes();
        if (isset($_POST['MasterCommissionSchemes'])) {           
            if ((int) @$_POST['MasterCommissionSchemes']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasterCommissionSchemes']['id'];
                $model = $model->findByPk($id);
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
             }
            $model->attributes = $_POST['MasterCommissionSchemes'];
            $model->executive_total_commission=(float)$model->executive_commission_without_deferment+(float)$model->executive_quarter_sale_commission+(float)$model->executive_annual_sale_commission;
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionView() {
        $model = new MasterCommissionSchemes();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('view', array('model' => $model), false, false);
    }
}
?>