<?php

class ExcelController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('excelactivitylist', 'excelcustomerlist','loadCustomerPolicy', 'loadCustomerPayment', 'excelpriority','loadCustomerPolicypending'
                    ,'Excelcommissionledgerlist','excelcreditcardexpiry','excelexecutivecommission','excelvatdetails','excelexecutivecommissiondetails',
                    'excellogdetails','excelexpirydetails','excelfactfindlist','Exceldefermentdetails'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    //Loading Activity Excel List-view-Start
    public function actionexcelactivitylist() {
        $type = $_GET['type'];
        $customer_id = $_GET['customer_id'];
        $plan_date_from = $_GET['plan_date_from'];
        $plan_date_to = $_GET['plan_date_to'];
        $actual_date_from = $_GET['actual_date_from'];
        $actual_date_to = $_GET['actual_date_to'];
        $user = $_GET['user'];
        $filename = 'activitylist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('activit_list_excel', array('type' => $type, 'customer_id' => $customer_id, 'actual_date_from' => $actual_date_from, 'actual_date_to' => $actual_date_to, 'plan_date_from' => $plan_date_from, 'plan_date_to' => $plan_date_to, 'user' => $user), false, true);
        Yii::app()->end();
    }

    //Loading Activity Excel List-view-End
    public function actionexcelcustomerlist() {
        $customer_id = $_GET['customer_id'];
        $policy_taken = $_GET['policy_taken'];
        $prospectus_status = $_GET['prospectus_status'];
        $cust_prospect_source = $_GET['cust_prospect_source'];
        $cust_marital_status = $_GET['cust_marital_status'];
        $cust_health = $_GET['cust_health'];
        $cust_smoker = $_GET['cust_smoker'];
        $cust_customer = $_GET['cust_customer'];
        $customer_lock_from_date= $_GET['customer_lock_from_date'];
        $customer_lock_to_date= $_GET['customer_lock_to_date'];
        $filename = 'Customerlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('customer_list_excel', array('customer_id' => $customer_id, 'policy_taken' => $policy_taken, 'prospectus_status' => $prospectus_status, 'cust_prospect_source' => $cust_prospect_source, 'cust_marital_status' => $cust_marital_status, 'cust_health' => $cust_health, 'cust_smoker' => $cust_smoker, 'cust_customer' => $cust_customer,'customer_lock_from_date'=>$customer_lock_from_date,'customer_lock_to_date'=>$customer_lock_to_date), false, true);
        Yii::app()->end();
    }

    // Loading customer policy start
    function actionLoadCustomerPolicy() {
        $filename = 'CustomerPolicylist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('view_customer_policy', $_GET, false, true);
        Yii::app()->end();
    }
    
    function actionLoadCustomerPolicypending() {
        $filename = 'CustomerPolicylist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('view_customer_policy_pending', $_GET, false, true);
        Yii::app()->end();
    }

    // loading customer policy end
    // Start Customer Payment
    public function actionloadCustomerPayment() {
        $filename = 'customer_payment.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('view_customer_payment', $_GET, false, true);
        Yii::app()->end();
    }

    // End Customer Payment
    // Start CustomerPriority
    public function actionexcelpriority() {
        $cust_id = $_GET['cust_id'];
        $priority_from_date = $_GET['priority_from_date'];
        $priority_to_date = $_GET['priority_to_date'];
        $priority_status = $_GET['priority_status'];
        $filename = 'CustomerPrioritylist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('priority_list_excel', array('cust_id' => $cust_id, 'priority_from_date' => $priority_from_date, 'priority_to_date' => $priority_to_date, 'priority_status' => $priority_status), false, true);
        Yii::app()->end();
    }

    // End CustomerPriority

    public function actionExcelcommissionledgerlist() {

        $filename = 'commission_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('commission_list', $_GET, false, true);
        Yii::app()->end();
    }
    // Start Credit card expiry-start
    public function actionexcelcreditcardexpiry() {
        $filename = 'creditcardlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('creditcard_expiry_excel', $_GET, false, true);
        Yii::app()->end();
    }

    // End Credit card expiry-end
    public function actionexcelexecutivecommission() {
        $filename = 'executivecommission.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('executivecommission_excel', $_GET, false, true);
        Yii::app()->end();
    }
    public function actionexcelvatdetails() {
        $filename = 'vatdetails.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('vatdetails_excel', $_GET, false, true);
        Yii::app()->end();
    }
    public function actionexcelexecutivecommissiondetails() {
        $filename = 'executivecommission.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('executivecommissiondetails_excel', $_GET, false, true);
        Yii::app()->end();
    }
    public function actionexcellogdetails() {
        $filename = 'logdetails.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('logdetails_excel', $_GET, false, true);
        Yii::app()->end();
    }
    public function actionexcelexpirydetails() {
        $filename = 'list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('expirydetails_excel', $_GET, false, true);
        Yii::app()->end();
    }
    public function actionExcelFactFindList() {
        $customer_id = $_GET['customer_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        $user = $_GET['user'];
        $filename = 'factfindlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('fact_find_list_excel', array('customer_id' => $customer_id, 'date_from' => $date_from, 'date_to' => $date_to, 'user' => $user), false, true);
        Yii::app()->end();
    }
    public function actionExceldefermentdetails() {
        $user = $_GET['user'];
        $filename = 'deferment_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('deferment_list_excel', array('user' => $user), false, true);
        Yii::app()->end();
    }
}
