<?php
class CommissiondownloadController extends Controller {

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Getlist','downloadexecutivefile','downloadmanagerfile'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }
    
    public function actionGetlist() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $provider_id = $_POST['provider_id'];
        $model = new CommissionUploaded();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'provider_name',
            2 => 'commission_date',
            3 => 'created_by',
            4 => 'created_date_time',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        //$orderBy = $filterColumn . " " . $filterOrder;

        $orderBy = "t.commission_date ASC";
        /******** First Loading Without Search********/
        $condition = 't.commission_calculated="Y"';
        if($provider_id>0){
            $condition.= ' AND t.provider_id="'.$provider_id.'"';
        } 
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.provider_name LIKE '%" . $searchString . "%' )";
        }             
        $count = $model->count(array('condition' => $condition,'group'=>'provider_id'));
        $model = $model->findAll(array('condition' => $condition,'group'=>'provider_id,commission_date', 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        foreach ($model as $row) {
            $button_string='';
            $commission_date='';
            $created_date_time='';
            if($row['commission_date']!='' && $row['commission_date']!='0000-00-00'){
                $commission_date=date_format(date_create($row['commission_date']),'d/m/Y');
            }
            if($row['created_date_time']!='' && $row['created_date_time']!='0000-00-00'){
                $created_date_time=date_format(date_create($row['created_date_time']),'d/m/Y');
            }
            $button_string.= '<a href="?r=commissiondownload/downloadexecutivefile&providerid=' . $row['provider_id'] . '&commission_date=' . $row['commission_date'] . '" title="Download Executive Document" target="_blank"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';
            $button_string.= '<a href="?r=commissiondownload/downloadmanagerfile&providerid=' . $row['provider_id'] . '&commission_date=' . $row['commission_date'] . '" title="Download Manager Document" target="_blank"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';
            $rowData[] = array($m, $row['provider_name'],$commission_date, $row['userdetails']['fullname'],$created_date_time, '<div class="btn-wrap text-center">' . $button_string . '</div>');
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actiondownloadexecutivefile() {
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=GL-executivecommission.xls");
        $this->renderPartial('executivecommission', $_GET, false, true);
        Yii::app()->end();
    }
    public function actiondownloadmanagerfile() {
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=GL-managercommission.xls");
        $this->renderPartial('managercommission', $_GET, false, true);
        Yii::app()->end();
    }
}
