<?php

class ColourschemeController extends Controller
{

        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Save','GetList'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
         }
         
        public function actionGetList()
         {
 
            $model=new MasColourScheme();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 => 'id',
                   1 => 'item',
                   2 => 'colour',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and item LIKE '%".$searchString."%'";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'item'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div = '';
                    $div =   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'colourscheme/create&id='.$row['id'].'\',\''.$row['item'].'\',\'md\')"><i class="fa fa-pencil"></i></button>';
                    $rowData[]=array($row['id'],$row['item'],$row['colour'],'<div class="btn-wrap text-center">'.$div.'</div>');
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasColourScheme(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSave()
        {
            $model = new MasColourScheme();
            if (isset($_POST['MasColourScheme']))
            {
    		
    		if ((int) @$_POST['MasColourScheme']['id'] > 0)
                {
                    $id= (int) @$_POST['MasColourScheme']['id'];
                    $model=$model->findByPk($id); 
                }
                $model->attributes=$_POST['MasColourScheme'];
               
                if($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['create'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                      
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
              

            }
        }
     
}