<?php

class CalendarController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'Calendar'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }

    public function actionCalendar() {
        $jsonevents = array();
        
        $model_activity = Activity::model()->with('customerdetails')->findAll(array('condition'=>'t.isActive="Y" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.'))'));
        $i = 0;        
        foreach ($model_activity as $j => $each_activity) {
            $type = Activity::gettype($each_activity->type_of_activity);
            $jsonevents[$i]['id'] = $each_activity->id;
            $date = '';
            $event_date = '';
            $event_time = '';
            if ($each_activity->type_of_activity == 4 || $each_activity->type_of_activity == 5 || $each_activity->type_of_activity == 6 || $each_activity->type_of_activity == 7 || $each_activity->type_of_activity == 8) {
                if ($each_activity->call_back_or_actual_date != '' && $each_activity->call_back_or_actual_date != '0000-00-00 00:00:00') {
                    $event_date = date('Y-m-d', strtotime($each_activity->call_back_or_actual_date));
                    $date = date("d/m/Y H:i", strtotime($each_activity->call_back_or_actual_date));
                    $event_time = date('H:i', strtotime($each_activity->call_back_or_actual_date));
                }
            } else {
                if ($each_activity->call_or_plan_date_time != '' && $each_activity->call_or_plan_date_time != '0000-00-00 00:00:00') {
                    $event_date = date('Y-m-d', strtotime($each_activity->call_or_plan_date_time));
                    $event_time = date('H:i', strtotime($each_activity->call_or_plan_date_time));
                    $date = date("d/m/Y H:i", strtotime($each_activity->call_or_plan_date_time));
                }
            }
            $jsonevents[$i]['type'] = $each_activity->type_of_activity;
            if ($each_activity->type_of_activity == 1) {
                $jsonevents[$i]['backgroundColor'] = '#ffbd6a';
            } else if ($each_activity->type_of_activity == 2) {
                $jsonevents[$i]['backgroundColor'] = '#5c9ef9';
            } else if ($each_activity->type_of_activity == 3) {
                $jsonevents[$i]['backgroundColor'] = '#98e857';
            } else if ($each_activity->type_of_activity == 4 || $each_activity->type_of_activity == 8) {
                $jsonevents[$i]['backgroundColor'] = '#BFAAFF';
            } else if ($each_activity->type_of_activity == 5) {
                $jsonevents[$i]['backgroundColor'] = '#6ad3ff';
            } else if ($each_activity->type_of_activity == 6) {
                $jsonevents[$i]['backgroundColor'] = '#FFA500';
            }else if ($each_activity->type_of_activity == 7) {
                $jsonevents[$i]['backgroundColor'] = '#008000';
            }
            // $jsonevents[$i]['url'] = "#";
            $jsonevents[$i]['title'] = $type;
            $jsonevents[$i]['start'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['end'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['description'] = "Date/Time: " . $date .'
                                            Customer: ' . $each_activity->customerdetails->fullname . ' 
                                            Added by: ' . $each_activity->addedby->first_name . ' ' . $each_activity->addedby->last_name . '
                                            Activity: ' . $type;

            $jsonevents[$i]['allDay'] = false;
            $i++;
        }
        $model_activity_details= Activity::model()->with('customerdetails')->findAll(array('condition' =>'t.isActive="Y" AND type_of_activity="1" AND (customerdetails.cust_executive_id="'.Yii::app()->user->id.'" OR customerdetails.cust_executive_id IN ('.Yii::app()->user->connected_users.'))'));
        foreach ($model_activity_details as $j => $each_activity) {
            $jsonevents[$i]['id'] = $each_activity->id;
            $date = '';
            $event_date = '';
            $event_time = '';
            if ($each_activity->call_back_or_actual_date != '' && $each_activity->call_back_or_actual_date != '0000-00-00 00:00:00') {
                    $event_date = date('Y-m-d', strtotime($each_activity->call_back_or_actual_date));
                    $date = date("d/m/Y H:i", strtotime($each_activity->call_back_or_actual_date));
                    $event_time = date('H:i', strtotime($each_activity->call_back_or_actual_date));
            }
            $jsonevents[$i]['type'] = $each_activity->type_of_activity;
            $jsonevents[$i]['backgroundColor'] = '#FF4500';         
            $jsonevents[$i]['title'] = 'Call Back';
            $jsonevents[$i]['start'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['end'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['description'] = "Date/Time: " . $date .'
                                            Customer: ' . $each_activity->customerdetails->fullname . ' 
                                            Added by: ' . $each_activity->addedby->first_name . ' ' . $each_activity->addedby->last_name . '
                                            Activity: Call Back';

            $jsonevents[$i]['allDay'] = false;
            $i++;
        }
        //Lead Activity Calls and Appointments
        $model_lead_activity_details= Activity::model()->with('leadcustomerdetails')->findAll(array('condition' =>'t.isActive="Y" AND customer_id="0" AND lead_customer_id!="0" AND t.created_by="'.Yii::app()->user->id.'"'));
        foreach ($model_lead_activity_details as $j => $each_activity) {
            $jsonevents[$i]['id'] = $each_activity->id;
            $date = '';
            $event_date = '';
            $event_time = '';
            if ($each_activity->call_or_plan_date_time != '' && $each_activity->call_or_plan_date_time != '0000-00-00 00:00:00') {
                $event_date = date('Y-m-d', strtotime($each_activity->call_or_plan_date_time));
                $event_time = date('H:i', strtotime($each_activity->call_or_plan_date_time));
                $date = date("d/m/Y H:i", strtotime($each_activity->call_or_plan_date_time));
            }
            $jsonevents[$i]['type'] = $each_activity->type_of_activity;
            $type = Activity::gettype($each_activity->type_of_activity);
            if ($each_activity->type_of_activity == 1) {
                $jsonevents[$i]['backgroundColor'] = '#ffbd6a';
            } else if ($each_activity->type_of_activity == 2) {
                $jsonevents[$i]['backgroundColor'] = '#5c9ef9';
            }
            $jsonevents[$i]['title'] =$type;
            $jsonevents[$i]['start'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['end'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['description'] = "Date/Time: " . $date .'
                                            Customer: ' . $each_activity->leadcustomerdetails->fullname . ' 
                                            Added by: ' . $each_activity->addedby->first_name . ' ' . $each_activity->addedby->last_name . '
                                            Activity: Call Back';

            $jsonevents[$i]['allDay'] = false;
            $i++;
        }
        //Lead Activity Call Back
        $model_leadactivity_details= Activity::model()->with('leadcustomerdetails')->findAll(array('condition' =>'t.isActive="Y" AND customer_id=0 AND lead_customer_id!="0" AND type_of_activity="1" AND t.created_by="'.Yii::app()->user->id.'"'));
        foreach ($model_leadactivity_details as $j => $each_activity) {
            $jsonevents[$i]['id'] = $each_activity->id;
            $date = '';
            $event_date = '';
            $event_time = '';
            if ($each_activity->call_back_or_actual_date != '' && $each_activity->call_back_or_actual_date != '0000-00-00 00:00:00') {
                    $event_date = date('Y-m-d', strtotime($each_activity->call_back_or_actual_date));
                    $date = date("d/m/Y H:i", strtotime($each_activity->call_back_or_actual_date));
                    $event_time = date('H:i', strtotime($each_activity->call_back_or_actual_date));
            }
            $jsonevents[$i]['type'] = $each_activity->type_of_activity;
            $jsonevents[$i]['backgroundColor'] = '#FF4500';         
            $jsonevents[$i]['title'] = 'Call Back';
            $jsonevents[$i]['start'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['end'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['description'] = "Date/Time: " . $date .'
                                            Customer: ' . $each_activity->leadcustomerdetails->fullname . ' 
                                            Added by: ' . $each_activity->addedby->first_name . ' ' . $each_activity->addedby->last_name . '
                                            Activity: Call Back';

            $jsonevents[$i]['allDay'] = false;
            $i++;
        }
        
        //Send-Receive
        $model_provider_info = ProviderSendReceiveInfo::model()->with('customer_detail')->findAll(array('condition'=>'(customer_detail.cust_executive_id="'.Yii::app()->user->id.'" OR customer_detail.cust_executive_id IN ('.Yii::app()->user->connected_users.'))'));
        foreach ($model_provider_info as $k => $each_info) {
            $type = ProviderSendReceiveInfo::gettype($each_info->send_or_receive);
            $jsonevents[$i]['id'] = $each_info->id;
            $date = '';
            $event_date = '';
            $event_time = '';
            $jsonevents[$i]['type'] = $each_info->send_or_receive;
            if ($each_info->send_or_receive_date_time != '' && $each_info->send_or_receive_date_time != '0000-00-00 00:00:00') {
                $event_date = date('Y-m-d', strtotime($each_info->send_or_receive_date_time));
                $date = date("d/m/Y H:i A", strtotime($each_info->send_or_receive_date_time));
                $event_time = date('H:i A', strtotime($each_info->send_or_receive_date_time));
            }
            if ($each_info->send_or_receive == 'S') {
                $jsonevents[$i]['backgroundColor'] = '#FFB6C1';
            } else if ($each_info->send_or_receive == 'R') {
                $jsonevents[$i]['backgroundColor'] = '#800080';
            }
            $jsonevents[$i]['title'] = $type;
            $jsonevents[$i]['date'] = $event_date;
            $jsonevents[$i]['start'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['end'] = $event_date . 'T' . $event_time;
            $jsonevents[$i]['description'] = "Date/Time: " . $date . '  
                    Customer: ' . $each_info->customer_detail->fullname . '   
                    Plan: ' . $each_info->plan_detail->masplandetails->plan_name . '    
                    Method: ' . $each_info->send_method_detail->sending_method . '    
                    Notes: ' . $each_info->notes . '  
                    Activity: ' . $type;
            $jsonevents[$i]['allDay'] = false;
            $i++;
        }
        echo CJSON::encode($jsonevents);
        Yii::app()->end();
    }

}
