<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity {

    private $_id;
    public $code;

    public function __construct($username, $password, $code) {
        $this->username = $username;
        $this->password = $password;
        $this->code = $code;
    }

    /**
     * Authenticates a user.
     * @return boolean whether authentication succeeds.
     */
    public function authenticate() {
        $username = strtolower($this->username);
        $code = MasCompany::getCode($this->code);
        //$password = crypt($this->password, $this->password);
        //START Code modified on 08-04-2016 for secured password
        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password = crypt($this->password, $salt);
        //END Code modified on 08-04-2016 for secured password
        $user = User::model()->find('LOWER(username)=? AND isActive=? AND company_id=?', array($username, 'Y', $code));

        if ($user == null)
            $this->errorCode = self::ERROR_USERNAME_INVALID;
        else if ($user->password != $password)
            $this->errorCode = self::ERROR_PASSWORD_INVALID;
        else {
            $model_log = new UserLog();
            $model_log->user_id = $user->id;
            $model_log->login_time = date('Y-m-d H:i:s');
            $model_log->ip_address = $_SERVER['REMOTE_ADDR'];
            $model_log->save();           
            $this->_id = $user->id;
            $this->setState('fullname', $user->fullname);
            $this->setState('master_user_company_id', $code);
            $this->setState('user_branch', "");
            $this->setState('user_email_id', $user->email);
            $this->setState('user_group_id', $user->user_group_id);
            //for connected users
            if($user->connected_users!=''){
                $this->setState('connected_users', $user->connected_users);
            }else{
                $this->setState('connected_users', '0');
            }
            $authorised_user = 0;
            if ($user->level == 0)
                $authorised_user = 1;

            $this->setState('authorised_user', $authorised_user);
            //$arr_company = MasCompany::model()->findAll('id='.$user->company_id);
            $arr_company = MasCompany::getMasCompanyDetails($user->company_id);
            $master_company_name = $arr_company->company_name;
            $company_db_name = $arr_company->company_db_name;
            $company_head_user = $arr_company->crm_user_id;
            $company_logo = $arr_company->company_logo;
            $footer_line_1 = $arr_company->footer_line_one;
            $footer_line_2 = $arr_company->footer_line_two;
            $auto_generated = $arr_company->footer_autogenerated;
            $fin_year = $arr_company->fin_year;
            $company_code = $arr_company->company_code;

            //for pdf css color
            $pdf_css_file_name = $arr_company->pdf_css_file_name;

            $this->setState('master_company_name', $master_company_name);
            $this->setState('main_db_name', 'blueskye_erp_lite_main');
            $this->setState('company_db_name', trim($company_db_name));
            $this->setState('company_code', $company_code);
            $this->setState('company_head_user', trim($company_head_user));
            $this->setState('company_logo', $company_logo);
            $this->setState('pdf_company_logo', "pdf_" . $company_logo);
            $this->setState('master_company_name', $master_company_name);
            $this->setState('footer_line_1', $footer_line_1);
            $this->setState('footer_line_2', $footer_line_2);
            $this->setState('footer_autogenerated', $auto_generated);
            $this->setState('fin_year', $fin_year);
            $this->setState('default_currency_id', $arr_company->currency_id);
            $this->setState('default_billing_country_id', $arr_company->billing_country);
            $this->setState('pdf_css_file_name', $pdf_css_file_name);

            if (isset($arr_company->genral_email))
                $this->setState('company_general_email', $arr_company->genral_email);
            else
                $this->setState('company_general_email', "test@mailbluesky.com");

            if (isset($arr_company->genral_web))
                $this->setState('company_general_web', $arr_company->genral_web);
            else
                $this->setState('company_general_web', "");

            if (isset($arr_company->genral_phno))
                $this->setState('company_general_phone_no', $arr_company->genral_phno);
            else
                $this->setState('company_general_phone_no', "");
            //usergroup start
            if($user->user_group_id>0){
                $userGroupmodel = MasUserGroup::model()->findByPk($user->user_group_id );
                $permissionArray = array();
                if (!empty($userGroupmodel->permissions)) {
                    $permissionArray = CJSON::decode($userGroupmodel->permissions);
                    $formatted_array = array_map(function($num) {
                        return (is_numeric(trim($num)) ? number_format(floatval($num), 0, '', '') : $num);
                    }, $permissionArray);
                }else{
                    $formatted_array=array();
                }
                $this->setState('havePermissionOn', array_merge($formatted_array));
            }else{
                $this->setState('havePermissionOn', array());
            }
            //usergroup end
            $this->username = $user->username;
            $this->errorCode = self::ERROR_NONE;
        }
        return $this->errorCode == self::ERROR_NONE;
    }

    public function getId() {
        return $this->_id;
    }

}
