<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadtargetdetails", '$(document).ready(function() {
        filterDataTable();
    });', CClientScript::POS_HEAD);
$cs->registerScript("loaddetails", 'function filterDataTable(){
        var executive_id=$("#executive_name").val();
        var executive_year=$("#executive_year").val();
        var table_id ="#tbl_target_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
//            scrollX         : "true",
           // scrollCollapse  : true,
           "bAutoWidth": true,
            pageLength      : 50,
            processing: true,                       
            //bSort: false,
            order: [[ 1, "asc" ]],
            columns: [
                {className: ""},
                {className: "" },
                {className: "" },
                {className: "" },
                {className: "text-right" },
                {className: ""},
                {className: ""},
            ],
            "columnDefs": [
                { "bSortable": false, "aTargets": [0,2,3,4,5] },
                 ],
            ajax: {
                url: "' . Yii::app()->createUrl('target/gettargetlist') . '",
                type: "POST",
                "data" : {
                    "executive_id" : executive_id,
                    "executive_year" : executive_year,
                },
                cache : false,
            },          
            serverSide:     true,
            fixedColumns:   true,
            processing: true,           
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            
        });
        $(".dataTables_scrollFoot").hide();
    }', CClientScript::POS_HEAD);
$cs->registerScript("getusersdetails",  "function getusersdetails(){  
    $('#tbl_target_details').DataTable().destroy();
    filterDataTable();
   
};", CClientScript::POS_HEAD); 
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-trophy"></i> Executive Target
        <div class="pull-right" style="display: inline-flex;">
             <?php
            echo CHtml::dropdownlist('executive_year',date('Y'),UserTarget::listYears(4,0),  array('class'=>'activity-dropdown-1','title' => 'Please Select Year','onchange'=>'getusersdetails();')); 
            ?> 
            <?php
            echo CHtml::dropdownlist('executive_name','',User::getUsersList(),  array('class'=>'activity-dropdown-1','title' => 'Please Select Executive','onchange'=>'getusersdetails();','empty'=>'All Executives')); 
            ?>  
            <button class="btn btn-sm btn-theme_1" onclick="loadPopupModal('target/create', 'Add New Target', 'lg')"><i class="fa fa-plus"></i> ADD</button>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_target_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Executive Name</th>
                        <th>Designation</th>
                        <th>Target Type</th>
                        <th>Target Amount</th>
                        <th>Year</th>
                        <th align="center">Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Executive Name</th>
                        <th>Designation</th>
                        <th>Target Type</th>
                        <th>Target Amount</th>
                        <th>Year</th>
                        <th align="center">Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
