<?php
$users_array[] = Yii::app()->user->id;
$explode_connected_users = explode(',', Yii::app()->user->connected_users);
if (count($explode_connected_users) > 0) {
    foreach ($explode_connected_users AS $user) {
        $users_array[] = $user;
    }
}
$connected_users = implode(",", array_filter($users_array));
$date_from=date('01/01/Y');
$date_to=date('31/12/Y')
?>
<div id="div_master_report_customerlist row">
    <ul class="clearfix form-ul material" id="customerlist-form-hide"> 
        <div class="row">
        <li class="col-sm-3">
            <label>Customer</label>
            <?php echo CHtml::textField('fact_find_customer_name', '', array('class' => 'form-control tooltipster', 'title' => 'Please choose a customer', 'placeholder' => 'Please choose a customer', 'data-label' => 'Customer ', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"activitylist");')); ?>
            <?php echo CHtml::hiddenField('fact_find_customer_id'); ?>
        </li>
        <li class="col-sm-3">
            <label>User</label>
            <div class="material">    
                <?php
                echo CHtml::dropDownList('fact_find_user', '',User::getConnectedUsers($connected_users), array('class' => 'form-control tooltipster select2', 'data-label' => 'User', 'data-search' => 'true', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-3">
            <label>Date From</label>
            <div class="material">    
                <?php echo CHtml::textField('fact_find_from_date',$date_from, array('class' => 'form-control datepicker', 'data-label' => 'Date From')); ?>
            </div>                            
        </li>
        <li class="col-sm-3">                            
            <label>Date To</label>
            <div class="material">    
                <?php echo CHtml::textField('fact_find_to_date',$date_to, array('class' => 'form-control datepicker', 'data-label' => 'Date To ')); ?>
            </div>
        </li>
        </div>
    </ul>
</div>
<div class='btn-wrap text-right row'>
    <input type="button" value="" onclick="loadMasterReport(1);return false;" class='fact_find_report btn btn-theme report_view' title="View Fact Find List">
    <input type="button" value="" onclick="loadMasterReport(2);return false;" class='fact_find_report_pdf btn btn-theme report_pdf' title="View as PDF">
    <input type="button" value="" onclick="loadMasterReport(3);return false;" class='fact_find_report_excel btn btn-theme report_excel' title="Download Excel">
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    $('#fact_find_from_date, #fact_find_to_date').datepicker({dateFormat:'dd/mm/yy'})
});", CClientScript::POS_HEAD);
$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id,frm){
    $('#fact_find_customer_id').val('');
    var url = '" . Yii::app()->createUrl('reports/GetCustomerDetails') . "'+'&frm='+frm;
    $('#'+field_id).autocomplete({
    minLength   : 1,
    source      : function (request, response) { autoCompleteSource(request, response,url) },
    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
    select          : function( event, ui ) {
        event.preventDefault();
        trigger_target_id  	=   $(event.target).attr('id');
        var customer_id=ui.item.value; 
        $('#fact_find_customer_id').val(customer_id);
        }
    })
}", CClientScript::POS_HEAD);
?>

<script>
    
    $(document).ready(function(){
      $("#fact_find_user").select2();
   
    });
        
    </script>


