<?php
$uasers_array[] = Yii::app()->user->id;
$explode_connected_users = explode(',', Yii::app()->user->connected_users);
if (count($explode_connected_users) > 0) {
    foreach ($explode_connected_users AS $user) {
        $uasers_array[] = $user;
    }
}
$connected_users = implode(",", array_filter($uasers_array));
?>

<div id="div_master_report_customerlist row">
    <ul class="clearfix form-ul material" id="customerlist-form-hide"> 
        <div class="row">
        <li class="col-sm-4">
            <label>Customer</label>
            <?php echo CHtml::textField('customer_name', '', array('class' => 'form-control tooltipster', 'title' => 'Please choose a customer', 'placeholder' => 'Please choose a customer', 'data-label' => 'Customer ', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"activitylist");')); ?>
            <?php echo CHtml::hiddenField('custlist_customer_id'); ?>
        </li>
        <li class="col-sm-2">
            <label>Type</label>
             <?php
            echo CHtml::dropdownlist('policy_taken','',array('Y'=>'Customer','N'=>'Prospects'),  array('class'=>'form-control activity-dropdown-1','data-label' => 'Type ','title' => 'Please Select Type','onchange'=>'getcustomerdetails();','empty'=>'All')); 
            ?>
        </li>
        <li class="col-sm-2" id="prospectus_status_li" style="display: none">
            <label>Status</label>
            <?php
            echo CHtml::dropdownlist('prospectus_status','',array(1=>'Hot',2=>'Warm',3=>'Cold'),  array('class'=>'form-control activity-dropdown-1','data-label' => 'Status','title' => 'Please Select Prospect Status','onchange'=>'getcustomerdetails();','empty'=>'All')); 
            ?>
        </li>
      
        <li class="col-sm-2">
            <div class="material">    
            <label>Prospect source</label>
             <?php echo CHtml::dropDownList('cust_prospect_source','',array(1=>'Referral',2=>'Network',3=>'Website',4=>'Advertisement'), array('empty'=>'Select','data-label' => 'Prospect source','class' => 'form-control label_a tooltipster select2','data-search' => true, 
                            
                                )); ?>
            </div>                            
        </li>
        <li class="col-sm-2">                            
            <div class="material">    
            <label>Marital Status <span style="color:red;"></span></label>
                <?php echo CHtml::dropDownList('cust_marital_status','',MasMaritalStatus::getMaritalStatus(),array('class' => 'form-control tooltipster','data-label'=>'Marital Status <span style="color:red;"></span>','empty'=>'Select')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">    
            <label>Fitness<span style="color:red;"></span></label>
               <?php echo CHtml::dropDownList('cust_health','',MasHealthStatus::getHealthStatus(),array('class' => 'form-control tooltipster','data-label'=>'Fitness<span style="color:red;"></span>','empty'=>'Select'));  ?> 
            </div>                            
        </li>
        </div>
        <div class="row">
        <li class="col-sm-2">                            
            <label>Smoker <span style="color:red;"></span></label>
            <div class="material">    
                <?php echo CHtml::dropDownList('cust_smoker','',array('N'=>'N','Y'=>'Y'),array(
            
            'class' => 'form-control tooltipster', 'title' => 'Smoker','data-label'=>'Smoker <span style="color:red;"></span>','empty'=>'All'));  ?>
            </div>
        </li>
        <li class="col-sm-2">         
            <label>Executive</label>
            <div class="material">    
               <?php echo CHtml::dropDownList('cust_customer','', User::getConnectedUsers($connected_users), array('class' => 'form-control tooltipster','data-label'=>'Executive','empty' => 'All')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <label>From Date</label>
            <?php echo CHtml::textField('customer_lock_from_date', '', array('class' => 'form-control tooltipster', 'title' => 'From Date', 'placeholder' => 'From Date', 'data-label' => ' ','class'=>'datepicker')); ?>
        </li>
        <li class="col-sm-3">
            <label>To Date</label>
            <?php echo CHtml::textField('customer_lock_to_date', '', array('class' => 'form-control tooltipster', 'title' => 'To Date', 'placeholder' => 'To Date', 'data-label' => ' ','class'=>'datepicker')); ?>
        </li>
        </div>
    </ul>
</div>
<div class='btn-wrap text-right row'>
    <input type="button" value="" onclick="loadMasterReport(1);return false;" class='activity_report btn btn-theme report_view' title="View Customer List">
    <input type="button" value="" onclick="loadMasterReport(2);return false;" class='activity_report_pdf btn btn-theme report_pdf' title="View as PDF">
    <input type="button" value="" onclick="loadMasterReport(3);return false;" class='activity_report_excel btn btn-theme report_excel' title="Download Excel">
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    $('#customer_lock_from_date, #customer_lock_to_date').datepicker({dateFormat:'dd/mm/yy'})
});", CClientScript::POS_HEAD);
$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id,frm){
    var url = '" . Yii::app()->createUrl('reports/GetCustomerDetails') . "'+'&frm='+frm;
    $('#'+field_id).autocomplete({
    minLength   : 1,
    source      : function (request, response) { autoCompleteSource(request, response,url) },
    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
    select          : function( event, ui ) {
        event.preventDefault();
        trigger_target_id  	=   $(event.target).attr('id');
        var customer_id=ui.item.value; 
        $('#custlist_customer_id').val(customer_id)
        }
    })
}", CClientScript::POS_HEAD);
$cs->registerScript("getcustomerdetails",  "function getcustomerdetails(){  
    
    var policy_taken=$('#policy_taken').val();
    if(policy_taken=='N'){
        $('#prospectus_status_li').show();
    }else{
        $('#prospectus_status_li').hide();
    }
};", CClientScript::POS_HEAD); 
?>
<script>
    
    $(document).ready(function(){
      $("#cust_prospect_source").select2();
    
   
    });
        
    </script>
