
<!DOCTYPE html>
<html>
    <head>
        <title>Customer Payment</title>

    </head>
    <body>
        <div class="heading">
            <div class="logo col-6"><img src="images/pdf_logo.png"></div>
            <div class="companay_name col-6 text-right"></div>
        </div>
        <div class="clearfix"></div>
        <div class="title">
            <div class="col-6"><div style="height: 10px;"></div></div>
            <div class="col-6 text-right"> <h1>Customer Policy Report </h1>
                <div class="details-box"></div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="panel">
            <div class="panel-body">
                <div class="table-responsive">
                             <table class="table table-fixed table-bordered table-primary">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Installment No</th>
                        <th style="white-space:nowrap ! important; width:20%;">Customer</th>
                        <th>Policy No</th>
                        <th>Payment Date</th>
                        <th>Plan Name</th>

                        <th>Payment Type</th>

                        <th>Amount</th>
                        <th>Status</th>

                    </tr>
                </thead>
                <tbody>

                    <?php
                    $condition = '( cus_details.cust_executive_id ="' . Yii::app()->user->id . '" OR cus_details.cust_executive_id IN (' . Yii::app()->user->connected_users . '))';
                    if ($custlist_customer_id != "") {
                        $condition .= " AND t.customer_id = " . $custlist_customer_id;
                    }
                    if ($payment_term != "") {
                        $condition .= " AND t.payment_type = " . $payment_term;
                    }
                    if ($status != "") {
                        $condition .= " AND t.status = " . $status;
                    }
                    if ($plan_id != "") {
                        $condition .= " AND t.cus_plan_id = " . $plan_id;
                    }
                    if ($to != "") {
                        $to = str_replace('/', '-', $to);
                        $to = date('Y-m-d', strtotime($to));
                        $condition .= " AND t.pay_date >= '" . $to . "'";
                    }
                    if ($from != "") {
                        $from = str_replace('/', '-', $from);

                        $from = date('Y-m-d', strtotime($from));
                        $condition .= " AND t.pay_date <= '" . $from . "'";
                    }

                    $model = new CustomerPaymentDetails();
                    $model = $model->with('cus_plan_details', 'cus_details', 'cus_plan_details.masplandetails')->findAll(array('condition' => $condition));

                    foreach ($model as $i => $value) {
                        ?>

                        <tr>
                            <td>
                                <?php echo ($i + 1) ?>
                            </td>
                            <td>
                                <?php echo $value->installment_no ?>
                            </td>
                            <td>
                                <?php echo $value->cus_details->cust_first_name . " " . $value->cus_details->cust_middle_name . " " . $value->cus_details->cust_last_name ?>
                            </td>
                            <td>
                                <?php echo $value->cus_plan_details->policy_no ?>
                            </td>
                            <td>
                                <?php echo date('d/m/Y', strtotime($value->pay_date)) ?>
                            </td>
                            <td>
                                <?php echo $value->cus_plan_details->masplandetails->plan_name ?>
                            </td>
                            <td>
                                <?php echo CustomerPaymentDetails::getPaymentType($value->payment_type); ?>
                            </td>
                            <td class="text-right">
                                <?php echo $value->pay_amount ?>
                            </td>
                            <td>
                                <?php echo CustomerPaymentDetails::getPaymentStatus($value->status) ?>
                            </td>



                        </tr>




                        <?php
                    }
                    ?>
                </tbody>
            </table>
                </div>
            </div>
        </div>

    </body>
</html>
