<!DOCTYPE html>
<html>
    <head>
        <title>Credit Card Expiry List</title>
    </head>
    <body>
        <div class="heading">
            <div class="logo col-6"><img src="images/pdf_logo.png"></div>
            <div class="companay_name col-6 text-right"></div>
        </div>
        <div class="clearfix"></div>
        <div class="title">
            <div class="col-6"><div style="height: 10px;"></div></div>
            <div class="col-6 text-right"> <h1>Credit Card Expiry Report </h1>
                <div class="details-box"></div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="panel">
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-fixed table-bordered table-primary">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Customer</th>
                                <th>Mobile No</th>
                                <th>Email</th>
                                <th>Card No</th>
                                <th>Expiry Date</th>

                            </tr>
                        </thead>
                        <tbody style=" padding: 4px 5px;font-size: 13px;">

                            <?php
                            $currentdate = date('Y-m-d');
                            $condition = 'payment_type="2" and (cus_details.cust_executive_id="' . Yii::app()->user->id . '" OR cus_details.cust_executive_id IN (' . Yii::app()->user->connected_users . '))';
                            if ($credit_expiry_date != '0000-00-00' && $credit_expiry_date != '') {
                                $credit_expiry_date = str_replace('/', '-', $credit_expiry_date);
                                $credit_expiry_date = date("Y-m-d", strtotime($credit_expiry_date));
                                $condition.= ' AND expiry_date<="' . $credit_expiry_date . '"';
                            } else {
                                $condition.= ' AND expiry_date<="' . $currentdate . '"';
                            }
                            if ($credit_customer_id != "") {
                                $condition .= " AND t.customer_id = " . $credit_customer_id;
                            }

                            $modal_card_details = CustomerPaymentDetails::model()->with('cus_details')->findAll(array('condition' => $condition, 'order' => 'customer_id desc'));
                            foreach ($modal_card_details as $i => $value) {
                                ?>

                                <tr>
                                    <td><?php echo ($i + 1) ?></td>
                                    <td><?php echo $value->cus_details->Fullname; ?></td>
                                    <td><?php echo $value->cus_details->cust_mobile1; ?></td>
                                    <td><?php echo $value->cus_details->cust_email1; ?></td>
                                    <td><?php echo $value->ac_no; ?></td>
                                    <td><?php
                                        if ($value->expiry_date != '' && $value->expiry_date != '0000-00-00') {
                                            echo date("d/m/Y", strtotime($value->expiry_date));
                                        }
                                        ?></td>
                                </tr>




                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <htmlpagefooter name="myfooter">
        <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
            <?php
            date_default_timezone_set("Asia/Dubai");
            echo date('d/m/Y') . " " . date("h:i:sa");
            ?>
        </div>
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
            <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
    <sethtmlpagefooter name="myfooter" page="all" value="on" />
</body>
</html>

