<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'customerupload-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<style>
    .bott_dec span{
        display: block;
        line-height: 20px;
        font-weight: normal;
        font-size: 12px !important;
        color: #4d4c4c;
        padding-left: 20px;
        letter-spacing: 0.25px;
    }
</style>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material row">
            <li class="col-sm-2">
                <?php
                $allowedExtensions = array("csv");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => 'policy_upload_csv',
                    'config' => array(
                        'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/policydetails')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => 1 * 1024 * 1024,
                        'onStart' => "js:function(){}",
                        'class' => 'pull-right',
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            policycsvupload(responseJSON.filename)
                        }",
                )));
                ?>
            </li>
            <li class="col-sm-2">
                <div  id="csv_msg">
                </div>
            </li>
            <li class="col-sm-8 bott_dec">
                <span>* All fields are mandatory *</span>
                <span>* Customer ID to identify customers *</span>
                <span>* Fill provider name based upon the master corresponding to <b><?php echo CHtml::link('Provider', array('provider/index'), array('target' => '_blank')); ?></b> *</span>
                <span>* Fill out plan name based upon the master corresponding to <b><?php echo CHtml::link('Plan', array('Masproviderplans/index'), array('target' => '_blank')); ?></b> *</span>
                <span>* Fill out class based upon the master corresponding to <b><?php echo CHtml::link('Class', array('Masclass/index'), array('target' => '_blank')); ?></b> *</span>
                <span>* Fill out subclass based upon the master corresponding to <b><?php echo CHtml::link('SubClass', array('Massubclass/index'), array('target' => '_blank')); ?></b> *</span>
                <span>* Fill out Payment Term by downloading the file <b><?php echo CHtml::link('Payment Term', array('policyupload/DownloadPaymentmaster')); ?></b> *</span>
                <span>* Fill out Status as <b style="color: red;">INFORCE,BENEFIT CLAIM,PENDING,SURRENDER,MATURITY,LAPSED,PAID UP,CANCELLED,NEF</b></span>
                <span>* Upload files in .csv format *</span>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::link('Download Format', array('policyupload/Downloadformat'), array('class'=>"btn btn-theme_1",'target' => '_blank')); ?>
            </li>
        </ul>
    </div>
    <button type="button" class="btn btn-danger" style="display:none;" id="policy_upload_close" data-dismiss="modal">Close</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();

$cs->registerScript("policycsvupload", "function policycsvupload(filename){
if(filename != ''){
    jQuery.ajax({
      'type': 'post',
      'dataType': 'json',
      'data': {
              filename: filename
              },
      'url'  : '" . Yii::app()->createUrl("policyupload/SaveUploadCsv") . "',
      'cache': false,
      'success': function (data) {
          if (data.status == 'success') {
            $('#csv_msg').html('');
            t8.success('Details of '+data.uploadcount+' Policies Uploaded Successfully');
            $('#policy_upload_close').click();
            reloadTable('#tbl_customer_details');
          }else if (data.status == 'error') {
              if(data.link!=''){
                  $('#csv_msg').html(data.link);
              }
          }else{
              t8.error('Error');
          }
      },
      'beforeSend': function (data) {
          $('#loader').show();
      },
      'complete': function (data) {
          $('#loader').hide();
      },
    });
}else{
	t8.error('File not found');
	
}
}", CClientScript::POS_HEAD);
?>









