<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'paymentupload-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<style>
    .bott_dec span{
        display: block;
        line-height: 20px;
        font-weight: normal;
        font-size: 12px !important;
        color: #4d4c4c;
        padding-left: 20px;
        letter-spacing: 0.25px;
    }
</style>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material row">
            <li class="col-sm-2">
                <?php
                $allowedExtensions = array("csv");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => 'payment_upload_csv',
                    'config' => array(
                        'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/paymentdetails')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => 1 * 1024 * 1024,
                        'onStart' => "js:function(){}",
                        'class' => 'pull-right',
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            paymentcsvupload(responseJSON.filename)
                        }",
                )));
                ?>
            </li>
            <li class="col-sm-2">
                <div  id="csv_msg">
                </div>
            </li>
            <li class="col-sm-8 bott_dec">
                <span>* Fill out Payment Model by downloading the file <b><?php echo CHtml::link('Payment Mode', array('paymentupload/DownloadPaymentmaster')); ?></b> *</span>
                <span>* Fill out Status as <b style="color: red;">Completed,Inprocess,Cancelled,Returned</b></span>
                <span>* Upload files in .csv format *</span>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::link('Download Format', array('paymentupload/Downloadformat'), array('class'=>"btn btn-theme_1")); ?>
            </li>
        </ul>
    </div>
    <button type="button" class="btn btn-danger" style="display:none;" id="payment_upload_close" data-dismiss="modal">Close</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();

$cs->registerScript("paymentcsvupload", "function paymentcsvupload(filename){
if(filename != ''){
    jQuery.ajax({
      'type': 'post',
      'dataType': 'json',
      'data': {
              filename: filename
              },
      'url'  : '" . Yii::app()->createUrl("paymentupload/SaveUploadCsv") . "',
      'cache': false,
      'success': function (data) {
          if (data.status == 'success') {
            t8.success('Details Uploaded Successfully');
            $('#payment_upload_close').click();
          }else if (data.status == 'error') {
              if(data.link!=''){
                  $('#csv_msg').html(data.link);
              }
          }else{
              t8.error('Error');
          }
      },
      'beforeSend': function (data) {
          $('#loader').show();
      },
      'complete': function (data) {
          $('#loader').hide();
      },
    });
}else{
	t8.error('File not found');
	
}
}", CClientScript::POS_HEAD);
?>









