<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'lead_customer-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
    $mas_country_details = MasCountry::model()->findByPk(Yii::app()->user->default_billing_country_id);
    $model->mobile_code = $mas_country_details->phone_code . "-";
    $model->customer_country_id=$mas_country_details->id;
    if ((int) $model->id > 0) {
        $mobile_number=  explode('-', $model->customer_mobile_number);
        $model->mobile_code=$mobile_number[0].'-';
        $model->mobile_number=$mobile_number[1];
    } 
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material"> 
            <div class="row">
            <li class="col-sm-4">
                 <?php echo $form->hiddenField($model, 'id'); ?>
                 <label>First Name<span style="color:red;">*<img src="images/name.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->textField($model, 'customer_first_name', array('class' => 'form-control', 'data-label' => 'First Name<span style="color:red;">*<img src="images/name.png" style="padding-left: 10px;"></span>')); ?>
            </li>
            <li class="col-sm-4">
                <label>Middle Name <span><img src="images/name.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->textField($model, 'customer_middle_name', array('class' => 'form-control', 'data-label' => 'Middle Name <span><img src="images/name.png" style="padding-left: 10px;"></span>')); ?>
            </li>
            <li class="col-sm-4">
                <label>Last Name<span style="color:red;">*<img src="images/name.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->textField($model, 'customer_last_name', array('class' => 'form-control', 'data-label' => 'Last Name<span style="color:red;">*<img src="images/name.png" style="padding-left: 10px;"></span>')); ?>
            </li>
            </div>
            <div class="row">
            <li  class="col-sm-4">
                <label>Country<span style="color:red;">*<img src="images/country.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->dropDownList($model, 'customer_country_id',MasCountry::getActiveCountryName(), array('class' => 'form-control label_a tooltipster', 'data-label' => 'Country<span style="color:red;">*</span>', 'data-search' => true, 'options' => MasCountry::getCountrywithImg(),'onchange'=>'getcountrytelcode(this.value);')); ?>
            </li>
            <li class="col-sm-4">
                <label>Mobile Number<span style="color:red;">*<img src="images/smartphone.png" style="padding-left: 10px;"></span></label>
                <div style="display: inline-flex;">
			    <div class="mobile_code">
                <?php echo $form->textField($model,'mobile_code',array('class' => 'form-control', 'readonly' =>true)); ?>
                </div>
				<div class="mobile_number">
                <?php echo $form->textField($model, 'mobile_number', array('class' => 'form-control', 'data-label' => 'Mobile Number<span style="color:red;">*<img src="images/smartphone.png" style="padding-left: 10px;"></span>','onblur' => 'checkmobilenumberexist(this.value);','onkeypress' => 'return isNumberKey(event)')); ?>
				</div>
				</div>
            </li>
            <li class="col-sm-4">
                <label>Email<span style="color:red;"><img src="images/email.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->textField($model, 'customer_email', array('class' => 'form-control', 'data-label' => 'Email<span style="color:red;"><img src="images/email.png" style="padding-left: 10px;"></span>')); ?>
            </li>
            </div>
            <div class="clearfix"></div>
            <div class="row">
            <li class="col-sm-4">
                <label>Status<span style="color:red;"> * <img src="images/status.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->dropDownList($model, 'status', array('1'=>'Open','2'=>'Lost','3'=>'Closed'),array('class' => 'form-control', 'data-label' => 'Status<span style="color:red;"> * <img src="images/status.png" style="padding-left: 10px;"></span>')); ?>
            </li>
             <li  class="col-sm-4">
                <label>Prospect Source<span style="color:red;">*<img src="images/prospect.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->dropDownList($model, 'customer_source_prospect',array(1=>'Referral',2=>'Network',3=>'Website',4=>'Advertisement'), array('class' => 'form-control label_a tooltipster','data-search' => true, 
                                    'options' =>array(1=>array('data-image'=>'uploads/prospect/referral.png'),
                                                    2=>array('data-image'=>'uploads/prospect/network.png'),
                                                    3=>array('data-image'=>'uploads/prospect/website.png'),
                                                    4=>array('data-image'=>'uploads/prospect/advertisement.png')
                                        ))); ?>
            </li>
<!--            <li class="col-sm-4">
                <?php //echo $form->textField($model, 'call_back_date_time',array('class' => 'tooltipster datetimepicker', 'title' => 'CallBack Date', 'data-label' => 'CallBack Date<span style="color:red;">*<img src="images/start-date.png" style="padding-left: 10px;"></span>')); ?>
            </li>-->
            <!--<div class="clearfix"></div>-->
            <li class="col-sm-4">
                <label>Referred By<span><img src="images/executive.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->textField($model, 'referred_by', array('class' => 'form-control', 'data-label' => 'Referred By<span><img src="images/executive.png" style="padding-left: 10px;"></span>')); ?>
            </li>
            </div>
            <div class="row">
            <li class="col-sm-12">
                <label>Remarks<span style="color:red;">*<img src="images/notes.png" style="padding-left: 10px;"></span></label>
                <?php echo $form->textArea($model, 'remarks', array('class' => 'form-control', 'data-label' => 'Remarks<span style="color:red;">*<img src="images/notes.png" style="padding-left: 10px;"></span>')); ?>
            </li>
            </div>
        </ul>
    </div>

</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id='lead_cust_close'>Close</button>
    <?php
    $url = Yii::app()->createUrl('lead/saveCustomer');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
               $("#loader").hide();
                if(data.status=="success"){
                     t8.success("Saved Successfully!");
                    
                     $("#lead_cust_close").click();
                     reloadTable("#tbl_lead_details");
                     
                } else {
                    $.each(data, function(key, val) {
                            t8.error(""+val+"");
                        });
                }
        }',
        'beforeSend' => 'function(){
                            $("#loader").show();
                            $("#lead_customer-form .lead_customer-save-btn").prop("disabled", true);
                            $("#lead_customer-form .lead_customer-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            $(".toast8-error").hide();
                        }',
        'complete' => 'function(){
                            $("#lead_customer-form .lead_customer-save-btn").prop("disabled", false);
                            $("#lead_customer-form .lead_customer-save-btn").addClass("btn-theme").removeClass("btn_loding");
                            $("#loader").hide();
                        }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'lead_customer-save-btn btn btn-theme'));
    ?>
</div>
    <?php $this->endWidget(); 
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("getcountrytelcode", "function getcountrytelcode(country_id) {  
            jQuery.ajax({
                'dataType':'json', 
                'data' : {
                    'id':country_id
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('mascountry/getcountrytelcode') . "',
                'cache': false,
                'success': function(data) {
                    $('#LeadCustomer_mobile_code').val(data.phone_code);
                },
                'beforeSend': function(data) {
                    $('#loader').show();
                },
                'complete': function(data) {
                    $('#loader').hide();
                },
        });
    };", CClientScript::POS_HEAD);
    $cs->registerScript("checkmobilenumberexist", "function checkmobilenumberexist(mobile) {  
        var tel_code=$('#LeadCustomer_mobile_code').val();
            jQuery.ajax({
                'dataType':'json', 
                'data' : {
                    'tel_code':tel_code,
                    'mobile':mobile
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('lead/checkmobilenumberexist') . "',
                'cache': false,
                'success': function(data) {
                    if(data.status=='error'){
                        t8.error('Mobile number already exist for the customer '+data.customer_name);
                        $('#LeadCustomer_mobile_number').val('');
                        $('#LeadCustomer_mobile_number').focus();
                    }
                },
                
        });
    };", CClientScript::POS_HEAD);
    ?>
<script>
    $().ready(function () {
        $('#LeadCustomer_titleText').removeAttr("style");
       // $("#LeadCustomer_customer_country_id").msDropDown();//lidiya 
       // $("#LeadCustomer_customer_source_prospect").msDropDown();//lidiya

    });
</script>




