<?php
$arr_provider_list = Provider::model()->findAll(array('condition' => 'is_active="Y"'));
if ($modelPlanDetails->payment_term > 0) {
    $modelPlanDetails->payment_term = MasPlanPaymentTerms::getPaymentTermIdWithTime($modelPlanDetails->payment_term);
}
$plan_name= MasProviderPlans::model()->findByPK($modelPlanDetails->plan_id)->plan_name;
$provider_name=Provider::model()->findByPK($modelPlanDetails->provider_id)->provider_name;
$last_paid_ins  = CustomerPlanInstallments::model()->find(array('condition'=>'cus_plan_id='.$modelPlanDetails->id.' AND status="P"','order'=>'payment_due_date Desc'))->installment_no;
$total_ins      = CustomerPlanInstallments::model()->find(array('condition'=>'cus_plan_id='.$modelPlanDetails->id,'order'=>'payment_due_date Desc'))->installment_no;
 
?>
<ul class="clearfix form-ul material" style="border: 1px solid #e5e5e5;">
    <li class="col-sm-3">
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'id'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'provider_id'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'plan_id'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'class_ids'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'subclass_ids'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'payment_term'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'annualized_premium'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'policy_status'); ?>
        <?php echo CHtml::hiddenField('last_paid_ins_no',(int)$last_paid_ins); ?>
        <?php echo CHtml::hiddenField('total_installments',$total_ins); ?>
        <?php echo CHtml::textField('provider_name', $provider_name, array('class' => 'tooltipster', 'data-label' => 'Provider <span style="color:red;">* <img src="/images/plan-name.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::textField('plan_name', $plan_name, array('class' => 'tooltipster', 'data-label' => 'Plan<span style="color:red;">* <img src="/images/plan-name.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'policy_no', array('class' => 'tooltipster', 'title' => 'Policy No', 'data-label' => 'Policy No <span style="color:red;">* <img src="/images/plan-name.png" style="padding-left: 10px;"></span>','readonly'=>true)); ?>
    </li>    
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'start_date', array('class' => 'tooltipster', 'title' => 'Start Date', 'data-label' => 'Start Date <span style="color:red;">* <img src="/images/start-date.png" style="padding-left: 10px;"></span>','readonly'=>true)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'tennure',  array('class' => 'tooltipster', 'title' => 'Tennure', 'data-label' => 'Policy Term <span style="color:red;">* <img src="/images/tennure.png" style="padding-left: 10px;"></span>','readonly'=>true)); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'amount', array('class' => 'tooltipster', 'title' => 'Amount', 'data-label' => 'Current Premium Amount (<b>$</b>) <span style="color:red;">* <img src="/images/amount.png" style="padding-left: 10px;"></span>', 'readonly' => 'true', 'style' => 'text-align:right')); ?>
    </li>
    <li class="col-sm-2">
        <?php 
        $payment_term=MasPlanPaymentTerms::model()->findByPk($modelPlanDetails->payment_term)->payment_term;
        echo CHtml::textField('payment_term',$payment_term, array('class' => 'tooltipster', 'title' => 'Payment Terms', 'data-label' => 'Mode of Payment <span style="color:red;">* <img src="/images/payment-term.png" style="padding-left: 10px;"></span>', 'empty' => '--Select--','readonly'=>true)); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::textField('from_installment','', array('class' => 'tooltipster', 'title' => 'From Installment No', 'data-label' => 'From Installment No <span style="color:red;">* <img src="/images/premium.png" style="padding-left: 10px;"></span>', 'style' => 'text-align:right','onblur'=>'checkinstallment()','onkeypress' => 'return isNumberKey(event)')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::textField('effective_due_date','', array('class' => 'tooltipster', 'title' => 'Effective Date', 'data-label' => 'Effective Date <span style="color:red;">* <img src="/images/premium.png" style="padding-left: 10px;"></span>','readonly'=>'true')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::textField('incremented_amount','', array('class' => 'tooltipster', 'title' => 'Incremented Premium', 'data-label' => 'Incremented Premium <span style="color:red;">* <img src="/images/premium.png" style="padding-left: 10px;"></span>', 'style' => 'text-align:right','onkeyup'=>'calculatenewpremium()')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::textField('new_premium','', array('class' => 'tooltipster', 'title' => 'New Premium', 'data-label' => 'New Premium <span style="color:red;">* <img src="/images/premium.png" style="padding-left: 10px;"></span>', 'style' => 'text-align:right')); ?>
    </li>
    
    <?php //if(((int) Yii::app()->user->havePermissionOn["customer_plan_save"])){   ?>
    <li class="col-sm-1">
        <button style="margin-top:24px;margin-left: -9px;" type="button" class="customer-plan-details-save-btn btn btn-theme" onclick="saveIncremetedPlan();">Save Incremented Premium</button>
    </li>
    <?php //} ?>
</ul>

<?php
$cs = Yii::app()->getClientScript();

/* * ************** Start Calculate_Premium***************************** */
$cs->registerScript("checkinstallment", "function checkinstallment(){
    var plan_id             =  $('#CustomerPlanDetails_id').val(); 
    var ins_no              =  $('#from_installment').val();
    var last_paid_ins_no    =  $('#last_paid_ins_no').val();
    var total_installments  =  $('#total_installments').val();
    if(parseFloat(ins_no) > last_paid_ins_no && parseFloat(ins_no) <= total_installments){
        var pars = 'plan_id='+plan_id+'&ins_no='+parseFloat(ins_no);
        var url = $('#liveSite').val()+'index.php?r=customer/getPremiumDateFromInstallment';
        $.ajax({
            type: 'post',
            url:  url,
            data: pars,
            dataType: 'json',
            success: function(responseData, textStatus, jqXHR) {
                $('#loader').hide();
                if(responseData.status=='success'){  
                    $('#effective_due_date').val(responseData.due_date);     
                } else { 
                     $.each(responseData, function(key, val) {
                            t8.error(''+val+''); 
                        }); 
                        $('#from_installment').val('');
            $('#effective_due_date').val('');
                } 
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log(errorThrown);
                }
        })
    }else{
        if(parseFloat(ins_no) <= last_paid_ins_no){
            t8.warning('Installment Paid Upto '+last_paid_ins_no+'.');
            $('#from_installment').val('');
            $('#effective_due_date').val('');
        }
        if(parseFloat(ins_no) > total_installments){
            t8.warning('Only '+total_installments+' Installments are there.');
            $('#from_installment').val('');
            $('#effective_due_date').val('');
        }
    }
           
}", CClientScript::POS_END);
$cs->registerScript("calculatenewpremium", "function calculatenewpremium(){
    var inc_amount               =  $('#incremented_amount').val();
    var new_premium              = 0;
    if(parseFloat(inc_amount) >0){
        var current_premium         = $('#CustomerPlanDetails_amount').val();
        var new_premium             = parseFloat(inc_amount)+parseFloat(current_premium);
        new_premium                 = parseFloat(new_premium).toFixed(2);
        $('#new_premium').val(new_premium);
    }else{
        t8.warning('Incremented Amount Should be Greater than zero');
    }
           
}", CClientScript::POS_END);
/* * ************** End Calculate_Premium***************************** */
/* * ************** START save DecremetedPlan details ***************************** */
$cs->registerScript("saveIncremetedPlan", "function saveIncremetedPlan(){
    var plan_id                     =  $('#CustomerPlanDetails_id').val(); 
    var inc_amount                  =  $('#incremented_amount').val(); 
    var current_premium             =  $('#CustomerPlanDetails_amount').val();
    var inst_no                     =  $('#from_installment').val();
    if(parseFloat(inc_amount) >0 && parseFloat(inst_no)>0){
        var amount                  =  $('#CustomerPlanDetails_amount').val();  
        var pars = 'plan_id='+plan_id+'&inc_amount='+parseFloat(inc_amount)+'&amount='+amount+'&current_premium='+current_premium+'&inst_no='+inst_no;
        var url = $('#liveSite').val()+'index.php?r=customer/saveIncremetedPlan';
        $.ajax({
            type: 'post',
            url:  url,
            data: pars,
            dataType: 'json',
            success: function(responseData, textStatus, jqXHR) {
                $('#loader').hide();
                if(responseData.status=='success'){  
                        t8.success('Incremented Premium Details Updated Successfully!');
                        addEditPlanDetails();
                        reloadTable('#tbl_customer_plan_details');
                } else { 
                     $.each(responseData, function(key, val) {
                            $('#customer-form #'+key+'_em_').text(val).show(); 
                            t8.error(''+val+''); 
                        }); 
                } 
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log(errorThrown);
                }
        })
    }else{
        t8.warning('Incremented Amount and From Installment Should be Greater than zero');
    }    
}", CClientScript::POS_END);
/* * ************** END save DecremetedPlan details ***************************** */