<?php
$arr_provider_list = Provider::model()->findAll(array('condition' => 'is_active="Y"'));
if ($modelPlanDetails->payment_term > 0) {
    $modelPlanDetails->payment_term = MasPlanPaymentTerms::getPaymentTermIdWithTime($modelPlanDetails->payment_term);
}
$provider_name=Provider::model()->findByPK($modelPlanDetails->provider_id)->provider_name;
$plan_name= MasProviderPlans::model()->findByPK($modelPlanDetails->plan_id)->plan_name;
$provider_name=Provider::model()->findByPK($modelPlanDetails->provider_id)->provider_name;
?>
<ul class="clearfix form-ul material" style="border: 1px solid #e5e5e5;">
    <li class="col-sm-3">
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'id'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'provider_id'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'plan_id'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'class_ids'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'subclass_ids'); ?>
        <?php echo CHtml::activeHiddenField($modelPlanDetails, 'policy_status'); ?>
        <?php echo CHtml::textField('provider_name', $provider_name, array('class' => 'tooltipster', 'data-label' => 'Provider <span style="color:red;">* <img src="/images/plan-name.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::textField('plan_name', $plan_name, array('class' => 'tooltipster', 'data-label' => 'Plan<span style="color:red;">* <img src="/images/plan-name.png" style="padding-left: 10px;"></span>')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'policy_no', array('class' => 'tooltipster', 'title' => 'Policy No', 'data-label' => 'Policy No <span style="color:red;">* <img src="/images/plan-name.png" style="padding-left: 10px;"></span>','readonly'=>true)); ?>
    </li>    
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'start_date', array('class' => 'tooltipster', 'title' => 'Start Date', 'data-label' => 'Start Date <span style="color:red;">* <img src="/images/start-date.png" style="padding-left: 10px;"></span>','readonly'=>true)); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'tennure',  array('class' => 'tooltipster', 'title' => 'Tennure', 'data-label' => 'Tenure <span style="color:red;">* <img src="/images/tennure.png" style="padding-left: 10px;"></span>','readonly'=>true)); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'amount', array('class' => 'tooltipster', 'title' => 'Amount', 'data-label' => 'Premium Amount (<b>$</b>) <span style="color:red;">* <img src="/images/amount.png" style="padding-left: 10px;"></span>', 'readonly' => 'true', 'style' => 'text-align:right')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo CHtml::activeDropdownList($modelPlanDetails, 'payment_term', MasPlanPaymentTerms::getPlanPaymentTermsWithTimes(), array('class' => 'tooltipster', 'title' => 'Payment Terms', 'data-label' => 'Payment Terms <span style="color:red;">* <img src="/images/payment-term.png" style="padding-left: 10px;"></span>', 'empty' => '--Select--','onchange'=>'Calculate_Premium_amount()')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo CHtml::activeTextField($modelPlanDetails, 'annualized_premium', array('class' => 'tooltipster', 'title' => 'Annualized Premium', 'data-label' => 'Annualized Premium <span style="color:red;">* <img src="/images/premium.png" style="padding-left: 10px;"></span>', 'readonly' => true, 'style' => 'text-align:right')); ?>
    </li>
    
    <?php //if(((int) Yii::app()->user->havePermissionOn["customer_plan_save"])){   ?>
    <li class="col-sm-1">
        <button style="margin-top:24px;margin-left: -9px;" type="button" class="customer-plan-details-save-btn btn btn-theme" onclick="savePayterm();">Change Payment Term</button>
    </li>
    <?php //} ?>
</ul>

<?php
$cs = Yii::app()->getClientScript();

/* * ************** Start Calculate_Premium***************************** */
$cs->registerScript("Calculate_Premium_amount", "function Calculate_Premium_amount(){
    var plan_id                     =  $('#CustomerPlanDetails_id').val(); 
    var payment_term                = $('#CustomerPlanDetails_payment_term').val(); 
    if(payment_term !=''){
        var arr_payment_term            =  payment_term.split('#');
        var payment_term_months         =  arr_payment_term[1]; 
        var payment_term_id             =  arr_payment_term[0]; 
        var annualized_premium          =  $('#CustomerPlanDetails_annualized_premium').val();
        var amount                      = annualized_premium/payment_term_months;
        $('#CustomerPlanDetails_amount').val(amount.toFixed(2));   
        var url                 = $('#liveSite').val()+'index.php?r=customer/getselectedpaytermDetails';
        var pars                = 'plan_id='+plan_id+'&payment_term='+payment_term;
        $.ajax({
            dataType:'json',
            type: 'post',
            url:  url,
            data: pars,
            success: function(data) {
                if(data.status=='success'){
                    t8.info(data.message);
                }
            },            
        })
    }else{
        t8.warning('Please Select Payment Term');
    }
            
}", CClientScript::POS_END);
/* * ************** End Calculate_Premium***************************** */
/* * ************** START save payterm details ***************************** */
$cs->registerScript("savePayterm", "function savePayterm(){
    var plan_id                     =  $('#CustomerPlanDetails_id').val(); 
    var payment_term                = $('#CustomerPlanDetails_payment_term').val(); 
    if(payment_term !=''){
        var annualized_premium      =  $('#CustomerPlanDetails_annualized_premium').val();  
        var amount                  =  $('#CustomerPlanDetails_amount').val();  
        var pars = 'plan_id='+plan_id+'&payment_term='+payment_term+'&amount='+amount+'&annualized_premium='+annualized_premium;
        var url = $('#liveSite').val()+'index.php?r=customer/saveplanpaytermdetails';
        $.ajax({
            type: 'post',
            url:  url,
            data: pars,
            dataType: 'json',
            success: function(responseData, textStatus, jqXHR) {
                $('#loader').hide();
                if(responseData.status=='success'){  
                        t8.success('Plan Payment Term Details Updated Successfully!');
                        addEditPlanDetails();
                        reloadTable('#tbl_customer_plan_details');
                } else { 
                     $.each(responseData, function(key, val) {
                            $('#customer-form #'+key+'_em_').text(val).show(); 
                            t8.error(''+val+''); 
                        }); 
                } 
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log(errorThrown);
                }
        })
    }else{
        t8.warning('Please Select Payment Term');
    }    
}", CClientScript::POS_END);
/* * ************** END save payterm details ***************************** */