<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadCommissiondetails", '$(document).ready(function() {
        filterDataTable();
    });', CClientScript::POS_HEAD);
$cs->registerScript("loaddetails", 'function filterDataTable(){
        var provider_id=$("#provider_name_download").val();
        var table_id ="#tbl_download_commission_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
//            scrollX         : "true",
           // scrollCollapse  : true,
           "bAutoWidth": true,
            pageLength      : 50,
            processing: true,                       
            //bSort: false,
            order: [[ 2, "asc" ]],
            "columnDefs": [
                { "bSortable": false, "aTargets": [0,2,3,4,5] },
                 ],
            ajax: {
                url: "' . Yii::app()->createUrl('commissiondownload/getlist') . '",
                type: "POST",
                "data" : {
                    "provider_id" : provider_id,
                },
                cache : false,
            },          
            serverSide:     true,
            fixedColumns:   true,
            processing: true,           
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            
        });
        $(".dataTables_scrollFoot").hide();
    }', CClientScript::POS_HEAD);
$cs->registerScript("getcommisiondetails",  "function getcommisiondetails(){  
    $('#tbl_download_commission_details').DataTable().destroy();
    filterDataTable();
   
};", CClientScript::POS_HEAD); 
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-download"></i> Commission List
        <div class="pull-right" style="display: inline-flex;">
             <?php
            echo CHtml::dropdownlist('provider_name_download','',Provider::getAll(),  array('class'=>'activity-dropdown-1','title' => 'Please Select Provider','onchange'=>'getcommisiondetails();','empty'=>'Providers')); 
            ?>                   
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_download_commission_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Provider Name</th>
                        <th>Statement Date</th>
                        <th>Uploaded By</th>
                        <th>Uploaded On</th>
                        <th align="center">Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Provider Name</th>
                        <th>Statement Date</th>
                        <th>Uploaded By</th>
                        <th>Uploaded On</th>
                        <th align="center">Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
